/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jaxrs.deployment;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.core.Application;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.jaxrs.deployment.JaxrsAttachments;
import org.jboss.as.jaxrs.deployment.JaxrsDeploymentMarker;
import org.jboss.as.jaxrs.deployment.ResteasyDeploymentData;
import org.jboss.as.jaxrs.logging.JaxrsLogger;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.as.web.common.WarMetaData;
import org.jboss.metadata.javaee.spec.ParamValueMetaData;
import org.jboss.metadata.javaee.support.MappableMetaData;
import org.jboss.metadata.web.jboss.JBossServletMetaData;
import org.jboss.metadata.web.jboss.JBossServletsMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.spec.FilterMetaData;
import org.jboss.metadata.web.spec.ServletMappingMetaData;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.resteasy.plugins.server.servlet.HttpServlet30Dispatcher;

public class JaxrsIntegrationProcessor
implements DeploymentUnitProcessor {
    private static final String JAX_RS_SERVLET_NAME = "javax.ws.rs.core.Application";
    private static final String SERVLET_INIT_PARAM = "javax.ws.rs.Application";
    public static final String RESTEASY_SCAN = "resteasy.scan";
    public static final String RESTEASY_SCAN_RESOURCES = "resteasy.scan.resources";
    public static final String RESTEASY_SCAN_PROVIDERS = "resteasy.scan.providers";

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        Iterator<Class<? extends Application>> providers;
        StringBuffer buf;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (!JaxrsDeploymentMarker.isJaxrsDeployment(deploymentUnit)) {
            return;
        }
        if (!DeploymentTypeMarker.isType((DeploymentType)DeploymentType.WAR, (DeploymentUnit)deploymentUnit)) {
            return;
        }
        DeploymentUnit parent = deploymentUnit.getParent() == null ? deploymentUnit : deploymentUnit.getParent();
        WarMetaData warMetaData = (WarMetaData)deploymentUnit.getAttachment(WarMetaData.ATTACHMENT_KEY);
        JBossWebMetaData webdata = warMetaData.getMergedJBossWebMetaData();
        ResteasyDeploymentData resteasy = (ResteasyDeploymentData)deploymentUnit.getAttachment(JaxrsAttachments.RESTEASY_DEPLOYMENT_DATA);
        if (resteasy == null) {
            return;
        }
        deploymentUnit.getDeploymentSubsystemModel("jaxrs");
        List params = webdata.getContextParams();
        boolean entityExpandEnabled = false;
        if (params != null) {
            Iterator it = params.iterator();
            while (it.hasNext()) {
                ParamValueMetaData param = (ParamValueMetaData)it.next();
                if (param.getParamName().equals(RESTEASY_SCAN)) {
                    it.remove();
                    continue;
                }
                if (param.getParamName().equals(RESTEASY_SCAN_RESOURCES)) {
                    it.remove();
                    continue;
                }
                if (param.getParamName().equals(RESTEASY_SCAN_PROVIDERS)) {
                    it.remove();
                    continue;
                }
                if (!param.getParamName().equals("resteasy.document.expand.entity.references")) continue;
                entityExpandEnabled = true;
            }
        }
        if (!entityExpandEnabled) {
            JaxrsIntegrationProcessor.setContextParameter(webdata, "resteasy.document.expand.entity.references", "false");
        }
        Map attachmentMap = (Map)parent.getAttachment(JaxrsAttachments.ADDITIONAL_RESTEASY_DEPLOYMENT_DATA);
        ArrayList<ResteasyDeploymentData> additionalData = new ArrayList<ResteasyDeploymentData>();
        ModuleSpecification moduleSpec = (ModuleSpecification)deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
        if (moduleSpec != null && attachmentMap != null) {
            HashSet<ModuleIdentifier> identifiers = new HashSet<ModuleIdentifier>();
            for (ModuleDependency moduleDependency : moduleSpec.getAllDependencies()) {
                if (identifiers.contains(moduleDependency.getIdentifier())) continue;
                identifiers.add(moduleDependency.getIdentifier());
                if (!attachmentMap.containsKey(moduleDependency.getIdentifier())) continue;
                additionalData.add((ResteasyDeploymentData)attachmentMap.get(moduleDependency.getIdentifier()));
            }
            resteasy.merge(additionalData);
        }
        if (!resteasy.getScannedResourceClasses().isEmpty()) {
            buf = null;
            for (String string : resteasy.getScannedResourceClasses()) {
                if (buf == null) {
                    buf = new StringBuffer();
                    buf.append(string);
                    continue;
                }
                buf.append(",").append(string);
            }
            String resources = buf.toString();
            JaxrsLogger.JAXRS_LOGGER.debugf("Adding JAX-RS resource classes: %s", resources);
            JaxrsIntegrationProcessor.setContextParameter(webdata, "resteasy.scanned.resources", resources);
        }
        if (!resteasy.getScannedProviderClasses().isEmpty()) {
            buf = null;
            for (String string : resteasy.getScannedProviderClasses()) {
                if (buf == null) {
                    buf = new StringBuffer();
                    buf.append(string);
                    continue;
                }
                buf.append(",").append(string);
            }
            providers = buf.toString();
            JaxrsLogger.JAXRS_LOGGER.debugf("Adding JAX-RS provider classes: %s", providers);
            JaxrsIntegrationProcessor.setContextParameter(webdata, "resteasy.scanned.providers", (String)((Object)providers));
        }
        if (!resteasy.getScannedJndiComponentResources().isEmpty()) {
            buf = null;
            for (String string : resteasy.getScannedJndiComponentResources()) {
                if (buf == null) {
                    buf = new StringBuffer();
                    buf.append(string);
                    continue;
                }
                buf.append(",").append(string);
            }
            providers = buf.toString();
            JaxrsLogger.JAXRS_LOGGER.debugf("Adding JAX-RS jndi component resource classes: %s", providers);
            JaxrsIntegrationProcessor.setContextParameter(webdata, "resteasy.scanned.jndi.resources", providers);
        }
        if (!resteasy.isUnwrappedExceptionsParameterSet()) {
            JaxrsIntegrationProcessor.setContextParameter(webdata, "resteasy.unwrapped.exceptions", "javax.ejb.EJBException");
        }
        if (resteasy.hasBootClasses() || resteasy.isDispatcherCreated()) {
            return;
        }
        HashSet<Class<? extends Application>> applicationClassSet = new HashSet<Class<? extends Application>>();
        for (Class<? extends Application> clazz : resteasy.getScannedApplicationClasses()) {
            if (!clazz.isAnnotationPresent(ApplicationPath.class) && !JaxrsIntegrationProcessor.servletMappingsExist(webdata, clazz.getName())) continue;
            applicationClassSet.add(clazz);
        }
        if (applicationClassSet.size() == 0) {
            JBossServletMetaData servlet = new JBossServletMetaData();
            servlet.setName(JAX_RS_SERVLET_NAME);
            servlet.setServletClass(HttpServlet30Dispatcher.class.getName());
            servlet.setAsyncSupported(true);
            this.addServlet(webdata, servlet);
            this.setServletMappingPrefix(webdata, JAX_RS_SERVLET_NAME, servlet);
            return;
        }
        for (Class clazz : applicationClassSet) {
            String servletName = null;
            servletName = clazz.getName();
            JBossServletMetaData servlet = new JBossServletMetaData();
            servlet.setLoadOnStartup("0");
            servlet.setName(servletName);
            servlet.setServletClass(HttpServlet30Dispatcher.class.getName());
            servlet.setAsyncSupported(true);
            this.setServletInitParam(servlet, SERVLET_INIT_PARAM, clazz.getName());
            this.addServlet(webdata, servlet);
            if (!JaxrsIntegrationProcessor.servletMappingsExist(webdata, servletName)) {
                try {
                    ArrayList<String> patterns = new ArrayList<String>();
                    String pathValue = URLDecoder.decode(clazz.getAnnotation(ApplicationPath.class).value().trim(), "UTF-8");
                    if (!pathValue.startsWith("/")) {
                        pathValue = "/" + pathValue;
                    }
                    String prefix = pathValue;
                    pathValue = pathValue.endsWith("/") ? pathValue + "*" : pathValue + "/*";
                    patterns.add(pathValue);
                    this.setServletInitParam(servlet, "resteasy.servlet.mapping.prefix", prefix);
                    ServletMappingMetaData mapping = new ServletMappingMetaData();
                    mapping.setServletName(servletName);
                    mapping.setUrlPatterns(patterns);
                    if (webdata.getServletMappings() == null) {
                        webdata.setServletMappings(new ArrayList());
                    }
                    webdata.getServletMappings().add(mapping);
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
            this.setServletMappingPrefix(webdata, servletName, servlet);
        }
    }

    protected void setServletInitParam(JBossServletMetaData servlet, String name, String value) {
        ParamValueMetaData param = new ParamValueMetaData();
        param.setParamName(name);
        param.setParamValue(value);
        ArrayList<ParamValueMetaData> params = servlet.getInitParam();
        if (params == null) {
            params = new ArrayList<ParamValueMetaData>();
            servlet.setInitParam(params);
        }
        params.add(param);
    }

    private void setServletMappingPrefix(JBossWebMetaData webdata, String servletName, JBossServletMetaData servlet) {
        List mappings = webdata.getServletMappings();
        if (mappings != null) {
            boolean mappingSet = false;
            for (ServletMappingMetaData mapping : mappings) {
                if (!mapping.getServletName().equals(servletName) || mapping.getUrlPatterns() == null) continue;
                for (String pattern : mapping.getUrlPatterns()) {
                    if (mappingSet) {
                        JaxrsLogger.JAXRS_LOGGER.moreThanOneServletMapping(servletName, pattern);
                        continue;
                    }
                    mappingSet = true;
                    String realPattern = pattern;
                    if (realPattern.endsWith("*")) {
                        realPattern = realPattern.substring(0, realPattern.length() - 1);
                    }
                    this.setServletInitParam(servlet, "resteasy.servlet.mapping.prefix", realPattern);
                }
            }
        }
    }

    private void addServlet(JBossWebMetaData webdata, JBossServletMetaData servlet) {
        if (webdata.getServlets() == null) {
            webdata.setServlets(new JBossServletsMetaData());
        }
        webdata.getServlets().add((MappableMetaData)servlet);
    }

    public void undeploy(DeploymentUnit context) {
    }

    protected void setFilterInitParam(FilterMetaData filter, String name, String value) {
        ParamValueMetaData param = new ParamValueMetaData();
        param.setParamName(name);
        param.setParamValue(value);
        ArrayList<ParamValueMetaData> params = filter.getInitParam();
        if (params == null) {
            params = new ArrayList<ParamValueMetaData>();
            filter.setInitParam(params);
        }
        params.add(param);
    }

    public static ParamValueMetaData findContextParam(JBossWebMetaData webdata, String name) {
        List params = webdata.getContextParams();
        if (params == null) {
            return null;
        }
        for (ParamValueMetaData param : params) {
            if (!param.getParamName().equals(name)) continue;
            return param;
        }
        return null;
    }

    public static ParamValueMetaData findInitParam(JBossWebMetaData webdata, String name) {
        JBossServletsMetaData servlets = webdata.getServlets();
        if (servlets == null) {
            return null;
        }
        for (JBossServletMetaData servlet : servlets) {
            List initParams = servlet.getInitParam();
            if (initParams == null) continue;
            for (ParamValueMetaData param : initParams) {
                if (!param.getParamName().equals(name)) continue;
                return param;
            }
        }
        return null;
    }

    public static boolean servletMappingsExist(JBossWebMetaData webdata, String servletName) {
        List mappings = webdata.getServletMappings();
        if (mappings == null) {
            return false;
        }
        for (ServletMappingMetaData mapping : mappings) {
            if (!mapping.getServletName().equals(servletName)) continue;
            return true;
        }
        return false;
    }

    public static void setContextParameter(JBossWebMetaData webdata, String name, String value) {
        ParamValueMetaData param = new ParamValueMetaData();
        param.setParamName(name);
        param.setParamValue(value);
        ArrayList<ParamValueMetaData> params = webdata.getContextParams();
        if (params == null) {
            params = new ArrayList<ParamValueMetaData>();
            webdata.setContextParams(params);
        }
        params.add(param);
    }
}

