/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;

public final class Version {
    private static final Pattern JAVA_VERSION_PATTERN = Pattern.compile("^(?:1\\.)?(\\d+)$");
    private static Log LOG = LoggerFactory.make();
    private static int JAVA_RELEASE = Version.determineJavaRelease(System.getProperty("java.specification.version"));

    public static String getVersionString() {
        return "5.2.3.Final";
    }

    public static void touch() {
    }

    public static int getJavaRelease() {
        return JAVA_RELEASE;
    }

    public static int determineJavaRelease(String specificationVersion) {
        Matcher matcher;
        if (specificationVersion != null && !specificationVersion.trim().isEmpty() && (matcher = JAVA_VERSION_PATTERN.matcher(specificationVersion)).find()) {
            return Integer.valueOf(matcher.group(1));
        }
        LOG.unknownJvmVersion(specificationVersion);
        return 6;
    }

    private Version() {
    }

    static {
        LOG.version(Version.getVersionString());
    }
}

