/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.naming;

import java.util.HashSet;
import java.util.Map;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.ComponentNamingMode;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.BinderService;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.ServerEnvironmentService;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.msc.inject.InjectionException;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;

public class InstanceNameBindingProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        EEModuleDescription moduleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        if (moduleDescription == null) {
            return;
        }
        ServiceTarget serviceTarget = phaseContext.getServiceTarget();
        if (DeploymentTypeMarker.isType(DeploymentType.WAR, deploymentUnit) || DeploymentTypeMarker.isType(DeploymentType.APPLICATION_CLIENT, deploymentUnit)) {
            ServiceName moduleContextServiceName = ContextNames.contextServiceNameOfModule((String)moduleDescription.getApplicationName(), (String)moduleDescription.getModuleName());
            this.bindServices(deploymentUnit, serviceTarget, moduleContextServiceName);
        }
        for (ComponentDescription component : moduleDescription.getComponentDescriptions()) {
            if (component.getNamingMode() != ComponentNamingMode.CREATE) continue;
            ServiceName compContextServiceName = ContextNames.contextServiceNameOfComponent((String)moduleDescription.getApplicationName(), (String)moduleDescription.getModuleName(), (String)component.getComponentName());
            this.bindServices(deploymentUnit, serviceTarget, compContextServiceName);
        }
    }

    private void bindServices(DeploymentUnit deploymentUnit, ServiceTarget serviceTarget, ServiceName contextServiceName) {
        ServiceName instanceNameServiceName = contextServiceName.append(new String[]{"InstanceName"});
        final BinderService instanceNameService = new BinderService("InstanceName");
        serviceTarget.addService(instanceNameServiceName, (Service)instanceNameService).addDependency(contextServiceName, ServiceBasedNamingStore.class, (Injector)instanceNameService.getNamingStoreInjector()).addDependency(ServerEnvironmentService.SERVICE_NAME, ServerEnvironment.class, (Injector)new Injector<ServerEnvironment>(){

            public void inject(final ServerEnvironment serverEnvironment) throws InjectionException {
                instanceNameService.getManagedObjectInjector().inject((Object)new ManagedReferenceFactory(){

                    public ManagedReference getReference() {
                        return new ManagedReference(){

                            public void release() {
                            }

                            public Object getInstance() {
                                String nodeName = serverEnvironment.getNodeName();
                                return nodeName == null ? "" : nodeName;
                            }
                        };
                    }
                });
            }

            public void uninject() {
                instanceNameService.getManagedObjectInjector().uninject();
            }
        }).install();
        Map jndiComponentDependencies = (Map)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.COMPONENT_JNDI_DEPENDENCIES);
        HashSet<ServiceName> jndiDependencies = (HashSet<ServiceName>)jndiComponentDependencies.get(contextServiceName);
        if (jndiDependencies == null) {
            jndiDependencies = new HashSet<ServiceName>();
            jndiComponentDependencies.put(contextServiceName, jndiDependencies);
        }
        jndiDependencies.add(instanceNameServiceName);
    }

    public void undeploy(DeploymentUnit context) {
    }
}

