/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl;

import java.util.Properties;
import org.hibernate.search.backend.spi.Backend;
import org.hibernate.search.backend.spi.BackendQueueProcessor;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.spi.WorkerBuildContext;
import org.hibernate.search.util.impl.ClassLoaderHelper;

public class ReflectionBasedBackend
implements Backend {
    private final Class<? extends BackendQueueProcessor> backendQueueProcessorClass;
    private Properties properties;

    public ReflectionBasedBackend(Class<? extends BackendQueueProcessor> backendQueueProcessorClass) {
        this.backendQueueProcessorClass = backendQueueProcessorClass;
    }

    @Override
    public void initialize(Properties properties, WorkerBuildContext context) {
        this.properties = properties;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.backendQueueProcessorClass + "]";
    }

    @Override
    public boolean isTransactional() {
        return BackendQueueProcessor.Transactional.class.isAssignableFrom(this.backendQueueProcessorClass);
    }

    @Override
    public BackendQueueProcessor createQueueProcessor(IndexManager indexManager, WorkerBuildContext context) {
        BackendQueueProcessor backendQueueProcessor = ClassLoaderHelper.instanceFromClass(BackendQueueProcessor.class, this.backendQueueProcessorClass, "Backend queue processor ");
        backendQueueProcessor.initialize(this.properties, context, indexManager);
        return backendQueueProcessor;
    }
}

