/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands.tools.journal;

import io.airlift.airline.Command;
import java.io.File;
import org.apache.activemq.artemis.cli.commands.ActionContext;
import org.apache.activemq.artemis.cli.commands.tools.LockAbstract;
import org.apache.activemq.artemis.core.config.impl.FileConfiguration;
import org.apache.activemq.artemis.core.io.IOCriticalErrorListener;
import org.apache.activemq.artemis.core.io.SequentialFileFactory;
import org.apache.activemq.artemis.core.io.nio.NIOSequentialFileFactory;
import org.apache.activemq.artemis.core.journal.impl.JournalImpl;

@Command(name="compact", description="Compacts the journal of a non running server")
public final class CompactJournal
extends LockAbstract {
    @Override
    public Object execute(ActionContext context) throws Exception {
        super.execute(context);
        try {
            FileConfiguration configuration = this.getFileConfiguration();
            this.compactJournal(new File(this.getJournal()), "activemq-data", "amq", configuration.getJournalMinFiles(), configuration.getJournalFileSize(), null);
            System.out.println("Compactation succeeded for " + this.getJournal());
            this.compactJournal(new File(this.getBinding()), "activemq-bindings", "bindings", 2, 0x100000, null);
            System.out.println("Compactation succeeded for " + this.getBinding());
        }
        catch (Exception e) {
            this.treatError(e, "data", "compact");
        }
        return null;
    }

    private void compactJournal(File directory, String journalPrefix, String journalSuffix, int minFiles, int fileSize, IOCriticalErrorListener listener) throws Exception {
        NIOSequentialFileFactory nio = new NIOSequentialFileFactory(directory, listener, 1);
        JournalImpl journal = new JournalImpl(fileSize, minFiles, minFiles, 0, 0, (SequentialFileFactory)nio, journalPrefix, journalSuffix, 1);
        journal.start();
        journal.loadInternalOnly();
        journal.compact();
        journal.stop();
    }
}

