/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.filters;

import io.undertow.server.handlers.proxy.mod_cluster.ModClusterStatus;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PrimitiveListAttributeDefinition;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.extension.undertow.UndertowExtension;
import org.wildfly.extension.undertow.filters.ModClusterContextDefinition;
import org.wildfly.extension.undertow.filters.ModClusterResource;
import org.wildfly.extension.undertow.filters.ModClusterService;
import org.wildfly.extension.undertow.logging.UndertowLogger;

public class ModClusterNodeDefinition
extends SimpleResourceDefinition {
    public static ModClusterNodeDefinition INSTANCE = new ModClusterNodeDefinition();
    public static final AttributeDefinition LOAD = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("load", ModelType.INT).setRequired(false)).setStorageRuntime()).build();
    public static final AttributeDefinition STATUS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("status", ModelType.STRING).setRequired(false)).setStorageRuntime()).build();
    public static final AttributeDefinition LOAD_BALANCING_GROUP = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("load-balancing-group", ModelType.STRING).setRequired(false)).setStorageRuntime()).build();
    public static final AttributeDefinition CACHE_CONNECTIONS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("cache-connections", ModelType.INT).setRequired(false)).setStorageRuntime()).build();
    public static final AttributeDefinition MAX_CONNECTIONS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("max-connections", ModelType.INT).setRequired(false)).setStorageRuntime()).build();
    public static final AttributeDefinition OPEN_CONNECTIONS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("open-connections", ModelType.INT).setRequired(false)).setStorageRuntime()).build();
    public static final AttributeDefinition PING = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("ping", ModelType.INT).setRequired(false)).setStorageRuntime()).build();
    public static final AttributeDefinition READ = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("read", ModelType.LONG).setRequired(false)).setStorageRuntime()).build();
    public static final AttributeDefinition REQUEST_QUEUE_SIZE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("request-queue-size", ModelType.INT).setRequired(false)).setStorageRuntime()).build();
    public static final AttributeDefinition TIMEOUT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("timeout", ModelType.INT).setRequired(false)).setMeasurementUnit(MeasurementUnit.SECONDS)).setStorageRuntime()).build();
    public static final AttributeDefinition WRITTEN = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("written", ModelType.LONG).setRequired(false)).setStorageRuntime()).build();
    public static final AttributeDefinition TTL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("ttl", ModelType.LONG).setRequired(false)).setStorageRuntime()).build();
    public static final AttributeDefinition FLUSH_PACKETS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("flush-packets", ModelType.BOOLEAN).setRequired(false)).setStorageRuntime()).build();
    public static final AttributeDefinition QUEUE_NEW_REQUESTS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("queue-new-requests", ModelType.BOOLEAN).setRequired(false)).setStorageRuntime()).build();
    public static final AttributeDefinition URI = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("uri", ModelType.STRING).setRequired(false)).setStorageRuntime()).build();
    public static final AttributeDefinition ALIASES = ((PrimitiveListAttributeDefinition.Builder)((PrimitiveListAttributeDefinition.Builder)new PrimitiveListAttributeDefinition.Builder("aliases", ModelType.STRING).setRequired(false)).setStorageRuntime()).build();
    public static final AttributeDefinition ELECTED = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("elected", ModelType.INT).setRequired(false)).setStorageRuntime()).build();
    public final OperationDefinition ENABLE = new SimpleOperationDefinition("enable", this.getResourceDescriptionResolver());
    public final OperationDefinition DISABLE = new SimpleOperationDefinition("disable", this.getResourceDescriptionResolver());
    public final OperationDefinition STOP = new SimpleOperationDefinition("stop", this.getResourceDescriptionResolver());

    ModClusterNodeDefinition() {
        super(new SimpleResourceDefinition.Parameters(UndertowExtension.NODE, (ResourceDescriptionResolver)UndertowExtension.getResolver("handler", "mod-cluster", "balancer", "node")).setRuntime());
    }

    public void registerChildren(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerSubModel((ResourceDefinition)ModClusterContextDefinition.INSTANCE);
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerOperationHandler(this.ENABLE, (OperationStepHandler)new AbstractNodeOperation(){

            @Override
            protected void handleNode(OperationContext context, ModClusterStatus.Node ctx, ModelNode operation) throws OperationFailedException {
                for (ModClusterStatus.Context n : ctx.getContexts()) {
                    n.enable();
                }
            }
        });
        resourceRegistration.registerOperationHandler(this.DISABLE, (OperationStepHandler)new AbstractNodeOperation(){

            @Override
            protected void handleNode(OperationContext context, ModClusterStatus.Node ctx, ModelNode operation) throws OperationFailedException {
                for (ModClusterStatus.Context n : ctx.getContexts()) {
                    n.disable();
                }
            }
        });
        resourceRegistration.registerOperationHandler(this.STOP, (OperationStepHandler)new AbstractNodeOperation(){

            @Override
            protected void handleNode(OperationContext context, ModClusterStatus.Node ctx, ModelNode operation) throws OperationFailedException {
                for (ModClusterStatus.Context n : ctx.getContexts()) {
                    n.stop();
                }
            }
        });
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerReadOnlyAttribute(LOAD, (OperationStepHandler)new AbstractNodeOperation(){

            @Override
            protected void handleNode(OperationContext context, ModClusterStatus.Node ctx, ModelNode operation) throws OperationFailedException {
                context.getResult().set(new ModelNode(ctx.getLoad()));
            }
        });
        resourceRegistration.registerReadOnlyAttribute(STATUS, (OperationStepHandler)new AbstractNodeOperation(){

            @Override
            protected void handleNode(OperationContext context, ModClusterStatus.Node ctx, ModelNode operation) throws OperationFailedException {
                context.getResult().set(new ModelNode(ctx.getStatus().name()));
            }
        });
        resourceRegistration.registerReadOnlyAttribute(LOAD_BALANCING_GROUP, (OperationStepHandler)new AbstractNodeOperation(){

            @Override
            protected void handleNode(OperationContext context, ModClusterStatus.Node ctx, ModelNode operation) throws OperationFailedException {
                String domain = ctx.getDomain();
                if (domain == null) {
                    context.getResult().set(new ModelNode());
                } else {
                    context.getResult().set(new ModelNode(domain));
                }
            }
        });
        resourceRegistration.registerReadOnlyAttribute(CACHE_CONNECTIONS, (OperationStepHandler)new AbstractNodeOperation(){

            @Override
            protected void handleNode(OperationContext context, ModClusterStatus.Node ctx, ModelNode operation) throws OperationFailedException {
                context.getResult().set(new ModelNode(ctx.getCacheConnections()));
            }
        });
        resourceRegistration.registerReadOnlyAttribute(MAX_CONNECTIONS, (OperationStepHandler)new AbstractNodeOperation(){

            @Override
            protected void handleNode(OperationContext context, ModClusterStatus.Node ctx, ModelNode operation) throws OperationFailedException {
                context.getResult().set(new ModelNode(ctx.getMaxConnections()));
            }
        });
        resourceRegistration.registerReadOnlyAttribute(OPEN_CONNECTIONS, (OperationStepHandler)new AbstractNodeOperation(){

            @Override
            protected void handleNode(OperationContext context, ModClusterStatus.Node ctx, ModelNode operation) throws OperationFailedException {
                context.getResult().set(new ModelNode(ctx.getOpenConnections()));
            }
        });
        resourceRegistration.registerReadOnlyAttribute(PING, (OperationStepHandler)new AbstractNodeOperation(){

            @Override
            protected void handleNode(OperationContext context, ModClusterStatus.Node ctx, ModelNode operation) throws OperationFailedException {
                context.getResult().set(new ModelNode(ctx.getPing()));
            }
        });
        resourceRegistration.registerReadOnlyAttribute(READ, (OperationStepHandler)new AbstractNodeOperation(){

            @Override
            protected void handleNode(OperationContext context, ModClusterStatus.Node ctx, ModelNode operation) throws OperationFailedException {
                context.getResult().set(new ModelNode(ctx.getRead()));
            }
        });
        resourceRegistration.registerReadOnlyAttribute(REQUEST_QUEUE_SIZE, (OperationStepHandler)new AbstractNodeOperation(){

            @Override
            protected void handleNode(OperationContext context, ModClusterStatus.Node ctx, ModelNode operation) throws OperationFailedException {
                context.getResult().set(new ModelNode(ctx.getRequestQueueSize()));
            }
        });
        resourceRegistration.registerReadOnlyAttribute(TIMEOUT, (OperationStepHandler)new AbstractNodeOperation(){

            @Override
            protected void handleNode(OperationContext context, ModClusterStatus.Node ctx, ModelNode operation) throws OperationFailedException {
                context.getResult().set(new ModelNode(ctx.getTimeout()));
            }
        });
        resourceRegistration.registerReadOnlyAttribute(WRITTEN, (OperationStepHandler)new AbstractNodeOperation(){

            @Override
            protected void handleNode(OperationContext context, ModClusterStatus.Node ctx, ModelNode operation) throws OperationFailedException {
                context.getResult().set(new ModelNode(ctx.getTransferred()));
            }
        });
        resourceRegistration.registerReadOnlyAttribute(TTL, (OperationStepHandler)new AbstractNodeOperation(){

            @Override
            protected void handleNode(OperationContext context, ModClusterStatus.Node ctx, ModelNode operation) throws OperationFailedException {
                context.getResult().set(new ModelNode(ctx.getTtl()));
            }
        });
        resourceRegistration.registerReadOnlyAttribute(FLUSH_PACKETS, (OperationStepHandler)new AbstractNodeOperation(){

            @Override
            protected void handleNode(OperationContext context, ModClusterStatus.Node ctx, ModelNode operation) throws OperationFailedException {
                context.getResult().set(new ModelNode(ctx.isFlushPackets()));
            }
        });
        resourceRegistration.registerReadOnlyAttribute(QUEUE_NEW_REQUESTS, (OperationStepHandler)new AbstractNodeOperation(){

            @Override
            protected void handleNode(OperationContext context, ModClusterStatus.Node ctx, ModelNode operation) throws OperationFailedException {
                context.getResult().set(new ModelNode(ctx.isQueueNewRequests()));
            }
        });
        resourceRegistration.registerReadOnlyAttribute(URI, (OperationStepHandler)new AbstractNodeOperation(){

            @Override
            protected void handleNode(OperationContext context, ModClusterStatus.Node ctx, ModelNode operation) throws OperationFailedException {
                context.getResult().set(new ModelNode(ctx.getUri().toString()));
            }
        });
        resourceRegistration.registerReadOnlyAttribute(ALIASES, (OperationStepHandler)new AbstractNodeOperation(){

            @Override
            protected void handleNode(OperationContext context, ModClusterStatus.Node ctx, ModelNode operation) throws OperationFailedException {
                ModelNode result = new ModelNode();
                for (String alias : ctx.getAliases()) {
                    UndertowLogger.ROOT_LOGGER.tracef("Adding alias %s", alias);
                    result.add(alias);
                }
                context.getResult().set(result);
            }
        });
        resourceRegistration.registerReadOnlyAttribute(ELECTED, (OperationStepHandler)new AbstractNodeOperation(){

            @Override
            protected void handleNode(OperationContext context, ModClusterStatus.Node ctx, ModelNode operation) throws OperationFailedException {
                context.getResult().set(new ModelNode(ctx.getElected()));
            }
        });
    }

    private abstract class AbstractNodeOperation
    implements OperationStepHandler {
        private AbstractNodeOperation() {
        }

        public final void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            String modClusterName;
            ModClusterService service;
            PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
            int current = address.size() - 1;
            String nodeName = address.getElement(current--).getValue();
            String balancerName = address.getElement(current--).getValue();
            if ((service = ModClusterResource.service(modClusterName = address.getElement(current--).getValue())) == null) {
                context.getResult().set(new ModelNode());
                context.completeStep(OperationContext.ResultHandler.NOOP_RESULT_HANDLER);
                return;
            }
            ModClusterStatus.LoadBalancer balancer = service.getModCluster().getController().getStatus().getLoadBalancer(balancerName);
            if (balancer == null) {
                context.getResult().set(new ModelNode());
                context.completeStep(OperationContext.ResultHandler.NOOP_RESULT_HANDLER);
                return;
            }
            ModClusterStatus.Node node = balancer.getNode(nodeName);
            if (node == null) {
                context.getResult().set(new ModelNode());
                context.completeStep(OperationContext.ResultHandler.NOOP_RESULT_HANDLER);
                return;
            }
            this.handleNode(context, node, operation);
        }

        protected abstract void handleNode(OperationContext var1, ModClusterStatus.Node var2, ModelNode var3) throws OperationFailedException;
    }
}

