/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.core.launcher.logger;

import java.io.Serializable;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Locale;
import org.wildfly.core.launcher.logger.LauncherMessages;

public class LauncherMessages_$bundle
implements LauncherMessages,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final LauncherMessages_$bundle INSTANCE = new LauncherMessages_$bundle();
    private static final Locale LOCALE = Locale.ROOT;

    protected LauncherMessages_$bundle() {
    }

    protected Object readResolve() {
        return INSTANCE;
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String pathDoesNotExist$str() {
        return "WFLYLNCHR0001: The path '%s' does not exist";
    }

    @Override
    public final IllegalArgumentException pathDoesNotExist(Path path) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.pathDoesNotExist$str(), path));
        LauncherMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    protected String invalidDirectory1$str() {
        return "WFLYLNCHR0002: The directory '%s' is not a valid directory";
    }

    @Override
    public final IllegalArgumentException invalidDirectory(Path dir) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidDirectory1$str(), dir));
        LauncherMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidDirectory2$str() {
        return "WFLYLNCHR0003: Invalid directory, could not find '%s' in '%s'";
    }

    @Override
    public final IllegalArgumentException invalidDirectory(String filename, Path dir) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidDirectory2$str(), filename, dir));
        LauncherMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String pathNotAFile$str() {
        return "WFLYLNCHR0004: Path '%s' is not a regular file.";
    }

    @Override
    public final IllegalArgumentException pathNotAFile(Path path) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.pathNotAFile$str(), path));
        LauncherMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String nullParam$str() {
        return "WFLYLNCHR0005: The parameter %s cannot be null.";
    }

    @Override
    public final IllegalArgumentException nullParam(String name) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.nullParam$str(), name));
        LauncherMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidHostname$str() {
        return "WFLYLNCHR0006: Invalid hostname: %s";
    }

    @Override
    public final IllegalArgumentException invalidHostname(CharSequence hostname) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidHostname$str(), hostname));
        LauncherMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }
}

