/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan;

import java.util.function.Function;
import java.util.function.Supplier;
import org.keycloak.models.cache.infinispan.LazyLoader;

public class DefaultLazyLoader<S, D>
implements LazyLoader<S, D> {
    private final Function<S, D> loader;
    private Supplier<D> fallback;
    private D data;

    public DefaultLazyLoader(Function<S, D> loader, Supplier<D> fallback) {
        this.loader = loader;
        this.fallback = fallback;
    }

    @Override
    public D get(Supplier<S> sourceSupplier) {
        if (this.data == null) {
            S source = sourceSupplier.get();
            this.data = source == null ? this.fallback.get() : this.loader.apply(source);
        }
        return this.data;
    }
}

