/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.validator;

import com.webauthn4j.converter.AttestationObjectConverter;
import com.webauthn4j.converter.util.ObjectConverter;
import com.webauthn4j.data.AuthenticatorTransport;
import com.webauthn4j.data.RegistrationData;
import com.webauthn4j.data.RegistrationParameters;
import com.webauthn4j.data.attestation.AttestationObject;
import com.webauthn4j.data.attestation.authenticator.AuthenticatorData;
import com.webauthn4j.data.client.ClientDataType;
import com.webauthn4j.data.client.CollectedClientData;
import com.webauthn4j.data.extension.authenticator.AuthenticationExtensionsAuthenticatorOutputs;
import com.webauthn4j.data.extension.authenticator.RegistrationExtensionAuthenticatorOutput;
import com.webauthn4j.data.extension.client.AuthenticationExtensionsClientOutputs;
import com.webauthn4j.data.extension.client.RegistrationExtensionClientOutput;
import com.webauthn4j.server.ServerProperty;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.validator.AttestationValidator;
import com.webauthn4j.validator.BeanAssertUtil;
import com.webauthn4j.validator.ChallengeValidator;
import com.webauthn4j.validator.CustomRegistrationValidator;
import com.webauthn4j.validator.ExtensionValidator;
import com.webauthn4j.validator.OriginValidator;
import com.webauthn4j.validator.RegistrationObject;
import com.webauthn4j.validator.RpIdHashValidator;
import com.webauthn4j.validator.TokenBindingValidator;
import com.webauthn4j.validator.attestation.statement.AttestationStatementValidator;
import com.webauthn4j.validator.attestation.trustworthiness.certpath.CertPathTrustworthinessValidator;
import com.webauthn4j.validator.attestation.trustworthiness.ecdaa.ECDAATrustworthinessValidator;
import com.webauthn4j.validator.attestation.trustworthiness.self.SelfAttestationTrustworthinessValidator;
import com.webauthn4j.validator.exception.ConstraintViolationException;
import com.webauthn4j.validator.exception.InconsistentClientDataTypeException;
import com.webauthn4j.validator.exception.UserNotPresentException;
import com.webauthn4j.validator.exception.UserNotVerifiedException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class RegistrationDataValidator {
    private final ChallengeValidator challengeValidator = new ChallengeValidator();
    private final OriginValidator originValidator = new OriginValidator();
    private final TokenBindingValidator tokenBindingValidator = new TokenBindingValidator();
    private final RpIdHashValidator rpIdHashValidator = new RpIdHashValidator();
    private final ExtensionValidator extensionValidator = new ExtensionValidator();
    private final List<CustomRegistrationValidator> customRegistrationValidators = new ArrayList<CustomRegistrationValidator>();
    private final AttestationValidator attestationValidator;
    private final AttestationObjectConverter attestationObjectConverter;

    public RegistrationDataValidator(List<AttestationStatementValidator> attestationStatementValidators, CertPathTrustworthinessValidator certPathTrustworthinessValidator, ECDAATrustworthinessValidator ecdaaTrustworthinessValidator, SelfAttestationTrustworthinessValidator selfAttestationTrustworthinessValidator, List<CustomRegistrationValidator> customRegistrationValidators, ObjectConverter objectConverter) {
        AssertUtil.notNull(attestationStatementValidators, (String)"attestationStatementValidators must not be null");
        AssertUtil.notNull((Object)certPathTrustworthinessValidator, (String)"certPathTrustworthinessValidator must not be null");
        AssertUtil.notNull((Object)ecdaaTrustworthinessValidator, (String)"ecdaaTrustworthinessValidator must not be null");
        AssertUtil.notNull((Object)selfAttestationTrustworthinessValidator, (String)"selfAttestationTrustworthinessValidator must not be null");
        AssertUtil.notNull(customRegistrationValidators, (String)"customRegistrationValidators must not be null");
        AssertUtil.notNull((Object)objectConverter, (String)"objectConverter must not be null");
        this.attestationObjectConverter = new AttestationObjectConverter(objectConverter);
        this.attestationValidator = new AttestationValidator(attestationStatementValidators, certPathTrustworthinessValidator, ecdaaTrustworthinessValidator, selfAttestationTrustworthinessValidator);
    }

    public void validate(RegistrationData registrationData, RegistrationParameters registrationParameters) {
        BeanAssertUtil.validate(registrationData);
        BeanAssertUtil.validate(registrationParameters);
        byte[] clientDataBytes = registrationData.getCollectedClientDataBytes();
        byte[] attestationObjectBytes = registrationData.getAttestationObjectBytes();
        CollectedClientData collectedClientData = registrationData.getCollectedClientData();
        AttestationObject attestationObject = registrationData.getAttestationObject();
        Set<AuthenticatorTransport> transports = registrationData.getTransports();
        AuthenticationExtensionsClientOutputs<RegistrationExtensionClientOutput> clientExtensions = registrationData.getClientExtensions();
        this.validateAuthenticatorDataField(attestationObject.getAuthenticatorData());
        ServerProperty serverProperty = registrationParameters.getServerProperty();
        RegistrationObject registrationObject = new RegistrationObject(attestationObject, attestationObjectBytes, collectedClientData, clientDataBytes, clientExtensions, transports, serverProperty);
        AuthenticatorData<RegistrationExtensionAuthenticatorOutput> authenticatorData = attestationObject.getAuthenticatorData();
        if (!Objects.equals((Object)collectedClientData.getType(), (Object)ClientDataType.CREATE)) {
            throw new InconsistentClientDataTypeException("ClientData.type must be 'create' on registration, but it isn't.");
        }
        this.challengeValidator.validate(collectedClientData, serverProperty);
        this.originValidator.validate(collectedClientData, serverProperty);
        this.tokenBindingValidator.validate(collectedClientData.getTokenBinding(), serverProperty.getTokenBindingId());
        this.rpIdHashValidator.validate(authenticatorData.getRpIdHash(), serverProperty);
        this.validateUVUPFlags(authenticatorData, registrationParameters.isUserVerificationRequired(), registrationParameters.isUserPresenceRequired());
        AuthenticationExtensionsAuthenticatorOutputs<RegistrationExtensionAuthenticatorOutput> authenticationExtensionsAuthenticatorOutputs = authenticatorData.getExtensions();
        List<String> expectedExtensionIdentifiers = registrationParameters.getExpectedExtensionIds();
        this.extensionValidator.validate(clientExtensions, authenticationExtensionsAuthenticatorOutputs, expectedExtensionIdentifiers);
        this.attestationValidator.validate(registrationObject);
        for (CustomRegistrationValidator customRegistrationValidator : this.customRegistrationValidators) {
            customRegistrationValidator.validate(registrationObject);
        }
    }

    void validateAuthenticatorDataField(AuthenticatorData authenticatorData) {
        if (authenticatorData.getAttestedCredentialData() == null) {
            throw new ConstraintViolationException("attestedCredentialData must not be null on registration");
        }
    }

    void validateUVUPFlags(AuthenticatorData authenticatorData, boolean isUserVerificationRequired, boolean isUserPresenceRequired) {
        if (isUserVerificationRequired && !authenticatorData.isFlagUV()) {
            throw new UserNotVerifiedException("Validator is configured to check user verified, but UV flag in authenticatorData is not set.");
        }
        if (isUserPresenceRequired && !authenticatorData.isFlagUP()) {
            throw new UserNotPresentException("Validator is configured to check user present, but UP flag in authenticatorData is not set.");
        }
    }

    public List<CustomRegistrationValidator> getCustomRegistrationValidators() {
        return this.customRegistrationValidators;
    }
}

