/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.restclient;

import com.openshift.internal.restclient.TypeRegistry;
import com.openshift.internal.restclient.model.KubernetesResource;
import com.openshift.internal.restclient.model.List;
import com.openshift.internal.restclient.model.properties.ResourcePropertiesRegistry;
import com.openshift.restclient.IApiTypeMapper;
import com.openshift.restclient.IClient;
import com.openshift.restclient.IResourceFactory;
import com.openshift.restclient.ResourceFactoryException;
import com.openshift.restclient.ResourceKind;
import com.openshift.restclient.UnsupportedVersionException;
import com.openshift.restclient.model.IResource;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jboss.dmr.ModelNode;

public class ResourceFactory
implements IResourceFactory {
    private static final String KIND = "kind";
    private static final String APIVERSION = "apiVersion";
    private static final Map<String, Class<? extends IResource>> IMPL_MAP = new HashMap<String, Class<? extends IResource>>();
    private IClient client;

    public ResourceFactory(IClient client) {
        this.client = client;
    }

    public static Map<String, Class<? extends IResource>> getImplMap() {
        return Collections.unmodifiableMap(IMPL_MAP);
    }

    @Override
    public java.util.List<IResource> createList(String json, String kind) {
        ModelNode data = ModelNode.fromJSONString((String)json);
        String dataKind = data.get(KIND).asString();
        if (!(kind.toString() + "List").equals(dataKind)) {
            throw new RuntimeException(String.format("Unexpected container type '%s' for desired kind: %s", dataKind, kind));
        }
        try {
            String version = data.get(APIVERSION).asString();
            return this.buildList(version, data.get("items").asList(), kind);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private java.util.List<IResource> buildList(String version, java.util.List<ModelNode> items, String kind) throws NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        ArrayList<IResource> resources = new ArrayList<IResource>(items.size());
        for (ModelNode item : items) {
            resources.add(this.create(item, version, kind));
        }
        return resources;
    }

    public IResource create(InputStream input) {
        try {
            String resource = IOUtils.toString((InputStream)input, (String)"UTF-8");
            return this.create(resource);
        }
        catch (IOException e) {
            throw new ResourceFactoryException((Throwable)e, "There was an exception creating the resource from the InputStream", new Object[0]);
        }
    }

    @Override
    public <T extends IResource> T create(String response) {
        try {
            ModelNode node = ModelNode.fromJSONString((String)response);
            String version = node.get(APIVERSION).asString();
            String kind = node.get(KIND).asString();
            return (T)this.create(node, version, kind);
        }
        catch (UnsupportedVersionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceFactoryException((Throwable)e, "There was an exception creating the resource from: %s", response);
        }
    }

    @Override
    public <T extends IResource> T create(String version, String kind) {
        return (T)this.create(new ModelNode(), version, kind);
    }

    @Override
    public <T extends IResource> T create(String version, String kind, String name) {
        IResource resource = this.create(new ModelNode(), version, kind);
        ((KubernetesResource)resource).setName(name);
        return (T)resource;
    }

    private IResource create(ModelNode node, String version, String kind) {
        try {
            node.get(APIVERSION).set(version);
            node.get(KIND).set(kind.toString());
            Map<String, String[]> properyKeyMap = ResourcePropertiesRegistry.getInstance().get(version, kind);
            if (kind.endsWith("List")) {
                return new List(node, this.client, properyKeyMap);
            }
            Class<? extends IResource> klass = this.getResourceClass(version, kind);
            if (klass != null) {
                Constructor<? extends IResource> constructor = klass.getConstructor(ModelNode.class, IClient.class, Map.class);
                return constructor.newInstance(node, this.client, properyKeyMap);
            }
            return new KubernetesResource(node, this.client, properyKeyMap);
        }
        catch (UnsupportedVersionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceFactoryException((Throwable)e, "Unable to create %s resource kind %s from %s", version, kind, node);
        }
    }

    @Override
    public Object createInstanceFrom(String response) {
        return this.create(response);
    }

    private Class<? extends IResource> getResourceClass(String version, String kind) {
        IApiTypeMapper mapper = this.client.adapt(IApiTypeMapper.class);
        if (mapper != null) {
            try {
                IApiTypeMapper.IVersionedType type = mapper.getType(version, kind);
                return TypeRegistry.getInstance().getRegisteredType(type.getApiGroupNameAndVersion() + '.' + type.getKind());
            }
            catch (Exception e) {
                return TypeRegistry.getInstance().getRegisteredType(version + '.' + kind);
            }
        }
        return null;
    }

    @Override
    public <T extends IResource> T stub(String kind, String name, String namespace) {
        String[] elements = ResourceKind.parse(kind);
        IApiTypeMapper.IVersionedType type = this.client.adapt(IApiTypeMapper.class).getType(elements[0], elements[1]);
        if (type != null) {
            KubernetesResource resource = (KubernetesResource)this.create(type.getApiGroupNameAndVersion(), elements[1]);
            resource.setName(name);
            resource.setNamespace(namespace);
            if (StringUtils.isNotEmpty((String)namespace)) {
                resource.setNamespace(namespace);
            }
            return (T)resource;
        }
        throw new ResourceFactoryException(null, "Unable to create resource from kind %s", kind);
    }

    @Override
    public <T extends IResource> T stub(String kind, String name) {
        return this.stub(kind, name, null);
    }

    @Override
    public Object stubKind(String kind, Optional<String> name, Optional<String> namespace) {
        return this.stub(kind, name.get(), namespace.get());
    }

    @Override
    public void setClient(IClient client) {
        this.client = client;
    }
}

