/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.representations.idm.authorization;

import java.util.HashSet;
import java.util.Set;
import org.keycloak.representations.idm.authorization.AbstractPolicyRepresentation;

public class RolePolicyRepresentation
extends AbstractPolicyRepresentation {
    private Set<RoleDefinition> roles;

    @Override
    public String getType() {
        return "role";
    }

    public Set<RoleDefinition> getRoles() {
        return this.roles;
    }

    public void setRoles(Set<RoleDefinition> roles) {
        this.roles = roles;
    }

    public void addRole(String name, boolean required) {
        if (this.roles == null) {
            this.roles = new HashSet<RoleDefinition>();
        }
        this.roles.add(new RoleDefinition(name, required));
    }

    public void addRole(String name) {
        this.addRole(name, false);
    }

    public void addClientRole(String clientId, String name) {
        this.addRole(clientId + "/" + name, false);
    }

    public void addClientRole(String clientId, String name, boolean required) {
        this.addRole(clientId + "/" + name, required);
    }

    public static class RoleDefinition {
        private String id;
        private boolean required;

        public RoleDefinition() {
            this(null, false);
        }

        public RoleDefinition(String id, boolean required) {
            this.id = id;
            this.required = required;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public boolean isRequired() {
            return this.required;
        }

        public void setRequired(boolean required) {
            this.required = required;
        }
    }
}

