/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.msc.service;

import java.util.Set;
import org.jboss.msc.service.Dependency;
import org.jboss.msc.service.Dependent;
import org.jboss.msc.service.DuplicateServiceException;
import org.jboss.msc.service.IdentityHashSet;
import org.jboss.msc.service.Lockable;
import org.jboss.msc.service.ReadableValueImpl;
import org.jboss.msc.service.ServiceControllerImpl;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.WritableValueImpl;

final class ServiceRegistrationImpl
extends Lockable
implements Dependency {
    private final ServiceName name;
    private final Set<Dependent> dependents = new IdentityHashSet<Dependent>();
    private final ReadableValueImpl value = new ReadableValueImpl(this);
    private volatile ServiceControllerImpl<?> instance;
    private volatile WritableValueImpl injector;
    private int demandedByCount;
    private int dependentsStartedCount;
    private int pendingInstallation;
    private boolean removed;

    ServiceRegistrationImpl(ServiceName name) {
        this.name = name;
    }

    @Override
    public Lockable getLock() {
        return this;
    }

    Set<Dependent> getDependents() {
        return this.dependents;
    }

    boolean addPendingInstallation() {
        assert (this.isWriteLocked());
        if (this.removed) {
            return false;
        }
        ++this.pendingInstallation;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDependent(Dependent dependent) {
        assert (this.isWriteLocked());
        --this.pendingInstallation;
        if (this.dependents.contains(dependent)) {
            throw new IllegalStateException("Dependent already exists on this registration");
        }
        this.dependents.add(dependent);
        if (this.instance == null) {
            dependent.dependencyUnavailable();
            return;
        }
        ServiceControllerImpl<?> serviceControllerImpl = this.instance;
        synchronized (serviceControllerImpl) {
            if (!this.instance.isInstallationCommitted()) {
                dependent.dependencyUnavailable();
                return;
            }
            this.instance.newDependent(dependent);
        }
    }

    @Override
    public boolean removeDependent(Dependent dependent) {
        assert (this.isWriteLocked());
        this.dependents.remove(dependent);
        this.removed = this.instance == null && this.dependents.size() == 0 && this.pendingInstallation == 0;
        return this.removed;
    }

    void set(ServiceControllerImpl<?> newInstance, WritableValueImpl newInjector) throws DuplicateServiceException {
        assert (newInstance != null);
        assert (this.isWriteLocked());
        --this.pendingInstallation;
        if (this.instance != null) {
            throw new DuplicateServiceException(String.format("Service %s is already registered", this.name.getCanonicalName()));
        }
        this.instance = newInstance;
        this.injector = newInjector;
        if (this.demandedByCount > 0) {
            this.instance.addDemands(this.demandedByCount);
        }
        if (this.dependentsStartedCount > 0) {
            this.instance.dependentsStarted(this.dependentsStartedCount);
        }
    }

    boolean clear(ServiceControllerImpl<?> oldInstance) {
        assert (oldInstance != null);
        assert (this.isWriteLocked());
        if (this.instance == oldInstance) {
            this.instance = null;
            this.injector = null;
            this.removed = this.dependents.size() == 0 && this.pendingInstallation == 0;
        }
        return this.removed;
    }

    ReadableValueImpl getReadableValue() {
        return this.value;
    }

    @Override
    public Object getValue() throws IllegalStateException {
        WritableValueImpl injector = this.injector;
        if (injector != null) {
            return injector.getValue();
        }
        ServiceControllerImpl<?> instance = this.instance;
        if (instance != null) {
            return instance.getValue();
        }
        throw new IllegalStateException("Service is not installed");
    }

    @Override
    public ServiceName getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServiceControllerImpl<?> getDependencyController() {
        ServiceRegistrationImpl serviceRegistrationImpl = this;
        synchronized (serviceRegistrationImpl) {
            return this.instance;
        }
    }

    @Override
    public void dependentStarted() {
        assert (this.isWriteLocked());
        ++this.dependentsStartedCount;
        if (this.instance != null) {
            this.instance.dependentStarted();
        }
    }

    @Override
    public void dependentStopped() {
        assert (this.isWriteLocked());
        --this.dependentsStartedCount;
        if (this.instance != null) {
            this.instance.dependentStopped();
        }
    }

    @Override
    public void addDemand() {
        assert (this.isWriteLocked());
        ++this.demandedByCount;
        if (this.instance != null) {
            this.instance.addDemand();
        }
    }

    @Override
    public void removeDemand() {
        assert (this.isWriteLocked());
        --this.demandedByCount;
        if (this.instance != null) {
            this.instance.removeDemand();
        }
    }
}

