/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;

public class BackupForConfiguration {
    public static final AttributeDefinition<String> REMOTE_CACHE = AttributeDefinition.builder((String)"remoteCache", null, String.class).immutable().build();
    public static final AttributeDefinition<String> REMOTE_SITE = AttributeDefinition.builder((String)"remoteSite", null, String.class).immutable().build();
    private final Attribute<String> remoteCache;
    private final Attribute<String> remoteSite;
    private final AttributeSet attributes;

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(BackupForConfiguration.class, new AttributeDefinition[]{REMOTE_CACHE, REMOTE_SITE});
    }

    public BackupForConfiguration(AttributeSet attributes) {
        this.attributes = attributes.checkProtection();
        this.remoteCache = attributes.attribute(REMOTE_CACHE);
        this.remoteSite = attributes.attribute(REMOTE_SITE);
    }

    public String remoteCache() {
        return (String)this.remoteCache.get();
    }

    public String remoteSite() {
        return (String)this.remoteSite.get();
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BackupForConfiguration other = (BackupForConfiguration)obj;
        return !(this.attributes == null ? other.attributes != null : !this.attributes.equals((Object)other.attributes));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attributes == null ? 0 : this.attributes.hashCode());
        return result;
    }

    public boolean isBackupFor(String remoteSite, String remoteCache) {
        boolean remoteSiteMatches = this.remoteSite() != null && this.remoteSite().equals(remoteSite);
        boolean remoteCacheMatches = this.remoteCache() != null && this.remoteCache().equals(remoteCache);
        return remoteSiteMatches && remoteCacheMatches;
    }

    public String toString() {
        return "BackupForConfiguration [attributes=" + this.attributes + "]";
    }
}

