/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jbossts.txbridge.inbound;

import com.arjuna.ats.arjuna.recovery.RecoveryManager;
import com.arjuna.ats.arjuna.recovery.RecoveryModule;
import com.arjuna.ats.internal.jta.recovery.arjunacore.XARecoveryModule;
import com.arjuna.ats.internal.jta.transaction.arjunacore.jca.SubordinationManager;
import com.arjuna.ats.jta.recovery.XAResourceOrphanFilter;
import com.arjuna.ats.jta.utils.XAHelper;
import com.arjuna.wst.Durable2PCParticipant;
import java.io.ObjectInputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.resource.spi.XATerminator;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.jboss.jbossts.txbridge.inbound.BridgeDurableParticipant;
import org.jboss.jbossts.txbridge.inbound.InboundBridgeManager;
import org.jboss.jbossts.txbridge.utils.txbridgeLogger;
import org.jboss.jbossts.xts.recovery.participant.at.XTSATRecoveryManager;
import org.jboss.jbossts.xts.recovery.participant.at.XTSATRecoveryModule;

public class InboundBridgeRecoveryManager
implements XTSATRecoveryModule,
RecoveryModule,
XAResourceOrphanFilter {
    private final XTSATRecoveryManager xtsATRecoveryManager = XTSATRecoveryManager.getRecoveryManager();
    private final RecoveryManager acRecoveryManager = RecoveryManager.manager();
    private final XATerminator xaTerminator = SubordinationManager.getXATerminator();
    private final List<BridgeDurableParticipant> participantsAwaitingRecovery = Collections.synchronizedList(new LinkedList());
    private volatile boolean orphanedXAResourcesAreIdentifiable = false;

    public void start() {
        txbridgeLogger.i18NLogger.info_ibrm_start();
        this.xtsATRecoveryManager.registerRecoveryModule((XTSATRecoveryModule)this);
        this.acRecoveryManager.addModule((RecoveryModule)this);
        XARecoveryModule xaRecoveryModule = this.getXARecoveryModule();
        xaRecoveryModule.addXAResourceOrphanFilter((XAResourceOrphanFilter)this);
    }

    public void stop() {
        txbridgeLogger.i18NLogger.info_ibrm_stop();
        this.xtsATRecoveryManager.unregisterRecoveryModule((XTSATRecoveryModule)this);
        this.acRecoveryManager.removeModule((RecoveryModule)this, false);
        XARecoveryModule xaRecoveryModule = this.getXARecoveryModule();
        xaRecoveryModule.removeXAResourceOrphanFilter((XAResourceOrphanFilter)this);
    }

    private XARecoveryModule getXARecoveryModule() {
        XARecoveryModule xaRecoveryModule = null;
        for (RecoveryModule recoveryModule : this.acRecoveryManager.getModules()) {
            if (!(recoveryModule instanceof XARecoveryModule)) continue;
            xaRecoveryModule = (XARecoveryModule)recoveryModule;
            break;
        }
        if (xaRecoveryModule == null) {
            throw new IllegalStateException("no XARecoveryModule found");
        }
        return xaRecoveryModule;
    }

    public Durable2PCParticipant deserialize(String id, ObjectInputStream objectInputStream) throws Exception {
        txbridgeLogger.logger.trace((Object)("InboundBridgeRecoveryManager.deserialize(id=" + id + ")"));
        if (id.startsWith("BridgeDurableParticipant_")) {
            Object participant = objectInputStream.readObject();
            BridgeDurableParticipant bridgeDurableParticipant = (BridgeDurableParticipant)participant;
            this.participantsAwaitingRecovery.add(bridgeDurableParticipant);
            return bridgeDurableParticipant;
        }
        return null;
    }

    public void endScan() {
    }

    public Durable2PCParticipant recreate(String s, byte[] bytes) throws Exception {
        throw new Exception("recreation not supported - should use deserialization instead.");
    }

    public void periodicWorkFirstPass() {
        txbridgeLogger.logger.trace((Object)"InboundBridgeRecoveryManager.periodicWorkFirstPass()");
    }

    public void periodicWorkSecondPass() {
        txbridgeLogger.logger.trace((Object)"InboundBridgeRecoveryManager.periodicWorkSecondPass()");
        this.cleanupRecoveredParticipants();
        this.orphanedXAResourcesAreIdentifiable = true;
        List<Xid> indoubtSubordinates = this.getIndoubtSubordinates();
        for (Xid xid : indoubtSubordinates) {
            if (this.checkXid(xid) != XAResourceOrphanFilter.Vote.ROLLBACK) continue;
            txbridgeLogger.logger.trace((Object)("rolling back orphaned subordinate tx " + xid));
            try {
                this.xaTerminator.rollback(xid);
            }
            catch (XAException e) {
                txbridgeLogger.i18NLogger.error_ibrm_rollbackerr(XAHelper.xidToString((Xid)xid), e);
            }
        }
    }

    private List<Xid> getIndoubtSubordinates() {
        txbridgeLogger.logger.trace((Object)"InboundBridgeRecoveryManager.getIndoubtSubordinates()");
        Xid[] allSubordinateXids = null;
        try {
            allSubordinateXids = this.xaTerminator.recover(0x1000000);
        }
        catch (XAException e) {
            txbridgeLogger.i18NLogger.error_ibrm_scanerr(e);
        }
        finally {
            try {
                this.xaTerminator.recover(0x800000);
            }
            catch (XAException e) {}
        }
        LinkedList<Xid> mySubordinateXids = new LinkedList<Xid>();
        if (allSubordinateXids == null) {
            return mySubordinateXids;
        }
        for (Xid xid : allSubordinateXids) {
            if (xid.getFormatId() != 131080) continue;
            mySubordinateXids.add(xid);
            txbridgeLogger.logger.trace((Object)("in-doubt subordinate, xid: " + xid));
        }
        return mySubordinateXids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupRecoveredParticipants() {
        txbridgeLogger.logger.trace((Object)"InboundBridgeRecoveryManager.cleanupRecoveredParticipants()");
        List<BridgeDurableParticipant> list = this.participantsAwaitingRecovery;
        synchronized (list) {
            Iterator<BridgeDurableParticipant> iter = this.participantsAwaitingRecovery.iterator();
            while (iter.hasNext()) {
                BridgeDurableParticipant participant = iter.next();
                if (participant.isAwaitingRecovery()) continue;
                iter.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XAResourceOrphanFilter.Vote checkXid(Xid xid) {
        txbridgeLogger.logger.trace((Object)("InboundBridgeRecoveryManager.checkXid(" + xid + ")"));
        if (xid.getFormatId() != 131080) {
            txbridgeLogger.logger.trace((Object)("InboundBridgeRecoveryManager.checkXid(" + xid + ") - not ours. Abstaining."));
            return XAResourceOrphanFilter.Vote.ABSTAIN;
        }
        if (!this.orphanedXAResourcesAreIdentifiable) {
            txbridgeLogger.logger.trace((Object)("InboundBridgeRecoveryManager.checkXid(" + xid + ") - recovery incomplete. Leave alone."));
            return XAResourceOrphanFilter.Vote.LEAVE_ALONE;
        }
        if (InboundBridgeManager.isLive(xid)) {
            txbridgeLogger.logger.trace((Object)("InboundBridgeRecoveryManager.checkXid(" + xid + ") - still live. Leave alone."));
            return XAResourceOrphanFilter.Vote.LEAVE_ALONE;
        }
        List<BridgeDurableParticipant> list = this.participantsAwaitingRecovery;
        synchronized (list) {
            for (BridgeDurableParticipant participant : this.participantsAwaitingRecovery) {
                if (!participant.getXid().equals(xid)) continue;
                txbridgeLogger.logger.trace((Object)("InboundBridgeRecoveryManager.checkXid(" + xid + ") - awaiting recovery. Leave alone."));
                return XAResourceOrphanFilter.Vote.LEAVE_ALONE;
            }
        }
        txbridgeLogger.logger.trace((Object)("InboundBridgeRecoveryManager.checkXid(" + xid + ") - passed to rollback."));
        return XAResourceOrphanFilter.Vote.ROLLBACK;
    }
}

