/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.configuration;

import java.lang.reflect.Constructor;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.ConfigurationBuilderInfo;
import org.infinispan.commons.configuration.ConfigurationUtils;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.cache.AbstractStoreConfigurationBuilder;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.persistence.jdbc.DatabaseType;
import org.infinispan.persistence.jdbc.configuration.AbstractJdbcStoreConfiguration;
import org.infinispan.persistence.jdbc.configuration.ConnectionFactoryConfiguration;
import org.infinispan.persistence.jdbc.configuration.ConnectionFactoryConfigurationBuilder;
import org.infinispan.persistence.jdbc.configuration.JdbcStoreConfigurationChildBuilder;
import org.infinispan.persistence.jdbc.configuration.ManagedConnectionFactoryConfigurationBuilder;
import org.infinispan.persistence.jdbc.configuration.PooledConnectionFactoryConfigurationBuilder;
import org.infinispan.persistence.jdbc.configuration.SimpleConnectionFactoryConfigurationBuilder;
import org.infinispan.persistence.jdbc.logging.Log;

public abstract class AbstractJdbcStoreConfigurationBuilder<T extends AbstractJdbcStoreConfiguration, S extends AbstractJdbcStoreConfigurationBuilder<T, S>>
extends AbstractStoreConfigurationBuilder<T, S>
implements JdbcStoreConfigurationChildBuilder<S>,
ConfigurationBuilderInfo {
    protected ConnectionFactoryConfigurationBuilder<ConnectionFactoryConfiguration> connectionFactory;

    public AbstractJdbcStoreConfigurationBuilder(PersistenceConfigurationBuilder builder, AttributeSet attributes) {
        super(builder, attributes);
    }

    @Override
    public PooledConnectionFactoryConfigurationBuilder<S> connectionPool() {
        return (PooledConnectionFactoryConfigurationBuilder)((Object)this.connectionFactory((ConnectionFactoryConfigurationBuilder)((Object)PooledConnectionFactoryConfigurationBuilder.class)));
    }

    @Override
    public ManagedConnectionFactoryConfigurationBuilder<S> dataSource() {
        return (ManagedConnectionFactoryConfigurationBuilder)((Object)this.connectionFactory((ConnectionFactoryConfigurationBuilder)((Object)ManagedConnectionFactoryConfigurationBuilder.class)));
    }

    @Override
    public SimpleConnectionFactoryConfigurationBuilder<S> simpleConnection() {
        return (SimpleConnectionFactoryConfigurationBuilder)((Object)this.connectionFactory((ConnectionFactoryConfigurationBuilder)((Object)SimpleConnectionFactoryConfigurationBuilder.class)));
    }

    @Override
    public <C extends ConnectionFactoryConfigurationBuilder<?>> C connectionFactory(Class<C> klass) {
        if (this.connectionFactory != null) {
            throw new IllegalStateException("A ConnectionFactory has already been configured for this store");
        }
        try {
            ConnectionFactoryConfigurationBuilder builder;
            Constructor<C> constructor = klass.getDeclaredConstructor(AbstractJdbcStoreConfigurationBuilder.class);
            this.connectionFactory = builder = (ConnectionFactoryConfigurationBuilder)constructor.newInstance(this);
            return (C)builder;
        }
        catch (Exception e) {
            throw new CacheConfigurationException("Could not instantiate loader configuration builder '" + klass.getName() + "'", (Throwable)e);
        }
    }

    @Override
    public <C extends ConnectionFactoryConfigurationBuilder<?>> C connectionFactory(C builder) {
        if (this.connectionFactory != null) {
            throw new IllegalStateException("A ConnectionFactory has already been configured for this store");
        }
        this.connectionFactory = builder;
        return builder;
    }

    public S manageConnectionFactory(boolean manageConnectionFactory) {
        this.attributes.attribute(AbstractJdbcStoreConfiguration.MANAGE_CONNECTION_FACTORY).set((Object)manageConnectionFactory);
        return (S)((AbstractJdbcStoreConfigurationBuilder)this.self());
    }

    public S dialect(DatabaseType databaseType) {
        this.attributes.attribute(AbstractJdbcStoreConfiguration.DIALECT).set((Object)databaseType);
        return (S)((AbstractJdbcStoreConfigurationBuilder)this.self());
    }

    public S dbMajorVersion(Integer majorVersion) {
        this.attributes.attribute(AbstractJdbcStoreConfiguration.DB_MAJOR_VERSION).set((Object)majorVersion);
        return (S)((AbstractJdbcStoreConfigurationBuilder)this.self());
    }

    public S dbMinorVersion(Integer minorVersion) {
        this.attributes.attribute(AbstractJdbcStoreConfiguration.DB_MINOR_VERSION).set((Object)minorVersion);
        return (S)((AbstractJdbcStoreConfigurationBuilder)this.self());
    }

    public void validate() {
        super.validate();
        boolean manageConnectionFactory = (Boolean)this.attributes.attribute(AbstractJdbcStoreConfiguration.MANAGE_CONNECTION_FACTORY).get();
        if (manageConnectionFactory && this.connectionFactory == null) {
            throw Log.PERSISTENCE.missingConnectionFactory();
        }
        if (!manageConnectionFactory && this.connectionFactory != null) {
            throw Log.PERSISTENCE.unmanagedConnectionFactory();
        }
        if (this.connectionFactory != null) {
            this.connectionFactory.validate();
        }
    }

    public void validate(GlobalConfiguration globalConfig) {
    }

    public Builder<?> read(T template) {
        super.read(template);
        Class cfb = ConfigurationUtils.builderFor((Object)((AbstractJdbcStoreConfiguration)((Object)template)).connectionFactory());
        this.connectionFactory((ConnectionFactoryConfigurationBuilder)((Object)cfb));
        this.connectionFactory.read(((AbstractJdbcStoreConfiguration)((Object)template)).connectionFactory());
        return this;
    }
}

