/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientpolicy;

import org.keycloak.models.ClientModel;
import org.keycloak.models.UserModel;
import org.keycloak.representations.JsonWebToken;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.services.clientpolicy.ClientPolicyEvent;
import org.keycloak.services.clientpolicy.ClientUpdateContext;
import org.keycloak.services.resources.admin.AdminAuth;

public class AdminClientUpdateContext
implements ClientUpdateContext {
    private final ClientRepresentation clientRepresentation;
    private final AdminAuth adminAuth;
    private final ClientModel client;

    public AdminClientUpdateContext(ClientRepresentation clientRepresentation, AdminAuth adminAuth, ClientModel client) {
        this.clientRepresentation = clientRepresentation;
        this.adminAuth = adminAuth;
        this.client = client;
    }

    public ClientPolicyEvent getEvent() {
        return ClientPolicyEvent.UPDATE;
    }

    @Override
    public ClientRepresentation getProposedClientRepresentation() {
        return this.clientRepresentation;
    }

    @Override
    public ClientModel getClientToBeUpdated() {
        return this.client;
    }

    @Override
    public ClientModel getAuthenticatedClient() {
        return this.adminAuth.getClient();
    }

    @Override
    public UserModel getAuthenticatedUser() {
        return this.adminAuth.getUser();
    }

    @Override
    public JsonWebToken getToken() {
        return this.adminAuth.getToken();
    }
}

