/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.ConfigurationBuilderInfo;
import org.infinispan.commons.configuration.elements.ElementDefinition;
import org.infinispan.configuration.cache.AbstractConfigurationChildBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.MemoryConfiguration;
import org.infinispan.configuration.cache.MemoryStorageConfigurationBuilder;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.configuration.cache.TransactionConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.eviction.EvictionType;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.util.logging.Log;

public class MemoryConfigurationBuilder
extends AbstractConfigurationChildBuilder
implements Builder<MemoryConfiguration>,
ConfigurationBuilderInfo {
    private MemoryStorageConfigurationBuilder memoryStorageConfigurationBuilder;
    private final List<ConfigurationBuilderInfo> elements;

    MemoryConfigurationBuilder(ConfigurationBuilder builder) {
        super(builder);
        this.memoryStorageConfigurationBuilder = new MemoryStorageConfigurationBuilder(builder);
        this.elements = Collections.singletonList(this.memoryStorageConfigurationBuilder);
    }

    public Collection<ConfigurationBuilderInfo> getChildrenInfo() {
        return this.elements;
    }

    public MemoryConfigurationBuilder storageType(StorageType storageType) {
        this.memoryStorageConfigurationBuilder.storageType(storageType);
        return this;
    }

    public StorageType storageType() {
        return this.memoryStorageConfigurationBuilder.storageType();
    }

    public MemoryConfigurationBuilder size(long size) {
        this.memoryStorageConfigurationBuilder.size(size);
        return this;
    }

    public ElementDefinition getElementDefinition() {
        return MemoryConfiguration.ELEMENT_DEFINITION;
    }

    public long size() {
        return this.memoryStorageConfigurationBuilder.size();
    }

    public MemoryConfigurationBuilder evictionType(EvictionType type) {
        this.memoryStorageConfigurationBuilder.evictionType(type);
        return this;
    }

    public EvictionType evictionType() {
        return this.memoryStorageConfigurationBuilder.evictionType();
    }

    public MemoryConfigurationBuilder evictionStrategy(EvictionStrategy strategy) {
        this.memoryStorageConfigurationBuilder.evictionStrategy(strategy);
        return this;
    }

    public EvictionStrategy evictionStrategy() {
        return this.memoryStorageConfigurationBuilder.evictionStrategy();
    }

    @Deprecated
    public MemoryConfigurationBuilder addressCount(int addressCount) {
        this.memoryStorageConfigurationBuilder.addressCount(addressCount);
        return this;
    }

    @Deprecated
    public int addressCount() {
        return this.memoryStorageConfigurationBuilder.addressCount();
    }

    public void validate() {
        EvictionStrategy strategy;
        StorageType type = this.memoryStorageConfigurationBuilder.storageType();
        if (type != StorageType.OBJECT && this.getBuilder().clustering().hash().groups().isEnabled()) {
            throw Log.CONFIG.groupingOnlyCompatibleWithObjectStorage(type);
        }
        long size = this.memoryStorageConfigurationBuilder.size();
        EvictionType evictionType = this.memoryStorageConfigurationBuilder.evictionType();
        if (evictionType == EvictionType.MEMORY) {
            switch (type) {
                case OBJECT: {
                    throw Log.CONFIG.offHeapMemoryEvictionNotSupportedWithObject();
                }
            }
        }
        if (!(strategy = this.memoryStorageConfigurationBuilder.evictionStrategy()).isEnabled()) {
            if (size > 0L) {
                EvictionStrategy newStrategy = EvictionStrategy.REMOVE;
                this.evictionStrategy(newStrategy);
                Log.CONFIG.debugf("Max entries configured (%d) without eviction strategy. Eviction strategy overridden to %s", size, (Object)newStrategy);
            } else if (this.getBuilder().persistence().passivation() && strategy != EvictionStrategy.MANUAL && !this.getBuilder().template()) {
                Log.CONFIG.passivationWithoutEviction();
            }
        } else {
            TransactionConfigurationBuilder transactionConfiguration;
            TransactionMode transactionMode;
            if (size <= 0L) {
                throw Log.CONFIG.invalidEvictionSize();
            }
            if (strategy.isExceptionBased() && ((transactionMode = (transactionConfiguration = this.getBuilder().transaction()).transactionMode()) == null || !transactionMode.isTransactional() || transactionConfiguration.useSynchronization() || transactionConfiguration.use1PcForAutoCommitTransactions())) {
                throw Log.CONFIG.exceptionBasedEvictionOnlySupportedInTransactionalCaches();
            }
        }
    }

    @Override
    public void validate(GlobalConfiguration globalConfig) {
    }

    public MemoryConfiguration create() {
        return new MemoryConfiguration(this.memoryStorageConfigurationBuilder.create());
    }

    public MemoryConfigurationBuilder read(MemoryConfiguration template) {
        this.memoryStorageConfigurationBuilder.read(template.heapConfiguration());
        return this;
    }

    public ConfigurationBuilderInfo getBuilderInfo(String name, String qualifier) {
        switch (name) {
            case "off-heap": {
                this.memoryStorageConfigurationBuilder.storageType(StorageType.OFF_HEAP);
                break;
            }
            case "binary": {
                this.memoryStorageConfigurationBuilder.storageType(StorageType.BINARY);
                break;
            }
            case "object": {
                this.memoryStorageConfigurationBuilder.storageType(StorageType.OBJECT);
            }
        }
        return this.memoryStorageConfigurationBuilder;
    }

    public String toString() {
        return "MemoryConfigurationBuilder{memoryStorageConfigurationBuilder=" + this.memoryStorageConfigurationBuilder + '}';
    }
}

