/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.transaction.impl;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.infinispan.commands.SegmentSpecificCommand;
import org.infinispan.commands.tx.VersionedPrepareCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.VersionedRepeatableReadEntry;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.container.versioning.EntryVersionsMap;
import org.infinispan.container.versioning.IncrementableEntryVersion;
import org.infinispan.container.versioning.VersionGenerator;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.persistence.util.EntryLoader;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.transaction.WriteSkewException;
import org.infinispan.transaction.xa.CacheTransaction;
import org.infinispan.util.concurrent.AggregateCompletionStage;
import org.infinispan.util.concurrent.CompletionStages;

public class WriteSkewHelper {
    public static final KeySpecificLogic ALWAYS_TRUE_LOGIC = k -> true;

    public static void readVersionsFromResponse(Response r, CacheTransaction ct) {
        SuccessfulResponse sr;
        EntryVersionsMap uv;
        if (r != null && r.isSuccessful() && (uv = (EntryVersionsMap)(sr = (SuccessfulResponse)r).getResponseValue()) != null) {
            ct.setUpdatedEntryVersions(uv.merge(ct.getUpdatedEntryVersions()));
        }
    }

    public static CompletionStage<EntryVersionsMap> performWriteSkewCheckAndReturnNewVersions(VersionedPrepareCommand prepareCommand, EntryLoader entryLoader, VersionGenerator versionGenerator, TxInvocationContext context, KeySpecificLogic ksl, KeyPartitioner keyPartitioner) {
        EntryVersionsMap uv = new EntryVersionsMap();
        if (prepareCommand.getVersionsSeen() == null) {
            return CompletableFuture.completedFuture(uv);
        }
        AggregateCompletionStage<EntryVersionsMap> aggregateCompletionStage = CompletionStages.aggregateCompletionStage(uv);
        for (WriteCommand c : prepareCommand.getModifications()) {
            for (Object k : c.getAffectedKeys()) {
                CacheEntry cacheEntry;
                int segment = SegmentSpecificCommand.extractSegment(c, k, keyPartitioner);
                if (!ksl.performCheckOnSegment(segment) || !((cacheEntry = context.lookupEntry(k)) instanceof VersionedRepeatableReadEntry)) continue;
                VersionedRepeatableReadEntry entry = (VersionedRepeatableReadEntry)cacheEntry;
                CompletionStage<Boolean> skewStage = entry.performWriteSkewCheck(entryLoader, segment, context, (EntryVersion)prepareCommand.getVersionsSeen().get(k), versionGenerator);
                aggregateCompletionStage.dependsOn(skewStage.thenAccept(passSkew -> {
                    if (passSkew.booleanValue()) {
                        IncrementableEntryVersion oldVersion = (IncrementableEntryVersion)entry.getMetadata().version();
                        IncrementableEntryVersion newVersion = entry.isCreated() || oldVersion == null ? versionGenerator.generateNew() : versionGenerator.increment(oldVersion);
                        EntryVersionsMap entryVersionsMap = uv;
                        synchronized (entryVersionsMap) {
                            uv.put(entry.getKey(), newVersion);
                        }
                    } else {
                        throw new WriteSkewException("Write skew detected on key " + k + " for transaction " + context.getCacheTransaction(), k);
                    }
                }));
            }
        }
        return aggregateCompletionStage.freeze();
    }

    public static CompletionStage<EntryVersionsMap> performTotalOrderWriteSkewCheckAndReturnNewVersions(VersionedPrepareCommand prepareCommand, EntryLoader entryLoader, VersionGenerator versionGenerator, TxInvocationContext context, KeySpecificLogic ksl, KeyPartitioner keyPartitioner) {
        EntryVersionsMap uv = new EntryVersionsMap();
        AggregateCompletionStage<EntryVersionsMap> aggregateCompletionStage = CompletionStages.aggregateCompletionStage(uv);
        for (WriteCommand c : prepareCommand.getModifications()) {
            for (Object k : c.getAffectedKeys()) {
                int segment = SegmentSpecificCommand.extractSegment(c, k, keyPartitioner);
                if (!ksl.performCheckOnSegment(segment)) continue;
                VersionedRepeatableReadEntry entry = (VersionedRepeatableReadEntry)context.lookupEntry(k);
                CompletionStage<Boolean> skewStage = entry.performWriteSkewCheck(entryLoader, segment, context, (EntryVersion)prepareCommand.getVersionsSeen().get(k), versionGenerator);
                aggregateCompletionStage.dependsOn(skewStage.thenAccept(passSkew -> {
                    if (passSkew.booleanValue()) {
                        EntryVersionsMap entryVersionsMap = uv;
                        synchronized (entryVersionsMap) {
                            uv.put(k, null);
                        }
                    } else {
                        throw new WriteSkewException("Write skew detected on key " + k + " for transaction " + context.getCacheTransaction(), k);
                    }
                }));
            }
        }
        return aggregateCompletionStage.freeze();
    }

    public static interface KeySpecificLogic {
        public boolean performCheckOnSegment(int var1);
    }
}

