/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.authorization.stream;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Map;
import java.util.function.Predicate;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.marshall.SerializeWith;
import org.keycloak.models.cache.infinispan.authorization.entities.InResource;
import org.keycloak.models.cache.infinispan.entities.Revisioned;

@SerializeWith(value=ExternalizerImpl.class)
public class InResourcePredicate
implements Predicate<Map.Entry<String, Revisioned>>,
Serializable {
    private String resourceId;

    public static InResourcePredicate create() {
        return new InResourcePredicate();
    }

    public InResourcePredicate resource(String id) {
        this.resourceId = id;
        return this;
    }

    @Override
    public boolean test(Map.Entry<String, Revisioned> entry) {
        Revisioned value = entry.getValue();
        if (value == null) {
            return false;
        }
        if (!(value instanceof InResource)) {
            return false;
        }
        return this.resourceId.equals(((InResource)((Object)value)).getResourceId());
    }

    public static class ExternalizerImpl
    implements Externalizer<InResourcePredicate> {
        private static final int VERSION_1 = 1;

        public void writeObject(ObjectOutput output, InResourcePredicate obj) throws IOException {
            output.writeByte(1);
            MarshallUtil.marshallString((String)obj.resourceId, (ObjectOutput)output);
        }

        public InResourcePredicate readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            switch (input.readByte()) {
                case 1: {
                    return this.readObjectVersion1(input);
                }
            }
            throw new IOException("Unknown version");
        }

        public InResourcePredicate readObjectVersion1(ObjectInput input) throws IOException, ClassNotFoundException {
            InResourcePredicate res = new InResourcePredicate();
            res.resourceId = MarshallUtil.unmarshallString((ObjectInput)input);
            return res;
        }
    }
}

