/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.util;

import java.beans.Introspector;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import javax.annotation.Resource;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.InjectionPoint;
import org.jboss.as.weld.logging.WeldLogger;
import org.jboss.metadata.property.PropertyReplacer;
import org.jboss.weld.injection.ParameterInjectionPoint;

public class ResourceInjectionUtilities {
    public static final String RESOURCE_LOOKUP_PREFIX = "java:comp/env";

    private ResourceInjectionUtilities() {
    }

    public static String getResourceName(String jndiName, String mappedName) {
        if (mappedName != null) {
            return mappedName;
        }
        if (jndiName != null) {
            return jndiName;
        }
        throw WeldLogger.ROOT_LOGGER.cannotDetermineResourceName();
    }

    public static String getResourceName(InjectionPoint injectionPoint, PropertyReplacer propertyReplacer) {
        String propertyName;
        Resource resource = (Resource)ResourceInjectionUtilities.getResourceAnnotated(injectionPoint).getAnnotation(Resource.class);
        String mappedName = resource.mappedName();
        if (!mappedName.equals("")) {
            return propertyReplacer == null ? mappedName : propertyReplacer.replaceProperties(mappedName);
        }
        String name = resource.name();
        if (!name.equals("")) {
            name = propertyReplacer == null ? name : propertyReplacer.replaceProperties(name);
            int firstSlash = name.indexOf("/");
            int colon = name.indexOf(":");
            if (colon != -1 && (firstSlash == -1 || colon < firstSlash)) {
                return name;
            }
            return "java:comp/env/" + name;
        }
        if (injectionPoint.getMember() instanceof Field) {
            propertyName = injectionPoint.getMember().getName();
        } else if (injectionPoint.getMember() instanceof Method) {
            propertyName = ResourceInjectionUtilities.getPropertyName((Method)injectionPoint.getMember());
            if (propertyName == null) {
                throw WeldLogger.ROOT_LOGGER.injectionPointNotAJavabean((Method)injectionPoint.getMember());
            }
        } else {
            throw WeldLogger.ROOT_LOGGER.cannotInject(injectionPoint);
        }
        String className = injectionPoint.getMember().getDeclaringClass().getName();
        return "java:comp/env/" + className + "/" + propertyName;
    }

    public static String getPropertyName(Method method) {
        String methodName = method.getName();
        if (methodName.matches("^(get).*") && method.getParameterTypes().length == 0) {
            return Introspector.decapitalize(methodName.substring(3));
        }
        if (methodName.matches("^(is).*") && method.getParameterTypes().length == 0) {
            return Introspector.decapitalize(methodName.substring(2));
        }
        if (methodName.matches("^(set).*") && method.getParameterTypes().length == 1) {
            return Introspector.decapitalize(methodName.substring(3));
        }
        return null;
    }

    public static String getPropertyName(Member member) {
        if (member instanceof Method) {
            return ResourceInjectionUtilities.getPropertyName((Method)member);
        }
        return member.getName();
    }

    public static Annotated getResourceAnnotated(InjectionPoint injectionPoint) {
        if (injectionPoint instanceof ParameterInjectionPoint) {
            return ((ParameterInjectionPoint)injectionPoint).getAnnotated().getDeclaringCallable();
        }
        return injectionPoint.getAnnotated();
    }
}

