/*
 * Decompiled with CFR 0.152.
 */
package liquibase.integration.commandline;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Console;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import liquibase.CatalogAndSchema;
import liquibase.Contexts;
import liquibase.LabelExpression;
import liquibase.Liquibase;
import liquibase.change.CheckSum;
import liquibase.changelog.visitor.ChangeExecListener;
import liquibase.command.AbstractCommand;
import liquibase.command.ExecuteSqlCommand;
import liquibase.command.SnapshotCommand;
import liquibase.configuration.GlobalConfiguration;
import liquibase.configuration.LiquibaseConfiguration;
import liquibase.database.Database;
import liquibase.diff.compare.CompareControl;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.StandardObjectChangeFilter;
import liquibase.exception.CommandLineParsingException;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.exception.ValidationFailedException;
import liquibase.integration.commandline.ChangeExecListenerUtils;
import liquibase.integration.commandline.CommandLineResourceAccessor;
import liquibase.integration.commandline.CommandLineUtils;
import liquibase.lockservice.LockService;
import liquibase.lockservice.LockServiceFactory;
import liquibase.logging.LogFactory;
import liquibase.logging.LogLevel;
import liquibase.logging.Logger;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.CompositeResourceAccessor;
import liquibase.resource.FileSystemResourceAccessor;
import liquibase.resource.ResourceAccessor;
import liquibase.servicelocator.ServiceLocator;
import liquibase.util.ISODateFormat;
import liquibase.util.LiquibaseUtil;
import liquibase.util.StreamUtil;
import liquibase.util.StringUtils;

public class Main {
    protected ClassLoader classLoader;
    protected String driver;
    protected String username;
    protected String password;
    protected String url;
    protected String databaseClass;
    protected String defaultSchemaName;
    protected String outputDefaultSchema;
    protected String outputDefaultCatalog;
    protected String liquibaseCatalogName;
    protected String liquibaseSchemaName;
    protected String databaseChangeLogTableName;
    protected String databaseChangeLogLockTableName;
    protected String defaultCatalogName;
    protected String changeLogFile;
    protected String classpath;
    protected String contexts;
    protected String labels;
    protected String driverPropertiesFile;
    protected String propertyProviderClass = null;
    protected String changeExecListenerClass;
    protected String changeExecListenerPropertiesFile;
    protected Boolean promptForNonLocalDatabase = null;
    protected Boolean includeSystemClasspath;
    protected Boolean strict = Boolean.TRUE;
    protected String defaultsFile = "liquibase.properties";
    protected String diffTypes;
    protected String changeSetAuthor;
    protected String changeSetContext;
    protected String dataOutputDirectory;
    protected String referenceDriver;
    protected String referenceUrl;
    protected String referenceUsername;
    protected String referencePassword;
    protected String referenceDefaultCatalogName;
    protected String referenceDefaultSchemaName;
    protected String currentDateTimeFunction;
    protected String command;
    protected Set<String> commandParams = new LinkedHashSet<String>();
    protected String logLevel;
    protected String logFile;
    protected Map<String, Object> changeLogParameters = new HashMap<String, Object>();
    protected String outputFile;

    public static void main(String[] args) throws CommandLineParsingException, IOException {
        try {
            Main.run(args);
        }
        catch (LiquibaseException e) {
            System.exit(-1);
        }
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void run(String[] args) throws CommandLineParsingException, IOException, LiquibaseException {
        try {
            List<String> setupMessages;
            FileInputStream stream;
            GlobalConfiguration globalConfiguration = LiquibaseConfiguration.getInstance().getConfiguration(GlobalConfiguration.class);
            if (!globalConfiguration.getShouldRun()) {
                System.err.println("Liquibase did not run because '" + LiquibaseConfiguration.getInstance().describeValueLookupLogic(globalConfiguration.getProperty("shouldRun")) + " was set to false");
                return;
            }
            Main main = new Main();
            if (args.length == 1 && "--help".equals(args[0])) {
                main.printHelp(System.err);
                return;
            }
            if (args.length == 1 && "--version".equals(args[0])) {
                System.err.println("Liquibase Version: " + LiquibaseUtil.getBuildVersion() + StreamUtil.getLineSeparator());
                return;
            }
            try {
                main.parseOptions(args);
            }
            catch (CommandLineParsingException e) {
                main.printHelp(Arrays.asList(e.getMessage()), System.err);
                throw e;
            }
            File propertiesFile = new File(main.defaultsFile);
            String localDefaultsPathName = main.defaultsFile.replaceFirst("(\\.[^\\.]+)$", ".local$1");
            File localPropertiesFile = new File(localDefaultsPathName);
            if (localPropertiesFile.exists()) {
                stream = new FileInputStream(localPropertiesFile);
                try {
                    main.parsePropertiesFile(stream);
                }
                finally {
                    stream.close();
                }
            }
            InputStream resourceAsStream = main.getClass().getClassLoader().getResourceAsStream(localDefaultsPathName);
            if (resourceAsStream != null) {
                try {
                    main.parsePropertiesFile(resourceAsStream);
                }
                finally {
                    resourceAsStream.close();
                }
            }
            if (propertiesFile.exists()) {
                stream = new FileInputStream(propertiesFile);
                try {
                    main.parsePropertiesFile(stream);
                }
                finally {
                    stream.close();
                }
            }
            resourceAsStream = main.getClass().getClassLoader().getResourceAsStream(main.defaultsFile);
            if (resourceAsStream != null) {
                try {
                    main.parsePropertiesFile(resourceAsStream);
                }
                finally {
                    resourceAsStream.close();
                }
            }
            if ((setupMessages = main.checkSetup()).size() > 0) {
                main.printHelp(setupMessages, System.err);
                return;
            }
            main.applyDefaults();
            main.configureClassLoader();
            main.doMigration();
            if ("update".equals(main.command)) {
                System.err.println("Liquibase Update Successful");
            } else if (main.command.startsWith("rollback") && !main.command.endsWith("SQL")) {
                System.err.println("Liquibase Rollback Successful");
            } else if (!main.command.endsWith("SQL")) {
                System.err.println("Liquibase '" + main.command + "' Successful");
            }
        }
        catch (Throwable e) {
            String message = e.getMessage();
            if (e.getCause() != null) {
                message = e.getCause().getMessage();
            }
            if (message == null) {
                message = "Unknown Reason";
            }
            try {
                if (e.getCause() instanceof ValidationFailedException) {
                    ((ValidationFailedException)e.getCause()).printDescriptiveError(System.out);
                } else {
                    System.err.println("Unexpected error running Liquibase: " + message + "\n");
                    LogFactory.getInstance().getLog().severe(message, e);
                    System.err.println(Main.generateLogLevelWarningMessage());
                }
            }
            catch (Exception e1) {
                e.printStackTrace();
            }
            throw new LiquibaseException("Unexpected error running Liquibase: " + message, e);
        }
    }

    private static String generateLogLevelWarningMessage() {
        Logger logger = LogFactory.getInstance().getLog();
        if (logger != null && logger.getLogLevel() != null && logger.getLogLevel().equals((Object)LogLevel.OFF)) {
            return "";
        }
        return "\n\nFor more information, use the --logLevel flag";
    }

    protected String[] fixupArgs(String[] args) {
        ArrayList<String> fixedArgs = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if ((arg.startsWith("--") || arg.startsWith("-D")) && !arg.contains("=")) {
                String nextArg = null;
                if (i + 1 < args.length) {
                    nextArg = args[i + 1];
                }
                if (nextArg != null && !nextArg.startsWith("--") && !this.isCommand(nextArg)) {
                    arg = arg + "=" + nextArg;
                    ++i;
                }
            }
            arg = arg.replace("\\,", ",");
            fixedArgs.add(arg);
        }
        return fixedArgs.toArray(new String[fixedArgs.size()]);
    }

    protected List<String> checkSetup() {
        ArrayList<String> messages = new ArrayList<String>();
        if (this.command == null) {
            messages.add("Command not passed");
        } else if (!this.isCommand(this.command)) {
            messages.add("Unknown command: " + this.command);
        } else {
            if (this.url == null) {
                messages.add("--url is required");
            }
            if (this.isChangeLogRequired(this.command) && this.changeLogFile == null) {
                messages.add("--changeLogFile is required");
            }
            if (this.isNoArgCommand(this.command) && !this.commandParams.isEmpty()) {
                messages.add("unexpected command parameters: " + this.commandParams);
            } else {
                this.validateCommandParameters(messages);
            }
        }
        return messages;
    }

    private void checkForUnexpectedCommandParameter(List<String> messages) {
        block7: {
            block8: {
                block6: {
                    if (!"updateCount".equalsIgnoreCase(this.command) && !"updateCountSQL".equalsIgnoreCase(this.command) && !"updateToTag".equalsIgnoreCase(this.command) && !"updateToTagSQL".equalsIgnoreCase(this.command) && !"calculateCheckSum".equalsIgnoreCase(this.command) && !"dbDoc".equalsIgnoreCase(this.command) && !"tag".equalsIgnoreCase(this.command) && !"tagExists".equalsIgnoreCase(this.command)) break block6;
                    if (this.commandParams.size() <= 0 || !this.commandParams.iterator().next().startsWith("-")) break block7;
                    messages.add("unexpected command parameters: " + this.commandParams);
                    break block7;
                }
                if (!"status".equalsIgnoreCase(this.command) && !"unexpectedChangeSets".equalsIgnoreCase(this.command)) break block8;
                if (this.commandParams.size() <= 0 || this.commandParams.iterator().next().equalsIgnoreCase("--verbose")) break block7;
                messages.add("unexpected command parameters: " + this.commandParams);
                break block7;
            }
            if ("diff".equalsIgnoreCase(this.command) || "diffChangeLog".equalsIgnoreCase(this.command)) {
                if (this.commandParams.size() > 0) {
                    for (String cmdParm : this.commandParams) {
                        if (cmdParm.startsWith("--referenceUsername") || cmdParm.startsWith("--referencePassword") || cmdParm.startsWith("--referenceDriver") || cmdParm.startsWith("--referenceDefaultCatalogName") || cmdParm.startsWith("--referenceDefaultSchemaName") || cmdParm.startsWith("--includeSchema") || cmdParm.startsWith("--includeCatalog") || cmdParm.startsWith("--includeTablespace") || cmdParm.startsWith("--schemas") || cmdParm.startsWith("--outputSchemasAs") || cmdParm.startsWith("--referenceSchemas") || cmdParm.startsWith("--referenceUrl") || cmdParm.startsWith("--excludeObjects") || cmdParm.startsWith("--includeObjects") || cmdParm.startsWith("--diffTypes")) continue;
                        messages.add("unexpected command parameter: " + cmdParm);
                    }
                } else if (("snapshot".equalsIgnoreCase(this.command) || "generateChangeLog".equalsIgnoreCase(this.command)) && this.commandParams.size() > 0) {
                    for (String cmdParm : this.commandParams) {
                        if (cmdParm.startsWith("--includeSchema") || cmdParm.startsWith("--includeCatalog") || cmdParm.startsWith("--includeTablespace") || cmdParm.startsWith("--schemas")) continue;
                        messages.add("unexpected command parameter: " + cmdParm);
                    }
                }
            }
        }
    }

    private void validateCommandParameters(List<String> messages) {
        this.checkForUnexpectedCommandParameter(messages);
        this.checkForMissingCommandParameters(messages);
        this.checkForMalformedCommandParameters(messages);
    }

    private void checkForMissingCommandParameters(List<String> messages) {
        if ((this.commandParams.isEmpty() || this.commandParams.iterator().next().startsWith("-")) && "calculateCheckSum".equalsIgnoreCase(this.command)) {
            messages.add("missing changeSet identifier");
        }
    }

    private void checkForMalformedCommandParameters(List<String> messages) {
        if (!this.commandParams.isEmpty()) {
            if ("calculateCheckSum".equalsIgnoreCase(this.command)) {
                for (String param : this.commandParams) {
                    String[] parts;
                    assert (param != null);
                    if (param == null || param.startsWith("-") || (parts = param.split("::")) != null && parts.length >= 3) continue;
                    messages.add("changeSet identifier must be of the form filepath::id::author");
                    break;
                }
            } else if ("diffChangeLog".equalsIgnoreCase(this.command) && this.diffTypes != null && this.diffTypes.toLowerCase().contains("data")) {
                messages.add("Including diffTypes=data in the diffChangeLog command has no effect. This option should only be used with the generateChangeLog command.");
            }
        }
    }

    private boolean isChangeLogRequired(String command) {
        return command.toLowerCase().startsWith("update") || command.toLowerCase().startsWith("rollback") || "calculateCheckSum".equalsIgnoreCase(command) || "status".equalsIgnoreCase(command) || "validate".equalsIgnoreCase(command) || "changeLogSync".equalsIgnoreCase(command) || "changeLogSyncSql".equalsIgnoreCase(command) || "generateChangeLog".equalsIgnoreCase(command);
    }

    private boolean isCommand(String arg) {
        return "migrate".equals(arg) || "migrateSQL".equalsIgnoreCase(arg) || "update".equalsIgnoreCase(arg) || "updateSQL".equalsIgnoreCase(arg) || "updateCount".equalsIgnoreCase(arg) || "updateCountSQL".equalsIgnoreCase(arg) || "updateToTag".equalsIgnoreCase(arg) || "updateToTagSQL".equalsIgnoreCase(arg) || "rollback".equalsIgnoreCase(arg) || "rollbackToDate".equalsIgnoreCase(arg) || "rollbackCount".equalsIgnoreCase(arg) || "rollbackSQL".equalsIgnoreCase(arg) || "rollbackToDateSQL".equalsIgnoreCase(arg) || "rollbackCountSQL".equalsIgnoreCase(arg) || "futureRollbackSQL".equalsIgnoreCase(arg) || "futureRollbackCountSQL".equalsIgnoreCase(arg) || "futureRollbackToTagSQL".equalsIgnoreCase(arg) || "updateTestingRollback".equalsIgnoreCase(arg) || "tag".equalsIgnoreCase(arg) || "tagExists".equalsIgnoreCase(arg) || "listLocks".equalsIgnoreCase(arg) || "dropAll".equalsIgnoreCase(arg) || "releaseLocks".equalsIgnoreCase(arg) || "status".equalsIgnoreCase(arg) || "unexpectedChangeSets".equalsIgnoreCase(arg) || "validate".equalsIgnoreCase(arg) || "help".equalsIgnoreCase(arg) || "diff".equalsIgnoreCase(arg) || "diffChangeLog".equalsIgnoreCase(arg) || "generateChangeLog".equalsIgnoreCase(arg) || "snapshot".equalsIgnoreCase(arg) || "snapshotReference".equalsIgnoreCase(arg) || "executeSql".equalsIgnoreCase(arg) || "calculateCheckSum".equalsIgnoreCase(arg) || "clearCheckSums".equalsIgnoreCase(arg) || "dbDoc".equalsIgnoreCase(arg) || "changelogSync".equalsIgnoreCase(arg) || "changelogSyncSQL".equalsIgnoreCase(arg) || "markNextChangeSetRan".equalsIgnoreCase(arg) || "markNextChangeSetRanSQL".equalsIgnoreCase(arg);
    }

    private boolean isNoArgCommand(String arg) {
        return "migrate".equals(arg) || "migrateSQL".equalsIgnoreCase(arg) || "update".equalsIgnoreCase(arg) || "updateSQL".equalsIgnoreCase(arg) || "futureRollbackSQL".equalsIgnoreCase(arg) || "updateTestingRollback".equalsIgnoreCase(arg) || "listLocks".equalsIgnoreCase(arg) || "dropAll".equalsIgnoreCase(arg) || "releaseLocks".equalsIgnoreCase(arg) || "validate".equalsIgnoreCase(arg) || "help".equalsIgnoreCase(arg) || "clearCheckSums".equalsIgnoreCase(arg) || "changelogSync".equalsIgnoreCase(arg) || "changelogSyncSQL".equalsIgnoreCase(arg) || "markNextChangeSetRan".equalsIgnoreCase(arg) || "markNextChangeSetRanSQL".equalsIgnoreCase(arg);
    }

    protected void parsePropertiesFile(InputStream propertiesInputStream) throws IOException, CommandLineParsingException {
        Properties props = new Properties();
        props.load(propertiesInputStream);
        if (props.containsKey("strict")) {
            this.strict = Boolean.valueOf(props.getProperty("strict"));
        }
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            try {
                if (entry.getKey().equals("promptOnNonLocalDatabase")) continue;
                if (((String)entry.getKey()).startsWith("parameter.")) {
                    this.changeLogParameters.put(((String)entry.getKey()).replaceFirst("^parameter.", ""), entry.getValue());
                    continue;
                }
                Field field = this.getClass().getDeclaredField((String)entry.getKey());
                Object currentValue = field.get(this);
                if (currentValue != null) continue;
                String value = entry.getValue().toString().trim();
                if (field.getType().equals(Boolean.class)) {
                    field.set(this, Boolean.valueOf(value));
                    continue;
                }
                field.set(this, value);
            }
            catch (NoSuchFieldException nsfe) {
                if (this.strict.booleanValue()) {
                    throw new CommandLineParsingException("Unknown parameter: '" + entry.getKey() + "'");
                }
                LogFactory.getInstance().getLog().info("Ignored parameter: " + entry.getKey());
            }
            catch (Exception e) {
                throw new CommandLineParsingException("Unknown parameter: '" + entry.getKey() + "'");
            }
        }
    }

    protected void printHelp(List<String> errorMessages, PrintStream stream) {
        stream.println("Errors:");
        for (String message : errorMessages) {
            stream.println("  " + message);
        }
        stream.println();
        this.printHelp(stream);
    }

    protected void printWarning(List<String> warningMessages, PrintStream stream) {
        stream.println("Warnings:");
        for (String message : warningMessages) {
            stream.println("  " + message);
        }
        stream.println();
    }

    protected void printHelp(PrintStream stream) {
        stream.println("Usage: java -jar liquibase.jar [options] [command]");
        stream.println("");
        stream.println("Standard Commands:");
        stream.println(" update                         Updates database to current version");
        stream.println(" updateSQL                      Writes SQL to update database to current");
        stream.println("                                version to STDOUT");
        stream.println(" updateCount <num>              Applies next NUM changes to the database");
        stream.println(" updateCountSQL <num>           Writes SQL to apply next NUM changes");
        stream.println("                                to the database");
        stream.println(" updateToTag <tag>              Updates the database to the changeSet with the");
        stream.println("                                specified tag");
        stream.println(" updateToTagSQL <tag>           Writes (to standard out) the SQL to update to");
        stream.println("                                the changeSet with the specified tag");
        stream.println(" rollback <tag>                 Rolls back the database to the the state is was");
        stream.println("                                when the tag was applied");
        stream.println(" rollbackSQL <tag>              Writes SQL to roll back the database to that");
        stream.println("                                state it was in when the tag was applied");
        stream.println("                                to STDOUT");
        stream.println(" rollbackToDate <date/time>     Rolls back the database to the the state is was");
        stream.println("                                at the given date/time.");
        stream.println("                                Date Format: yyyy-MM-dd'T'HH:mm:ss");
        stream.println(" rollbackToDateSQL <date/time>  Writes SQL to roll back the database to that");
        stream.println("                                state it was in at the given date/time version");
        stream.println("                                to STDOUT");
        stream.println(" rollbackCount <value>          Rolls back the last <value> change sets");
        stream.println("                                applied to the database");
        stream.println(" rollbackCountSQL <value>       Writes SQL to roll back the last");
        stream.println("                                <value> change sets to STDOUT");
        stream.println("                                applied to the database");
        stream.println(" futureRollbackSQL              Writes SQL to roll back the database to the ");
        stream.println("                                current state after the changes in the ");
        stream.println("                                changeslog have been applied");
        stream.println(" futureRollbackSQL <value>      Writes SQL to roll back the database to the ");
        stream.println("                                current state after <value> changes in the ");
        stream.println("                                changeslog have been applied");
        stream.println(" futureRollbackFromTagSQL <tag> Writes (to standard out) the SQL to roll back");
        stream.println("                                the database to its current state after the");
        stream.println("                                changes up to the specified tag have been");
        stream.println("                                applied");
        stream.println(" updateTestingRollback          Updates database, then rolls back changes before");
        stream.println("                                updating again. Useful for testing");
        stream.println("                                rollback support");
        stream.println(" generateChangeLog              Writes Change Log XML to copy the current state");
        stream.println("                                of the database to standard out");
        stream.println(" snapshot                       Writes the current state");
        stream.println("                                of the database to standard out");
        stream.println(" snapshotReference              Writes the current state");
        stream.println("                                of the referenceUrl database to standard out");
        stream.println("");
        stream.println("Diff Commands");
        stream.println(" diff [diff parameters]          Writes description of differences");
        stream.println("                                 to standard out");
        stream.println(" diffChangeLog [diff parameters] Writes Change Log XML to update");
        stream.println("                                 the database");
        stream.println("                                 to the reference database to standard out");
        stream.println("");
        stream.println("Documentation Commands");
        stream.println(" dbDoc <outputDirectory>         Generates Javadoc-like documentation");
        stream.println("                                 based on current database and change log");
        stream.println("");
        stream.println("Maintenance Commands");
        stream.println(" tag <tag string>          'Tags' the current database state for future rollback");
        stream.println(" tagExists <tag string>    Checks whether the given tag is already existing");
        stream.println(" status [--verbose]        Outputs count (list if --verbose) of unrun changesets");
        stream.println(" unexpectedChangeSets [--verbose]");
        stream.println("                           Outputs count (list if --verbose) of changesets run");
        stream.println("                           in the database that do not exist in the changelog.");
        stream.println(" validate                  Checks changelog for errors");
        stream.println(" calculateCheckSum <id>    Calculates and prints a checksum for the changeset");
        stream.println("                           with the given id in the format filepath::id::author.");
        stream.println(" clearCheckSums            Removes all saved checksums from database log.");
        stream.println("                           Useful for 'MD5Sum Check Failed' errors");
        stream.println(" changelogSync             Mark all changes as executed in the database");
        stream.println(" changelogSyncSQL          Writes SQL to mark all changes as executed ");
        stream.println("                           in the database to STDOUT");
        stream.println(" markNextChangeSetRan      Mark the next change changes as executed ");
        stream.println("                           in the database");
        stream.println(" markNextChangeSetRanSQL   Writes SQL to mark the next change ");
        stream.println("                           as executed in the database to STDOUT");
        stream.println(" listLocks                 Lists who currently has locks on the");
        stream.println("                           database changelog");
        stream.println(" releaseLocks              Releases all locks on the database changelog");
        stream.println(" dropAll                   Drop all database objects owned by user");
        stream.println("");
        stream.println("Required Parameters:");
        stream.println(" --changeLogFile=<path and filename>        Migration file");
        stream.println(" --username=<value>                         Database username");
        stream.println(" --password=<value>                         Database password. If values");
        stream.println("                                            is PROMPT, Liquibase will");
        stream.println("                                            prompt for a password");
        stream.println(" --url=<value>                              Database URL");
        stream.println("");
        stream.println("Optional Parameters:");
        stream.println(" --classpath=<value>                        Classpath containing");
        stream.println("                                            migration files and JDBC Driver");
        stream.println(" --driver=<jdbc.driver.ClassName>           Database driver class name");
        stream.println(" --databaseClass=<database.ClassName>       custom liquibase.database.Database");
        stream.println("                                            implementation to use");
        stream.println(" --propertyProviderClass=<properties.ClassName>  custom Properties");
        stream.println("                                            implementation to use");
        stream.println(" --defaultSchemaName=<name>                 Default database schema to use");
        stream.println(" --contexts=<value>                         ChangeSet contexts to execute");
        stream.println(" --labels=<expression>                      Expression defining labeled");
        stream.println("                                            ChangeSet to execute");
        stream.println(" --defaultsFile=</path/to/file.properties>  File with default option values");
        stream.println("                                            (default: ./liquibase.properties)");
        stream.println(" --delimiter=<string>                       Used with executeSql command to set");
        stream.println("                                            the string used to break up files");
        stream.println("                                            that consist of multiple statements.");
        stream.println(" --driverPropertiesFile=</path/to/file.properties>  File with custom properties");
        stream.println("                                            to be set on the JDBC connection");
        stream.println("                                            to be created");
        stream.println(" --changeExecListenerClass=<ChangeExecListener.ClassName>     Custom Change Exec");
        stream.println("                                            listener implementation to use");
        stream.println(" --changeExecListenerPropertiesFile=</path/to/file.properties> Properties for");
        stream.println("                                            Custom Change Exec listener");
        stream.println(" --liquibaseCatalogName=<name>              The name of the catalog with the");
        stream.println("                                            liquibase tables");
        stream.println(" --liquibaseSchemaName=<name>               The name of the schema with the");
        stream.println("                                            liquibase tables");
        stream.println(" --databaseChangeLogTableName=<name>        The name of the Liquibase ChangeLog");
        stream.println("                                            table (default: DATABASECHANGELOG)");
        stream.println(" --databaseChangeLogLockTableName=<name>    The name of the Liquibase ChangeLog");
        stream.println("                                            Lock table");
        stream.println("                                            (default: DATABASECHANGELOGLOCK)");
        stream.println(" --liquibaseSchemaName=<name>               The name of the schema with the");
        stream.println("                                            liquibase tables");
        stream.println(" --includeSystemClasspath=<true|false>      Include the system classpath");
        stream.println("                                            in the Liquibase classpath");
        stream.println("                                            (default: true)");
        stream.println(" --promptForNonLocalDatabase=<true|false>   Prompt if non-localhost");
        stream.println("                                            databases (default: false)");
        stream.println(" --logLevel=<level>                         Execution log level");
        stream.println("                                            (debug, info, warning, severe, off");
        stream.println(" --logFile=<file>                           Log file");
        stream.println(" --currentDateTimeFunction=<value>          Overrides current date time function");
        stream.println("                                            used in SQL.");
        stream.println("                                            Useful for unsupported databases");
        stream.println(" --outputDefaultSchema=<true|false>         If true, SQL object references");
        stream.println("                                            include the schema name, even if");
        stream.println("                                            it is the default schema. ");
        stream.println("                                            Defaults to true");
        stream.println(" --outputDefaultCatalog=<true|false>        If true, SQL object references");
        stream.println("                                            include the catalog name, even if");
        stream.println("                                            it is the default catalog.");
        stream.println("                                            Defaults to true");
        stream.println(" --outputFile=<file>                        File to write output to for commands");
        stream.println("                                            that write output, e.g. updateSQL.");
        stream.println("                                            If not specified, writes to sysout.");
        stream.println(" --help                                     Prints this message");
        stream.println(" --version                                  Prints this version information");
        stream.println("");
        stream.println("Required Diff Parameters:");
        stream.println(" --referenceUsername=<value>                Reference Database username");
        stream.println(" --referencePassword=<value>                Reference Database password. If");
        stream.println("                                            value is PROMPT, Liquibase will");
        stream.println("                                            prompt for a password");
        stream.println(" --referenceUrl=<value>                     Reference Database URL");
        stream.println("");
        stream.println("Optional Diff Parameters:");
        stream.println(" --defaultCatalogName=<name>                Default database catalog to use");
        stream.println(" --defaultSchemaName=<name>                 Default database schema to use");
        stream.println(" --referenceDefaultCatalogName=<name>       Reference database catalog to use");
        stream.println(" --referenceDefaultSchemaName=<name>        Reference database schema to use");
        stream.println(" --schemas=<name1,name2>                    Database schemas to include");
        stream.println("                                            objects from in comparison");
        stream.println(" --referenceSchemas=<name1,name2>           Reference database schemas to");
        stream.println("                                            include objects from in comparison");
        stream.println("                                            only needed if different than");
        stream.println("                                            --schemas");
        stream.println(" --outputSchemaAs=<name1,name2>             On diffChangeLog/generateChangeLog,");
        stream.println("                                            use these names as schemaName");
        stream.println("                                            instead of the real names.");
        stream.println(" --includeCatalog=<true|false>              If true, the catalog will be");
        stream.println("                                            included in generated changeSets");
        stream.println("                                            Defaults to false");
        stream.println(" --includeSchema=<true|false>               If true, the schema will be");
        stream.println("                                            included in generated changeSets");
        stream.println("                                            Defaults to false");
        stream.println(" --referenceDriver=<jdbc.driver.ClassName>  Reference database driver class name");
        stream.println(" --dataOutputDirectory=DIR                  Output data as CSV in the given ");
        stream.println("                                            directory");
        stream.println(" --diffTypes                                List of diff types to include in");
        stream.println("                                            Change Log expressed as a comma");
        stream.println("                                            separated list from: tables, views,");
        stream.println("                                            columns, indexes, foreignkeys,");
        stream.println("                                            primarykeys, uniqueconstraints");
        stream.println("                                            data.");
        stream.println("                                            If this is null then the default");
        stream.println("                                            types will be: tables, views,");
        stream.println("                                            columns, indexes, foreignkeys,");
        stream.println("                                             primarykeys, uniqueconstraints.");
        stream.println("");
        stream.println("Change Log Properties:");
        stream.println(" -D<property.name>=<property.value>         Pass a name/value pair for");
        stream.println("                                            substitution in the change log(s)");
        stream.println("");
        stream.println("Default value for parameters can be stored in a file called");
        stream.println("'liquibase.properties' that is read from the current working directory.");
        stream.println("");
        stream.println("Full documentation is available at");
        stream.println("http://www.liquibase.org/documentation/command_line.html");
        stream.println("");
    }

    protected void parseOptions(String[] args) throws CommandLineParsingException {
        args = this.fixupArgs(args);
        boolean seenCommand = false;
        for (String arg : args) {
            String value;
            String attributeName;
            String[] splitArg;
            if (this.isCommand(arg)) {
                this.command = arg;
                if (this.command.equalsIgnoreCase("migrate")) {
                    this.command = "update";
                } else if (this.command.equalsIgnoreCase("migrateSQL")) {
                    this.command = "updateSQL";
                }
                seenCommand = true;
                continue;
            }
            if (seenCommand) {
                if (arg.startsWith("-D")) {
                    splitArg = this.splitArg(arg);
                    attributeName = splitArg[0].replaceFirst("^-D", "");
                    value = splitArg[1];
                    this.changeLogParameters.put(attributeName, value);
                    continue;
                }
                this.commandParams.add(arg);
                continue;
            }
            if (arg.startsWith("--")) {
                splitArg = this.splitArg(arg);
                attributeName = splitArg[0];
                value = splitArg[1];
                if (StringUtils.trimToEmpty(value).equalsIgnoreCase("PROMPT")) {
                    Console c = System.console();
                    if (c == null) {
                        throw new CommandLineParsingException("Console unavailable");
                    }
                    value = attributeName.toLowerCase().contains("password") ? new String(c.readPassword(attributeName + ": ", new Object[0])) : c.readLine(attributeName + ": ", new Object[0]);
                }
                try {
                    Field field = this.getClass().getDeclaredField(attributeName);
                    if (field.getType().equals(Boolean.class)) {
                        field.set(this, Boolean.valueOf(value));
                        continue;
                    }
                    field.set(this, value);
                    continue;
                }
                catch (Exception e) {
                    throw new CommandLineParsingException("Unknown parameter: '" + attributeName + "'");
                }
            }
            throw new CommandLineParsingException("Unexpected value " + arg + ": parameters must start with a '--'");
        }
    }

    private String[] splitArg(String arg) throws CommandLineParsingException {
        String[] splitArg = arg.split("=", 2);
        if (splitArg.length < 2) {
            throw new CommandLineParsingException("Could not parse '" + arg + "'");
        }
        splitArg[0] = splitArg[0].replaceFirst("--", "");
        return splitArg;
    }

    protected void applyDefaults() {
        if (this.promptForNonLocalDatabase == null) {
            this.promptForNonLocalDatabase = Boolean.FALSE;
        }
        if (this.logLevel == null) {
            this.logLevel = "off";
        }
        if (this.includeSystemClasspath == null) {
            this.includeSystemClasspath = Boolean.TRUE;
        }
        if (this.outputDefaultCatalog == null) {
            this.outputDefaultCatalog = "true";
        }
        if (this.outputDefaultSchema == null) {
            this.outputDefaultSchema = "true";
        }
        if (this.defaultsFile == null) {
            this.defaultsFile = "liquibase.properties";
        }
    }

    protected void configureClassLoader() throws CommandLineParsingException {
        final ArrayList<URL> urls = new ArrayList<URL>();
        if (this.classpath != null) {
            String[] classpath = this.isWindows() ? this.classpath.split(";") : this.classpath.split(":");
            Logger logger = LogFactory.getInstance().getLog();
            for (String classpathEntry : classpath) {
                File classPathFile = new File(classpathEntry);
                if (!classPathFile.exists()) {
                    throw new CommandLineParsingException(classPathFile.getAbsolutePath() + " does not exist");
                }
                try {
                    if (classpathEntry.endsWith(".war")) {
                        this.addWarFileClasspathEntries(classPathFile, urls);
                        continue;
                    }
                    if (classpathEntry.endsWith(".ear")) {
                        JarFile earZip = new JarFile(classPathFile);
                        Enumeration<JarEntry> entries = earZip.entries();
                        while (entries.hasMoreElements()) {
                            JarEntry entry = entries.nextElement();
                            if (entry.getName().toLowerCase().endsWith(".jar")) {
                                File jar = this.extract(earZip, entry);
                                URL newUrl = new URL("jar:" + jar.toURI().toURL() + "!/");
                                urls.add(newUrl);
                                logger.debug("Adding '" + newUrl + "' to classpath");
                                jar.deleteOnExit();
                                continue;
                            }
                            if (!entry.getName().toLowerCase().endsWith("war")) continue;
                            File warFile = this.extract(earZip, entry);
                            this.addWarFileClasspathEntries(warFile, urls);
                        }
                        continue;
                    }
                    URL newUrl = new File(classpathEntry).toURI().toURL();
                    logger.debug("Adding '" + newUrl + "' to classpath");
                    urls.add(newUrl);
                }
                catch (Exception e) {
                    throw new CommandLineParsingException(e);
                }
            }
        }
        this.classLoader = this.includeSystemClasspath != false ? (ClassLoader)AccessController.doPrivileged(new PrivilegedAction<URLClassLoader>(){

            @Override
            public URLClassLoader run() {
                return new URLClassLoader(urls.toArray(new URL[urls.size()]), Thread.currentThread().getContextClassLoader());
            }
        }) : (ClassLoader)AccessController.doPrivileged(new PrivilegedAction<URLClassLoader>(){

            @Override
            public URLClassLoader run() {
                return new URLClassLoader(urls.toArray(new URL[urls.size()]), null);
            }
        });
        ServiceLocator.getInstance().setResourceAccessor(new ClassLoaderResourceAccessor(this.classLoader));
        Thread.currentThread().setContextClassLoader(this.classLoader);
    }

    private void addWarFileClasspathEntries(File classPathFile, List<URL> urls) throws IOException {
        Logger logger = LogFactory.getInstance().getLog();
        URL url = new URL("jar:" + classPathFile.toURI().toURL() + "!/WEB-INF/classes/");
        logger.info("adding '" + url + "' to classpath");
        urls.add(url);
        JarFile warZip = new JarFile(classPathFile);
        Enumeration<JarEntry> entries = warZip.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            if (!entry.getName().startsWith("WEB-INF/lib") || !entry.getName().toLowerCase().endsWith(".jar")) continue;
            File jar = this.extract(warZip, entry);
            URL newUrl = new URL("jar:" + jar.toURI().toURL() + "!/");
            logger.info("adding '" + newUrl + "' to classpath");
            urls.add(newUrl);
            jar.deleteOnExit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File extract(JarFile jar, JarEntry entry) throws IOException {
        File tempFile = File.createTempFile("liquibase.tmp", null);
        BufferedInputStream inStream = null;
        FilterOutputStream outStream = null;
        try {
            int status;
            inStream = new BufferedInputStream(jar.getInputStream(entry));
            outStream = new BufferedOutputStream(new FileOutputStream(tempFile));
            while ((status = inStream.read()) != -1) {
                ((BufferedOutputStream)outStream).write(status);
            }
        }
        finally {
            if (outStream != null) {
                try {
                    outStream.close();
                }
                catch (IOException iOException) {}
            }
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return tempFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doMigration() throws Exception {
        block129: {
            if ("help".equalsIgnoreCase(this.command)) {
                this.printHelp(System.err);
                return;
            }
            try {
                if (null != this.logFile) {
                    LogFactory.getInstance().getLog().setLogLevel(this.logLevel, this.logFile);
                } else {
                    LogFactory.getInstance().getLog().setLogLevel(this.logLevel);
                }
            }
            catch (IllegalArgumentException e) {
                throw new CommandLineParsingException(e.getMessage(), e);
            }
            FileSystemResourceAccessor fsOpener = new FileSystemResourceAccessor();
            CommandLineResourceAccessor clOpener = new CommandLineResourceAccessor(this.classLoader);
            CompositeResourceAccessor fileOpener = new CompositeResourceAccessor(fsOpener, clOpener);
            Database database = CommandLineUtils.createDatabaseObject(fileOpener, this.url, this.username, this.password, this.driver, this.defaultCatalogName, this.defaultSchemaName, Boolean.parseBoolean(this.outputDefaultCatalog), Boolean.parseBoolean(this.outputDefaultSchema), this.databaseClass, this.driverPropertiesFile, this.propertyProviderClass, this.liquibaseCatalogName, this.liquibaseSchemaName, this.databaseChangeLogTableName, this.databaseChangeLogLockTableName);
            try {
                AbstractCommand command;
                CompareControl.ComputedSchemas computedSchemas = CompareControl.computeSchemas(this.getCommandParam("schemas", null), this.getCommandParam("referenceSchemas", null), this.getCommandParam("outputSchemasAs", null), this.defaultCatalogName, this.defaultSchemaName, this.referenceDefaultCatalogName, this.referenceDefaultSchemaName, database);
                CompareControl.SchemaComparison[] finalSchemaComparisons = computedSchemas.finalSchemaComparisons;
                CatalogAndSchema[] finalTargetSchemas = computedSchemas.finalTargetSchemas;
                boolean includeCatalog = Boolean.parseBoolean(this.getCommandParam("includeCatalog", "false"));
                boolean includeSchema = Boolean.parseBoolean(this.getCommandParam("includeSchema", "false"));
                boolean includeTablespace = Boolean.parseBoolean(this.getCommandParam("includeTablespace", "false"));
                String excludeObjects = StringUtils.trimToNull(this.getCommandParam("excludeObjects", null));
                String includeObjects = StringUtils.trimToNull(this.getCommandParam("includeObjects", null));
                DiffOutputControl diffOutputControl = new DiffOutputControl(includeCatalog, includeSchema, includeTablespace, finalSchemaComparisons);
                if (excludeObjects != null && includeObjects != null) {
                    throw new UnexpectedLiquibaseException("Cannot specify both excludeObjects and includeObjects");
                }
                if (excludeObjects != null) {
                    diffOutputControl.setObjectChangeFilter(new StandardObjectChangeFilter(StandardObjectChangeFilter.FilterType.EXCLUDE, excludeObjects));
                }
                if (includeObjects != null) {
                    diffOutputControl.setObjectChangeFilter(new StandardObjectChangeFilter(StandardObjectChangeFilter.FilterType.INCLUDE, includeObjects));
                }
                for (CompareControl.SchemaComparison schema : finalSchemaComparisons) {
                    diffOutputControl.addIncludedSchema(schema.getReferenceSchema());
                    diffOutputControl.addIncludedSchema(schema.getComparisonSchema());
                }
                if ("diff".equalsIgnoreCase(this.command)) {
                    CommandLineUtils.doDiff(this.createReferenceDatabaseFromCommandParams(this.commandParams, fileOpener), database, StringUtils.trimToNull(this.diffTypes), finalSchemaComparisons);
                    return;
                }
                if ("diffChangeLog".equalsIgnoreCase(this.command)) {
                    CommandLineUtils.doDiffToChangeLog(this.changeLogFile, this.createReferenceDatabaseFromCommandParams(this.commandParams, fileOpener), database, diffOutputControl, StringUtils.trimToNull(this.diffTypes), finalSchemaComparisons);
                    return;
                }
                if ("generateChangeLog".equalsIgnoreCase(this.command)) {
                    File file;
                    String changeLogFile = this.changeLogFile;
                    if (changeLogFile == null) {
                        changeLogFile = "";
                    }
                    if ((file = new File(changeLogFile)).exists()) {
                        throw new LiquibaseException("ChangeLogFile " + changeLogFile + " already exists!");
                    }
                    CommandLineUtils.doGenerateChangeLog(changeLogFile, database, finalTargetSchemas, StringUtils.trimToNull(this.diffTypes), StringUtils.trimToNull(this.changeSetAuthor), StringUtils.trimToNull(this.changeSetContext), StringUtils.trimToNull(this.dataOutputDirectory), diffOutputControl);
                    return;
                }
                if ("snapshot".equalsIgnoreCase(this.command)) {
                    command = new SnapshotCommand();
                    ((SnapshotCommand)command).setDatabase(database);
                    ((SnapshotCommand)command).setSchemas(this.getCommandParam("schemas", database.getDefaultSchema().getSchemaName()));
                    ((SnapshotCommand)command).setSerializerFormat(this.getCommandParam("snapshotFormat", null));
                    Writer outputWriter = this.getOutputWriter();
                    outputWriter.write(command.execute().toString());
                    outputWriter.flush();
                    outputWriter.close();
                    return;
                }
                if ("executeSql".equalsIgnoreCase(this.command)) {
                    command = new ExecuteSqlCommand();
                    ((ExecuteSqlCommand)command).setDatabase(database);
                    ((ExecuteSqlCommand)command).setSql(this.getCommandParam("sql", null));
                    ((ExecuteSqlCommand)command).setSqlFile(this.getCommandParam("sqlFile", null));
                    ((ExecuteSqlCommand)command).setDelimiter(this.getCommandParam("delimiter", ";"));
                    Writer outputWriter = this.getOutputWriter();
                    outputWriter.write(command.execute().toString());
                    outputWriter.flush();
                    outputWriter.close();
                    return;
                }
                if ("snapshotReference".equalsIgnoreCase(this.command)) {
                    command = new SnapshotCommand();
                    Database referenceDatabase = this.createReferenceDatabaseFromCommandParams(this.commandParams, fileOpener);
                    ((SnapshotCommand)command).setDatabase(referenceDatabase);
                    ((SnapshotCommand)command).setSchemas(this.getCommandParam("schemas", referenceDatabase.getDefaultSchema().getSchemaName()));
                    Writer outputWriter = this.getOutputWriter();
                    outputWriter.write(command.execute().toString());
                    outputWriter.flush();
                    outputWriter.close();
                    return;
                }
                Liquibase liquibase = new Liquibase(this.changeLogFile, (ResourceAccessor)fileOpener, database);
                ChangeExecListener listener = ChangeExecListenerUtils.getChangeExecListener(liquibase.getDatabase(), liquibase.getResourceAccessor(), this.changeExecListenerClass, this.changeExecListenerPropertiesFile);
                liquibase.setChangeExecListener(listener);
                liquibase.setCurrentDateTimeFunction(this.currentDateTimeFunction);
                for (Map.Entry<String, Object> entry : this.changeLogParameters.entrySet()) {
                    liquibase.setChangeLogParameter(entry.getKey(), entry.getValue());
                }
                if ("listLocks".equalsIgnoreCase(this.command)) {
                    liquibase.reportLocks(System.err);
                    return;
                }
                if ("releaseLocks".equalsIgnoreCase(this.command)) {
                    LockService lockService = LockServiceFactory.getInstance().getLockService(database);
                    lockService.forceReleaseLock();
                    System.err.println("Successfully released all database change log locks for " + liquibase.getDatabase().getConnection().getConnectionUserName() + "@" + liquibase.getDatabase().getConnection().getURL());
                    return;
                }
                if ("tag".equalsIgnoreCase(this.command)) {
                    liquibase.tag(this.getCommandArgument());
                    System.err.println("Successfully tagged " + liquibase.getDatabase().getConnection().getConnectionUserName() + "@" + liquibase.getDatabase().getConnection().getURL());
                    return;
                }
                if ("tagExists".equalsIgnoreCase(this.command)) {
                    String tag = this.commandParams.iterator().next();
                    boolean exists = liquibase.tagExists(tag);
                    if (exists) {
                        System.err.println("The tag " + tag + " already exists in " + liquibase.getDatabase().getConnection().getConnectionUserName() + "@" + liquibase.getDatabase().getConnection().getURL());
                    } else {
                        System.err.println("The tag " + tag + " does not exist in " + liquibase.getDatabase().getConnection().getConnectionUserName() + "@" + liquibase.getDatabase().getConnection().getURL());
                    }
                    return;
                }
                if ("dropAll".equals(this.command)) {
                    liquibase.dropAll();
                    System.err.println("All objects dropped from " + liquibase.getDatabase().getConnection().getConnectionUserName() + "@" + liquibase.getDatabase().getConnection().getURL());
                    return;
                }
                if ("status".equalsIgnoreCase(this.command)) {
                    boolean runVerbose = false;
                    if (this.commandParams.contains("--verbose")) {
                        runVerbose = true;
                    }
                    liquibase.reportStatus(runVerbose, new Contexts(this.contexts), new LabelExpression(this.labels), this.getOutputWriter());
                    return;
                }
                if ("unexpectedChangeSets".equalsIgnoreCase(this.command)) {
                    boolean runVerbose = false;
                    if (this.commandParams.contains("--verbose")) {
                        runVerbose = true;
                    }
                    liquibase.reportUnexpectedChangeSets(runVerbose, this.contexts, this.getOutputWriter());
                    return;
                }
                if ("validate".equalsIgnoreCase(this.command)) {
                    try {
                        liquibase.validate();
                    }
                    catch (ValidationFailedException e) {
                        e.printDescriptiveError(System.err);
                        try {
                            database.rollback();
                            database.close();
                        }
                        catch (DatabaseException e2) {
                            LogFactory.getInstance().getLog().warning("problem closing connection", e2);
                        }
                        return;
                    }
                    System.err.println("No validation errors found");
                    return;
                }
                if ("clearCheckSums".equalsIgnoreCase(this.command)) {
                    liquibase.clearCheckSums();
                    return;
                }
                if ("calculateCheckSum".equalsIgnoreCase(this.command)) {
                    CheckSum checkSum = null;
                    checkSum = liquibase.calculateCheckSum(this.commandParams.iterator().next());
                    System.out.println(checkSum);
                    return;
                }
                if ("dbdoc".equalsIgnoreCase(this.command)) {
                    if (this.commandParams.size() == 0) {
                        throw new CommandLineParsingException("dbdoc requires an output directory");
                    }
                    if (this.changeLogFile == null) {
                        throw new CommandLineParsingException("dbdoc requires a changeLog parameter");
                    }
                    liquibase.generateDocumentation(this.commandParams.iterator().next(), this.contexts);
                    return;
                }
                try {
                    if ("update".equalsIgnoreCase(this.command)) {
                        liquibase.update(new Contexts(this.contexts), new LabelExpression(this.labels));
                        break block129;
                    }
                    if ("changelogSync".equalsIgnoreCase(this.command)) {
                        liquibase.changeLogSync(new Contexts(this.contexts), new LabelExpression(this.labels));
                        break block129;
                    }
                    if ("changelogSyncSQL".equalsIgnoreCase(this.command)) {
                        liquibase.changeLogSync(new Contexts(this.contexts), new LabelExpression(this.labels), this.getOutputWriter());
                        break block129;
                    }
                    if ("markNextChangeSetRan".equalsIgnoreCase(this.command)) {
                        liquibase.markNextChangeSetRan(new Contexts(this.contexts), new LabelExpression(this.labels));
                        break block129;
                    }
                    if ("markNextChangeSetRanSQL".equalsIgnoreCase(this.command)) {
                        liquibase.markNextChangeSetRan(new Contexts(this.contexts), new LabelExpression(this.labels), this.getOutputWriter());
                        break block129;
                    }
                    if ("updateCount".equalsIgnoreCase(this.command)) {
                        liquibase.update(Integer.parseInt(this.commandParams.iterator().next()), new Contexts(this.contexts), new LabelExpression(this.labels));
                        break block129;
                    }
                    if ("updateCountSQL".equalsIgnoreCase(this.command)) {
                        liquibase.update(Integer.parseInt(this.commandParams.iterator().next()), new Contexts(this.contexts), new LabelExpression(this.labels), this.getOutputWriter());
                        break block129;
                    }
                    if ("updateToTag".equalsIgnoreCase(this.command)) {
                        if (this.commandParams == null || this.commandParams.size() == 0) {
                            throw new CommandLineParsingException("updateToTag requires a tag");
                        }
                        liquibase.update(this.commandParams.iterator().next(), new Contexts(this.contexts), new LabelExpression(this.labels));
                        break block129;
                    }
                    if ("updateToTagSQL".equalsIgnoreCase(this.command)) {
                        if (this.commandParams == null || this.commandParams.size() == 0) {
                            throw new CommandLineParsingException("updateToTagSQL requires a tag");
                        }
                        liquibase.update(this.commandParams.iterator().next(), new Contexts(this.contexts), new LabelExpression(this.labels), this.getOutputWriter());
                        break block129;
                    }
                    if ("updateSQL".equalsIgnoreCase(this.command)) {
                        liquibase.update(new Contexts(this.contexts), new LabelExpression(this.labels), this.getOutputWriter());
                        break block129;
                    }
                    if ("rollback".equalsIgnoreCase(this.command)) {
                        if (this.getCommandArgument() == null) {
                            throw new CommandLineParsingException("rollback requires a rollback tag");
                        }
                        liquibase.rollback(this.getCommandArgument(), this.getCommandParam("rollbackScript", null), new Contexts(this.contexts), new LabelExpression(this.labels));
                        break block129;
                    }
                    if ("rollbackToDate".equalsIgnoreCase(this.command)) {
                        if (this.getCommandArgument() == null) {
                            throw new CommandLineParsingException("rollback requires a rollback date");
                        }
                        liquibase.rollback(new ISODateFormat().parse(this.getCommandArgument()), this.getCommandParam("rollbackScript", null), new Contexts(this.contexts), new LabelExpression(this.labels));
                        break block129;
                    }
                    if ("rollbackCount".equalsIgnoreCase(this.command)) {
                        liquibase.rollback(Integer.parseInt(this.getCommandArgument()), this.getCommandParam("rollbackScript", null), new Contexts(this.contexts), new LabelExpression(this.labels));
                        break block129;
                    }
                    if ("rollbackSQL".equalsIgnoreCase(this.command)) {
                        if (this.getCommandArgument() == null) {
                            throw new CommandLineParsingException("rollbackSQL requires a rollback tag");
                        }
                        liquibase.rollback(this.getCommandArgument(), this.getCommandParam("rollbackScript", null), new Contexts(this.contexts), new LabelExpression(this.labels), this.getOutputWriter());
                        break block129;
                    }
                    if ("rollbackToDateSQL".equalsIgnoreCase(this.command)) {
                        if (this.getCommandArgument() == null) {
                            throw new CommandLineParsingException("rollbackToDateSQL requires a rollback date");
                        }
                        liquibase.rollback(new ISODateFormat().parse(this.getCommandArgument()), this.getCommandParam("rollbackScript", null), new Contexts(this.contexts), new LabelExpression(this.labels), this.getOutputWriter());
                        break block129;
                    }
                    if ("rollbackCountSQL".equalsIgnoreCase(this.command)) {
                        if (this.getCommandArgument() == null) {
                            throw new CommandLineParsingException("rollbackCountSQL requires a rollback count");
                        }
                        liquibase.rollback(Integer.parseInt(this.getCommandArgument()), this.getCommandParam("rollbackScript", null), new Contexts(this.contexts), new LabelExpression(this.labels), this.getOutputWriter());
                        break block129;
                    }
                    if ("futureRollbackSQL".equalsIgnoreCase(this.command)) {
                        liquibase.futureRollbackSQL(new Contexts(this.contexts), new LabelExpression(this.labels), this.getOutputWriter());
                        break block129;
                    }
                    if ("futureRollbackCountSQL".equalsIgnoreCase(this.command)) {
                        if (this.getCommandArgument() == null) {
                            throw new CommandLineParsingException("futureRollbackCountSQL requires a rollback count");
                        }
                        liquibase.futureRollbackSQL((Integer)Integer.parseInt(this.getCommandArgument()), new Contexts(this.contexts), new LabelExpression(this.labels), this.getOutputWriter());
                        break block129;
                    }
                    if ("futureRollbackFromTagSQL".equalsIgnoreCase(this.command)) {
                        if (this.getCommandArgument() == null) {
                            throw new CommandLineParsingException("futureRollbackFromTagSQL requires a tag");
                        }
                        liquibase.futureRollbackSQL(this.getCommandArgument(), new Contexts(this.contexts), new LabelExpression(this.labels), this.getOutputWriter());
                        break block129;
                    }
                    if ("updateTestingRollback".equalsIgnoreCase(this.command)) {
                        liquibase.updateTestingRollback(new Contexts(this.contexts), new LabelExpression(this.labels));
                        break block129;
                    }
                    throw new CommandLineParsingException("Unknown command: " + this.command);
                }
                catch (ParseException e) {
                    throw new CommandLineParsingException("Unexpected date/time format.  Use 'yyyy-MM-dd'T'HH:mm:ss'");
                }
            }
            finally {
                try {
                    database.rollback();
                    database.close();
                }
                catch (DatabaseException e) {
                    LogFactory.getInstance().getLog().warning("problem closing connection", e);
                }
            }
        }
    }

    private String getCommandArgument() {
        for (String param : this.commandParams) {
            if (param.contains("=")) continue;
            return param;
        }
        return null;
    }

    private String getCommandParam(String paramName, String defaultValue) throws CommandLineParsingException {
        for (String param : this.commandParams) {
            if (!param.contains("=")) continue;
            String[] splitArg = this.splitArg(param);
            String attributeName = splitArg[0];
            String value = splitArg[1];
            if (!attributeName.equalsIgnoreCase(paramName)) continue;
            return value;
        }
        return defaultValue;
    }

    private Database createReferenceDatabaseFromCommandParams(Set<String> commandParams, ResourceAccessor resourceAccessor) throws CommandLineParsingException, DatabaseException {
        String driver = this.referenceDriver;
        String url = this.referenceUrl;
        String username = this.referenceUsername;
        String password = this.referencePassword;
        String defaultSchemaName = this.referenceDefaultSchemaName;
        String defaultCatalogName = this.referenceDefaultCatalogName;
        for (String param : commandParams) {
            String[] splitArg = this.splitArg(param);
            String attributeName = splitArg[0];
            String value = splitArg[1];
            if ("referenceDriver".equalsIgnoreCase(attributeName)) {
                driver = value;
                continue;
            }
            if ("referenceUrl".equalsIgnoreCase(attributeName)) {
                url = value;
                continue;
            }
            if ("referenceUsername".equalsIgnoreCase(attributeName)) {
                username = value;
                continue;
            }
            if ("referencePassword".equalsIgnoreCase(attributeName)) {
                password = value;
                continue;
            }
            if ("referenceDefaultCatalogName".equalsIgnoreCase(attributeName)) {
                defaultCatalogName = value;
                continue;
            }
            if ("referenceDefaultSchemaName".equalsIgnoreCase(attributeName)) {
                defaultSchemaName = value;
                continue;
            }
            if (!"dataOutputDirectory".equalsIgnoreCase(attributeName)) continue;
            this.dataOutputDirectory = value;
        }
        if (url == null) {
            throw new CommandLineParsingException("referenceUrl parameter missing");
        }
        return CommandLineUtils.createDatabaseObject(resourceAccessor, url, username, password, driver, defaultCatalogName, defaultSchemaName, Boolean.parseBoolean(this.outputDefaultCatalog), Boolean.parseBoolean(this.outputDefaultSchema), null, null, this.propertyProviderClass, this.liquibaseCatalogName, this.liquibaseSchemaName, this.databaseChangeLogTableName, this.databaseChangeLogLockTableName);
    }

    private Writer getOutputWriter() throws UnsupportedEncodingException, IOException {
        String charsetName = LiquibaseConfiguration.getInstance().getConfiguration(GlobalConfiguration.class).getOutputEncoding();
        if (this.outputFile != null) {
            try {
                FileOutputStream fileOut = new FileOutputStream(this.outputFile, false);
                return new OutputStreamWriter((OutputStream)fileOut, charsetName);
            }
            catch (IOException e) {
                System.err.printf("Could not create output file %s\n", this.outputFile);
                throw e;
            }
        }
        return new OutputStreamWriter((OutputStream)System.out, charsetName);
    }

    public boolean isWindows() {
        return System.getProperty("os.name").startsWith("Windows ");
    }
}

