/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.nio.file.Paths;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.management.MBeanServer;
import org.infinispan.commons.jmx.MBeanServerLookup;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.global.GlobalStatePathConfiguration;
import org.infinispan.configuration.global.ShutdownHookBehavior;
import org.infinispan.configuration.global.ThreadPoolConfiguration;
import org.infinispan.configuration.global.TransportConfiguration;
import org.infinispan.configuration.internal.PrivateGlobalConfigurationBuilder;
import org.infinispan.globalstate.ConfigurationStorage;
import org.jboss.as.clustering.controller.Capability;
import org.jboss.as.clustering.controller.CapabilityServiceNameProvider;
import org.jboss.as.clustering.controller.CommonRequirement;
import org.jboss.as.clustering.controller.ResourceServiceConfigurator;
import org.jboss.as.clustering.infinispan.MBeanServerProvider;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerComponent;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.ScheduledThreadPoolResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.ThreadPoolResourceDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.server.Services;
import org.jboss.dmr.ModelNode;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.infinispan.marshalling.jboss.JBossMarshaller;
import org.wildfly.clustering.service.CompositeDependency;
import org.wildfly.clustering.service.Dependency;
import org.wildfly.clustering.service.FunctionalService;
import org.wildfly.clustering.service.ServiceConfigurator;
import org.wildfly.clustering.service.ServiceSupplierDependency;
import org.wildfly.clustering.service.SupplierDependency;

public class GlobalConfigurationServiceConfigurator
extends CapabilityServiceNameProvider
implements ResourceServiceConfigurator,
Supplier<GlobalConfiguration> {
    private final SupplierDependency<ModuleLoader> loader;
    private final SupplierDependency<Module> module;
    private final SupplierDependency<TransportConfiguration> transport;
    private final Map<ThreadPoolResourceDefinition, SupplierDependency<ThreadPoolConfiguration>> pools = new EnumMap<ThreadPoolResourceDefinition, SupplierDependency<ThreadPoolConfiguration>>(ThreadPoolResourceDefinition.class);
    private final Map<ScheduledThreadPoolResourceDefinition, SupplierDependency<ThreadPoolConfiguration>> schedulers = new EnumMap<ScheduledThreadPoolResourceDefinition, SupplierDependency<ThreadPoolConfiguration>>(ScheduledThreadPoolResourceDefinition.class);
    private final String name;
    private volatile SupplierDependency<MBeanServer> server;
    private volatile String defaultCache;
    private volatile boolean statisticsEnabled;

    GlobalConfigurationServiceConfigurator(PathAddress address) {
        super((Capability)CacheContainerResourceDefinition.Capability.CONFIGURATION, address);
        this.name = address.getLastElement().getValue();
        this.loader = new ServiceSupplierDependency(Services.JBOSS_SERVICE_MODULE_LOADER);
        this.module = new ServiceSupplierDependency(CacheContainerComponent.MODULE.getServiceName(address));
        this.transport = new ServiceSupplierDependency(CacheContainerComponent.TRANSPORT.getServiceName(address));
        for (ThreadPoolResourceDefinition threadPoolResourceDefinition : EnumSet.of(ThreadPoolResourceDefinition.ASYNC_OPERATIONS, ThreadPoolResourceDefinition.LISTENER, ThreadPoolResourceDefinition.PERSISTENCE, ThreadPoolResourceDefinition.REMOTE_COMMAND, ThreadPoolResourceDefinition.TRANSPORT)) {
            this.pools.put(threadPoolResourceDefinition, (SupplierDependency<ThreadPoolConfiguration>)new ServiceSupplierDependency(threadPoolResourceDefinition.getServiceName(address)));
        }
        for (ScheduledThreadPoolResourceDefinition scheduledThreadPoolResourceDefinition : EnumSet.allOf(ScheduledThreadPoolResourceDefinition.class)) {
            this.schedulers.put(scheduledThreadPoolResourceDefinition, (SupplierDependency<ThreadPoolConfiguration>)new ServiceSupplierDependency(scheduledThreadPoolResourceDefinition.getServiceName(address)));
        }
    }

    public ServiceConfigurator configure(OperationContext context, ModelNode model) throws OperationFailedException {
        this.server = context.hasOptionalCapability(CommonRequirement.MBEAN_SERVER.getName(), null, null) ? new ServiceSupplierDependency(CommonRequirement.MBEAN_SERVER.getServiceName(context)) : null;
        this.defaultCache = CacheContainerResourceDefinition.Attribute.DEFAULT_CACHE.resolveModelAttribute((ExpressionResolver)context, model).asStringOrNull();
        this.statisticsEnabled = CacheContainerResourceDefinition.Attribute.STATISTICS_ENABLED.resolveModelAttribute((ExpressionResolver)context, model).asBoolean();
        return this;
    }

    @Override
    public GlobalConfiguration get() {
        GlobalConfigurationBuilder builder = new GlobalConfigurationBuilder();
        builder.cacheManagerName(this.name).cacheContainer().statistics(this.statisticsEnabled);
        if (this.defaultCache != null) {
            builder.defaultCacheName(this.defaultCache);
        }
        builder.transport().read((TransportConfiguration)this.transport.get());
        Module module = (Module)this.module.get();
        builder.serialization().marshaller((Marshaller)new JBossMarshaller((ModuleLoader)this.loader.get(), module));
        builder.classLoader((ClassLoader)module.getClassLoader());
        builder.transport().transportThreadPool().read((ThreadPoolConfiguration)this.pools.get(ThreadPoolResourceDefinition.TRANSPORT).get());
        builder.transport().remoteCommandThreadPool().read((ThreadPoolConfiguration)this.pools.get(ThreadPoolResourceDefinition.REMOTE_COMMAND).get());
        builder.asyncThreadPool().read((ThreadPoolConfiguration)this.pools.get(ThreadPoolResourceDefinition.ASYNC_OPERATIONS).get());
        builder.expirationThreadPool().read((ThreadPoolConfiguration)this.schedulers.get(ScheduledThreadPoolResourceDefinition.EXPIRATION).get());
        builder.listenerThreadPool().read((ThreadPoolConfiguration)this.pools.get(ThreadPoolResourceDefinition.LISTENER).get());
        builder.persistenceThreadPool().read((ThreadPoolConfiguration)this.pools.get(ThreadPoolResourceDefinition.PERSISTENCE).get());
        builder.shutdown().hookBehavior(ShutdownHookBehavior.DONT_REGISTER);
        builder.metrics().gauges(false).histograms(false);
        builder.jmx().domain("org.wildfly.clustering.infinispan").mBeanServerLookup((MBeanServerLookup)new MBeanServerProvider(this.server != null && this.statisticsEnabled ? (MBeanServer)this.server.get() : null));
        ((PrivateGlobalConfigurationBuilder)builder.addModule(PrivateGlobalConfigurationBuilder.class)).serverMode(true);
        builder.globalState().configurationStorage(ConfigurationStorage.IMMUTABLE).disable();
        builder.globalState().persistentLocation(Paths.get((String)GlobalStatePathConfiguration.PATH.getDefaultValue(), new String[0]).getRoot().toString());
        return builder.build();
    }

    public ServiceBuilder<?> build(ServiceTarget target) {
        ServiceBuilder builder = target.addService(this.getServiceName());
        Consumer global = new CompositeDependency(new Dependency[]{this.loader, this.module, this.transport, this.server}).register(builder).provides(new ServiceName[]{this.getServiceName()});
        for (Dependency dependency : this.pools.values()) {
            dependency.register(builder);
        }
        for (Dependency dependency : this.schedulers.values()) {
            dependency.register(builder);
        }
        FunctionalService service = new FunctionalService(global, Function.identity(), (Supplier)this);
        return builder.setInstance((Service)service).setInitialMode(ServiceController.Mode.PASSIVE);
    }
}

