/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.stack;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.function.Supplier;
import org.jgroups.Address;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.NameCache;
import org.jgroups.util.UUID;

public class IpAddressUUID
extends IpAddress {
    protected long low;
    protected int high;

    public IpAddressUUID() {
    }

    public IpAddressUUID(String addr_port) throws Exception {
        super(addr_port);
        long[] tmp = IpAddressUUID.createUUID();
        this.low = tmp[0];
        this.high = (int)tmp[1];
    }

    public IpAddressUUID(InetAddress i, int p) {
        super(i, p);
        long[] tmp = IpAddressUUID.createUUID();
        this.low = tmp[0];
        this.high = (int)tmp[1];
    }

    public IpAddressUUID(String i, int p) throws UnknownHostException {
        super(i, p);
        long[] tmp = IpAddressUUID.createUUID();
        this.low = tmp[0];
        this.high = (int)tmp[1];
    }

    public IpAddressUUID(int port) {
        super(port);
        long[] tmp = IpAddressUUID.createUUID();
        this.low = tmp[0];
        this.high = (int)tmp[1];
    }

    public IpAddressUUID(int port, boolean set_default_host) {
        super(port, set_default_host);
        long[] tmp = IpAddressUUID.createUUID();
        this.low = tmp[0];
        this.high = (int)tmp[1];
    }

    public IpAddressUUID(InetSocketAddress sock_addr) {
        super(sock_addr);
        long[] tmp = IpAddressUUID.createUUID();
        this.low = tmp[0];
        this.high = (int)tmp[1];
    }

    protected IpAddressUUID(InetAddress i, int p, long low, int high) {
        this.ip_addr = i;
        this.port = p;
        this.low = low;
        this.high = high;
    }

    @Override
    public int compareTo(Address o) {
        if (this == o) {
            return 0;
        }
        int retval = super.compareTo(o);
        if (retval != 0) {
            return retval;
        }
        if (o instanceof IpAddressUUID) {
            IpAddressUUID other = (IpAddressUUID)o;
            int n = this.low < other.low ? -1 : (retval = this.low > other.low ? 1 : 0);
            if (retval != 0) {
                return retval;
            }
            return this.high < other.high ? -1 : (this.high > other.high ? 1 : 0);
        }
        return retval;
    }

    @Override
    public IpAddress copy() {
        return new IpAddressUUID(this.ip_addr, this.port, this.low, this.high);
    }

    @Override
    public Supplier<? extends IpAddress> create() {
        return IpAddressUUID::new;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        boolean retval = super.equals(obj);
        if (!retval) {
            return retval;
        }
        if (obj instanceof IpAddressUUID) {
            IpAddressUUID other = (IpAddressUUID)obj;
            return this == other || this.low == other.low && this.high == other.high;
        }
        return retval;
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        super.writeTo(out);
        out.writeLong(this.low);
        out.writeInt(this.high);
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        super.readFrom(in);
        this.low = in.readLong();
        this.high = in.readInt();
    }

    @Override
    public int serializedSize() {
        return super.serializedSize() + 8 + 4;
    }

    @Override
    public String toString() {
        String logical_name = NameCache.get(this);
        return logical_name != null ? logical_name : super.toString();
    }

    public String toString(boolean detailed) {
        String logical_name = NameCache.get(this);
        if (logical_name != null) {
            return detailed ? String.format("%s (%s)", logical_name, super.toString()) : logical_name;
        }
        return super.toString();
    }

    protected static long[] createUUID() {
        int i;
        byte[] data = UUID.generateRandomBytes(12);
        long msb = 0L;
        int lsb = 0;
        for (i = 0; i < 8; ++i) {
            msb = msb << 8 | (long)(data[i] & 0xFF);
        }
        for (i = 8; i < 12; ++i) {
            lsb = lsb << 8 | data[i] & 0xFF;
        }
        return new long[]{msb, lsb};
    }
}

