/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth.message.config;

import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.SecurityPermission;
import java.util.Map;
import javax.security.auth.message.config.AuthConfigProvider;
import javax.security.auth.message.config.RegistrationListener;

public abstract class AuthConfigFactory {
    private static AuthConfigFactory factory = null;
    public static final String DEFAULT_FACTORY_SECURITY_PROPERTY = "authconfigprovider.factory";
    private static final String PROVIDER_SECURITY_PROPERTY = "authconfigfactory.provider";
    public static final String GET_FACTORY_PERMISSION_NAME = "getProperty.authconfigprovider.factory";
    public static final String SET_FACTORY_PERMISSION_NAME = "setProperty.authconfigprovider.factory";
    public static final String PROVIDER_REGISTRATION_PERMISSION_NAME = "setProperty.authconfigfactory.provider";
    public static final SecurityPermission getFactorySecurityPermission = new SecurityPermission("getProperty.authconfigprovider.factory");
    public static final SecurityPermission setFactorySecurityPermission = new SecurityPermission("setProperty.authconfigprovider.factory");
    private static final String FACTORY_IMPL = "org.jboss.security.auth.message.config.JBossAuthConfigFactory";
    public static final SecurityPermission providerRegistrationSecurityPermission = new SecurityPermission("setProperty.authconfigfactory.provider");

    private static void checkPermission(Permission permission) throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(permission);
        }
    }

    public static synchronized AuthConfigFactory getFactory() {
        AuthConfigFactory.checkPermission(getFactorySecurityPermission);
        if (factory == null) {
            AuthConfigFactory.checkPermission(setFactorySecurityPermission);
            String factoryName = null;
            Class clazz = null;
            try {
                LoadAction action = new LoadAction();
                try {
                    clazz = (Class)AccessController.doPrivileged(action);
                    factoryName = action.getName();
                }
                catch (PrivilegedActionException ex) {
                    factoryName = action.getName();
                    Exception e = ex.getException();
                    if (e instanceof ClassNotFoundException) {
                        throw (ClassNotFoundException)e;
                    }
                    throw new IllegalStateException("Failure during load of class: " + action.getName() + e);
                }
                factory = (AuthConfigFactory)clazz.newInstance();
            }
            catch (ClassNotFoundException e) {
                String msg = "Failed to find AuthConfigFactory : " + factoryName;
                IllegalStateException ise = new IllegalStateException(msg);
                ise.initCause(e);
                throw ise;
            }
            catch (IllegalAccessException e) {
                String msg = "Unable to access class : " + factoryName;
                IllegalStateException ise = new IllegalStateException(msg);
                ise.initCause(e);
                throw ise;
            }
            catch (InstantiationException e) {
                String msg = "Failed to create instance of: " + factoryName;
                IllegalStateException ise = new IllegalStateException(msg);
                ise.initCause(e);
                throw ise;
            }
            catch (ClassCastException e) {
                StringBuffer msg = new StringBuffer(factoryName + " Is not a AuthConfigFactory, ");
                msg.append("ACF.class.CL: " + AuthConfigFactory.class.getClassLoader());
                msg.append("\nACF.class.CS: " + AuthConfigFactory.class.getProtectionDomain().getCodeSource());
                msg.append("\nACF.class.hash: " + System.identityHashCode(AuthConfigFactory.class));
                msg.append("\nclazz.CL: " + clazz.getClassLoader());
                msg.append("\nclazz.CS: " + clazz.getProtectionDomain().getCodeSource());
                msg.append("\nclazz.super.CL: " + clazz.getSuperclass().getClassLoader());
                msg.append("\nclazz.super.CS: " + clazz.getSuperclass().getProtectionDomain().getCodeSource());
                msg.append("\nclazz.super.hash: " + System.identityHashCode(clazz.getSuperclass()));
                ClassCastException cce = new ClassCastException(msg.toString());
                cce.initCause(e);
                throw cce;
            }
        }
        return factory;
    }

    public static synchronized void setFactory(AuthConfigFactory factory) {
        AuthConfigFactory.checkPermission(setFactorySecurityPermission);
        AuthConfigFactory.factory = factory;
    }

    public abstract AuthConfigProvider getConfigProvider(String var1, String var2, RegistrationListener var3);

    public abstract String registerConfigProvider(String var1, Map var2, String var3, String var4, String var5);

    public abstract String registerConfigProvider(AuthConfigProvider var1, String var2, String var3, String var4);

    public abstract boolean removeRegistration(String var1);

    public abstract String[] detachListener(RegistrationListener var1, String var2, String var3);

    public abstract String[] getRegistrationIDs(AuthConfigProvider var1);

    public abstract RegistrationContext getRegistrationContext(String var1);

    public abstract void refresh();

    private static class LoadAction
    implements PrivilegedExceptionAction {
        private String className;

        private LoadAction() {
        }

        public String getName() {
            return this.className;
        }

        public Object run() throws Exception {
            this.className = System.getProperty(AuthConfigFactory.DEFAULT_FACTORY_SECURITY_PROPERTY);
            if (this.className == null) {
                this.className = AuthConfigFactory.FACTORY_IMPL;
            }
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> factoryClass = loader.loadClass(this.className);
            return factoryClass;
        }
    }

    public static interface RegistrationContext {
        public String getMessageLayer();

        public String getAppContext();

        public String getDescription();

        public boolean isPersistent();
    }
}

