/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.core.jar.runtime;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;
import org.jboss.logmanager.LogContext;
import org.jboss.logmanager.PropertyConfigurator;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleLoader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wildfly.core.jar.runtime.Arguments;
import org.wildfly.core.jar.runtime.CmdUsage;
import org.wildfly.core.jar.runtime.Server;
import org.wildfly.core.jar.runtime._private.BootableJarLogger;

public final class BootableJar
implements Server.ShutdownHandler {
    private static final String DEP_1 = "ff";
    private static final String DEP_2 = "00";
    private BootableJarLogger log;
    private final Path jbossHome;
    private final List<String> startServerArgs = new ArrayList<String>();
    private Server server;
    private final Arguments arguments;
    private final ModuleLoader loader;

    private BootableJar(Path jbossHome, Arguments arguments, ModuleLoader loader, long unzipTime) throws Exception {
        this.jbossHome = jbossHome;
        this.arguments = arguments;
        this.loader = loader;
        this.startServerArgs.addAll(arguments.getServerArguments());
        this.startServerArgs.add("--read-only-server-config=standalone.xml");
        this.configureLogger();
        long t = System.currentTimeMillis();
        if (arguments.getDeployment() != null) {
            this.setupDeployment(arguments.getDeployment());
        }
        this.log.advertiseInstall(jbossHome, unzipTime + (System.currentTimeMillis() - t));
    }

    @Override
    public void shutdown(int status) {
        if (status == 10) {
            this.log.cantRestartServer();
        }
        System.exit(status);
    }

    private void setupDeployment(Path deployment) throws Exception {
        Path deploymentDir = this.jbossHome.resolve("standalone").resolve("data").resolve("content").resolve(DEP_1).resolve(DEP_2);
        Path target = deploymentDir.resolve("content");
        Files.createDirectories(deploymentDir, new FileAttribute[0]);
        boolean isExploded = Files.isDirectory(deployment, new LinkOption[0]);
        BootableJar.updateConfig(this.jbossHome.resolve("standalone").resolve("configuration").resolve("standalone.xml"), deployment.getFileName().toString(), isExploded);
        if (isExploded) {
            this.copyDirectory(deployment, target);
        } else {
            Files.copy(deployment, target, new CopyOption[0]);
        }
        this.log.installDeployment(deployment);
    }

    private static void updateConfig(Path configFile, String name, boolean isExploded) throws Exception {
        FileInputStream fileInputStream = new FileInputStream(configFile.toFile());
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(fileInputStream);
        Element root = document.getDocumentElement();
        NodeList lst = root.getChildNodes();
        for (int i = 0; i < lst.getLength(); ++i) {
            Node n = lst.item(i);
            if (!(n instanceof Element) || !"deployments".equals(n.getNodeName())) continue;
            throw BootableJarLogger.ROOT_LOGGER.deploymentAlreadyExist();
        }
        Element deployments = document.createElement("deployments");
        Element deployment = document.createElement("deployment");
        Element content = document.createElement("content");
        content.setAttribute("sha1", "ff00");
        if (isExploded) {
            content.setAttribute("archive", "false");
        }
        deployment.appendChild(content);
        deployment.setAttribute("name", name);
        deployment.setAttribute("runtime-name", name);
        deployments.appendChild(deployment);
        root.appendChild(deployments);
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        StreamResult output = new StreamResult(configFile.toFile());
        DOMSource input = new DOMSource(document);
        transformer.transform(input, output);
    }

    private void copyDirectory(Path src, Path target) throws IOException {
        Files.walk(src, new FileVisitOption[0]).forEach(file -> {
            try {
                Path targetFile = target.resolve(src.relativize((Path)file));
                if (Files.isDirectory(file, new LinkOption[0])) {
                    if (!Files.exists(targetFile, new LinkOption[0])) {
                        Files.createDirectory(targetFile, new FileAttribute[0]);
                    }
                } else {
                    Files.copy(file, targetFile, new CopyOption[0]);
                }
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        });
    }

    private void configureLogger() throws IOException {
        System.setProperty("java.util.logging.manager", "org.jboss.logmanager.LogManager");
        this.configureLogging();
        this.log = BootableJarLogger.ROOT_LOGGER;
    }

    private void configureLogging() throws IOException {
        if (!this.arguments.isVersion().booleanValue()) {
            LogContext ctx = this.configureLogContext();
            LogContext.setLogContextSelector(() -> ctx);
        }
    }

    private LogContext configureLogContext() throws IOException {
        Path baseDir = this.jbossHome.resolve("standalone");
        String serverLogDir = System.getProperty("jboss.server.log.dir", null);
        if (serverLogDir == null) {
            serverLogDir = baseDir.resolve("log").toString();
            System.setProperty("jboss.server.log.dir", serverLogDir);
        }
        String serverCfgDir = System.getProperty("jboss.server.config.dir", baseDir.resolve("configuration").toString());
        LogContext embeddedLogContext = LogContext.create();
        Path bootLog = Paths.get(serverLogDir, new String[0]).resolve("server.log");
        Path loggingProperties = Paths.get(serverCfgDir, new String[0]).resolve(Paths.get("logging.properties", new String[0]));
        if (Files.exists(loggingProperties, new LinkOption[0])) {
            try (InputStream in = Files.newInputStream(loggingProperties, new OpenOption[0]);){
                System.setProperty("org.jboss.boot.log.file", bootLog.toAbsolutePath().toString());
                PropertyConfigurator configurator = new PropertyConfigurator(embeddedLogContext);
                configurator.configure(in);
            }
        }
        return embeddedLogContext;
    }

    public void run() throws Exception {
        try {
            this.server = this.buildServer(this.startServerArgs);
        }
        catch (RuntimeException ex) {
            this.cleanup();
            throw ex;
        }
        Runtime.getRuntime().addShutdownHook(new ShutdownHook());
        this.server.start();
    }

    private void cleanup() {
        this.log.deletingHome(this.jbossHome);
        this.deleteDir(this.jbossHome);
    }

    private Server buildServer(List<String> args) throws IOException {
        String[] array = new String[args.size()];
        this.log.advertiseOptions(args);
        return Server.newSever(this.jbossHome, args.toArray(array), this.loader, this);
    }

    private void deleteDir(Path root) {
        if (root == null || !Files.exists(root, new LinkOption[0])) {
            return;
        }
        try {
            Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    try {
                        Files.delete(file);
                    }
                    catch (IOException ex) {
                        BootableJar.this.log.cantDelete(file.toString(), ex);
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException e) throws IOException {
                    try {
                        Files.delete(dir);
                    }
                    catch (IOException ex) {
                        BootableJar.this.log.cantDelete(dir.toString(), ex);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void waitAndClean() {
        try {
            ModelNode mn = new ModelNode();
            mn.get("address");
            mn.get("operation").set("read-attribute");
            mn.get("name").set("server-state");
            int i = 0;
            while (i < 10) {
                try {
                    ModelControllerClient client = this.server.getModelControllerClient();
                    if (client == null) {
                        this.log.nullController();
                        return;
                    }
                    ModelNode ret = client.execute(mn);
                    if (ret.hasDefined("result")) {
                        String val = ret.get("result").asString();
                        if ("stopped".equals(val)) {
                            this.log.serverStopped();
                            return;
                        }
                        this.log.serverNotStopped();
                    }
                    Thread.sleep(1000L);
                }
                catch (Exception ex) {
                    this.log.unexpectedExceptionWhileShuttingDown(ex);
                }
                ++i;
            }
            return;
        }
        finally {
            this.cleanup();
        }
    }

    public static void run(Path jbossHome, List<String> args, ModuleLoader moduleLoader, ModuleClassLoader moduleClassLoader, Long unzipTime) throws Exception {
        Arguments arguments;
        BootableJar.setTccl((ClassLoader)moduleClassLoader);
        try {
            arguments = Arguments.parseArguments(args);
        }
        catch (Throwable ex) {
            System.err.println(ex);
            CmdUsage.printUsage(System.out);
            return;
        }
        if (arguments.isHelp().booleanValue()) {
            CmdUsage.printUsage(System.out);
            return;
        }
        BootableJar bootableJar = new BootableJar(jbossHome, arguments, moduleLoader, unzipTime);
        bootableJar.run();
    }

    static void setTccl(ClassLoader cl) {
        Thread.currentThread().setContextClassLoader(cl);
    }

    private class ShutdownHook
    extends Thread {
        private ShutdownHook() {
        }

        @Override
        public void run() {
            BootableJar.this.log.shuttingDown();
            BootableJar.this.waitAndClean();
        }
    }
}

