/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.support;

import java.util.Collection;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.function.Predicate;
import javax.transaction.Transaction;
import org.infinispan.commons.api.Lifecycle;
import org.infinispan.commons.util.IntSet;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.persistence.spi.MarshallableEntry;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.persistence.support.BatchModification;
import org.reactivestreams.Publisher;

@Scope(value=Scopes.NAMED_CACHE)
public class DelegatingPersistenceManager
implements PersistenceManager,
Lifecycle {
    protected final PersistenceManager persistenceManager;
    @Inject
    protected ComponentRegistry componentRegistry;

    public DelegatingPersistenceManager(PersistenceManager persistenceManager) {
        this.persistenceManager = persistenceManager;
    }

    @Start
    public void start() {
        this.componentRegistry.wireDependencies(this.persistenceManager);
        this.persistenceManager.start();
    }

    @Stop
    public void stop() {
        this.persistenceManager.stop();
    }

    public PersistenceManager getActual() {
        return this.persistenceManager;
    }

    @Override
    public boolean isEnabled() {
        return this.persistenceManager.isEnabled();
    }

    @Override
    public boolean hasWriter() {
        return this.persistenceManager.hasWriter();
    }

    @Override
    public boolean isPreloaded() {
        return this.persistenceManager.isPreloaded();
    }

    @Override
    public CompletionStage<Void> preload() {
        return this.persistenceManager.preload();
    }

    @Override
    public void disableStore(String storeType) {
        this.persistenceManager.disableStore(storeType);
    }

    @Override
    public <T> Set<T> getStores(Class<T> storeClass) {
        return this.persistenceManager.getStores(storeClass);
    }

    @Override
    public Collection<String> getStoresAsString() {
        return this.persistenceManager.getStoresAsString();
    }

    @Override
    public void purgeExpired() {
        this.persistenceManager.purgeExpired();
    }

    @Override
    public CompletionStage<Void> clearAllStores(Predicate<? super StoreConfiguration> predicate) {
        return this.persistenceManager.clearAllStores(predicate);
    }

    @Override
    public boolean deleteFromAllStoresSync(Object key, int segment, Predicate<? super StoreConfiguration> predicate) {
        return this.persistenceManager.deleteFromAllStoresSync(key, segment, predicate);
    }

    @Override
    public CompletionStage<Boolean> deleteFromAllStores(Object key, int segment, Predicate<? super StoreConfiguration> predicate) {
        return this.persistenceManager.deleteFromAllStores(key, segment, predicate);
    }

    @Override
    public <K, V> Publisher<MarshallableEntry<K, V>> publishEntries(Predicate<? super K> filter, boolean fetchValue, boolean fetchMetadata, Predicate<? super StoreConfiguration> predicate) {
        return this.persistenceManager.publishEntries(filter, fetchValue, fetchMetadata, predicate);
    }

    @Override
    public <K, V> Publisher<MarshallableEntry<K, V>> publishEntries(IntSet segments, Predicate<? super K> filter, boolean fetchValue, boolean fetchMetadata, Predicate<? super StoreConfiguration> predicate) {
        return this.persistenceManager.publishEntries(segments, filter, fetchValue, fetchMetadata, predicate);
    }

    @Override
    public <K> Publisher<K> publishKeys(Predicate<? super K> filter, Predicate<? super StoreConfiguration> predicate) {
        return this.persistenceManager.publishKeys(filter, predicate);
    }

    @Override
    public <K> Publisher<K> publishKeys(IntSet segments, Predicate<? super K> filter, Predicate<? super StoreConfiguration> predicate) {
        return this.persistenceManager.publishKeys(segments, filter, predicate);
    }

    @Override
    public <K, V> CompletionStage<MarshallableEntry<K, V>> loadFromAllStores(Object key, boolean localInvocation, boolean includeStores) {
        return this.persistenceManager.loadFromAllStores(key, localInvocation, includeStores);
    }

    @Override
    public CompletionStage<Integer> size(Predicate<? super StoreConfiguration> predicate) {
        return this.persistenceManager.size(predicate);
    }

    @Override
    public CompletionStage<Integer> size(IntSet segments) {
        return this.persistenceManager.size(segments);
    }

    @Override
    public void setClearOnStop(boolean clearOnStop) {
        this.persistenceManager.setClearOnStop(clearOnStop);
    }

    @Override
    public void writeToAllNonTxStoresSync(MarshallableEntry marshalledEntry, int segment, Predicate<? super StoreConfiguration> predicate) {
        this.persistenceManager.writeToAllNonTxStoresSync(marshalledEntry, segment, predicate);
    }

    @Override
    public CompletionStage<Void> writeToAllNonTxStores(MarshallableEntry marshalledEntry, int segment, Predicate<? super StoreConfiguration> predicate, long flags) {
        return this.persistenceManager.writeToAllNonTxStores(marshalledEntry, segment, predicate, flags);
    }

    @Override
    public CompletionStage<Void> prepareAllTxStores(Transaction transaction, BatchModification batchModification, Predicate<? super StoreConfiguration> predicate) throws PersistenceException {
        return this.persistenceManager.prepareAllTxStores(transaction, batchModification, predicate);
    }

    @Override
    public CompletionStage<Void> commitAllTxStores(Transaction transaction, Predicate<? super StoreConfiguration> predicate) {
        return this.persistenceManager.commitAllTxStores(transaction, predicate);
    }

    @Override
    public CompletionStage<Void> rollbackAllTxStores(Transaction transaction, Predicate<? super StoreConfiguration> predicate) {
        return this.persistenceManager.rollbackAllTxStores(transaction, predicate);
    }

    @Override
    public CompletionStage<Void> writeBatchToAllNonTxStores(Iterable<MarshallableEntry> entries, Predicate<? super StoreConfiguration> predicate, long flags) {
        return this.persistenceManager.writeBatchToAllNonTxStores(entries, predicate, flags);
    }

    @Override
    public CompletionStage<Void> deleteBatchFromAllNonTxStores(Iterable<Object> keys, Predicate<? super StoreConfiguration> predicate, long flags) {
        return this.persistenceManager.deleteBatchFromAllNonTxStores(keys, predicate, flags);
    }

    @Override
    public boolean isAvailable() {
        return this.persistenceManager.isAvailable();
    }

    @Override
    public boolean isReadOnly() {
        return this.persistenceManager.isReadOnly();
    }

    @Override
    public <K, V> Publisher<MarshallableEntry<K, V>> publishEntries(boolean fetchValue, boolean fetchMetadata) {
        return this.persistenceManager.publishEntries(fetchValue, fetchMetadata);
    }

    @Override
    public <K, V> MarshallableEntry<K, V> loadFromAllStoresSync(Object key, boolean localInvocation, boolean includeStores) {
        return this.persistenceManager.loadFromAllStoresSync(key, localInvocation, includeStores);
    }

    @Override
    public <K, V> CompletionStage<MarshallableEntry<K, V>> loadFromAllStores(Object key, int segment, boolean localInvocation, boolean includeStores) {
        return this.persistenceManager.loadFromAllStores(key, segment, localInvocation, includeStores);
    }

    @Override
    public <K, V> MarshallableEntry<K, V> loadFromAllStoresSync(Object key, int segment, boolean localInvocation, boolean includeStores) {
        return this.persistenceManager.loadFromAllStoresSync(key, segment, localInvocation, includeStores);
    }

    @Override
    public CompletionStage<Integer> size() {
        return this.persistenceManager.size();
    }

    @Override
    public CompletionStage<Void> writeToAllNonTxStores(MarshallableEntry marshalledEntry, int segment, Predicate<? super StoreConfiguration> predicate) {
        return this.persistenceManager.writeToAllNonTxStores(marshalledEntry, segment, predicate);
    }

    @Override
    public CompletionStage<Boolean> addSegments(IntSet segments) {
        return this.persistenceManager.addSegments(segments);
    }

    @Override
    public CompletionStage<Boolean> removeSegments(IntSet segments) {
        return this.persistenceManager.removeSegments(segments);
    }
}

