/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stream.impl;

import io.reactivex.Flowable;
import io.reactivex.schedulers.Schedulers;
import java.lang.invoke.MethodHandles;
import java.util.PrimitiveIterator;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.infinispan.commons.util.IntSet;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.remoting.transport.Address;
import org.infinispan.stream.impl.AbstractCacheStream;
import org.infinispan.stream.impl.AbstractRehashPublisherDecorator;
import org.infinispan.stream.impl.ClusterStreamManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.reactivestreams.Publisher;

class RehashPublisherDecorator<S>
extends AbstractRehashPublisherDecorator<S> {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    final Consumer<? super Supplier<PrimitiveIterator.OfInt>> completedSegments;
    final Executor executor;
    final Function<S, ?> toKeyFunction;

    RehashPublisherDecorator(AbstractCacheStream.IteratorOperation iteratorOperation, DistributionManager dm, Address localAddress, Consumer<? super Supplier<PrimitiveIterator.OfInt>> completedSegments, Consumer<? super Supplier<PrimitiveIterator.OfInt>> lostSegments, Executor executor, Consumer<Object> keyConsumer, Function<S, ?> toKeyFunction) {
        super(iteratorOperation, dm, localAddress, lostSegments, keyConsumer, toKeyFunction);
        this.completedSegments = completedSegments;
        this.executor = executor;
        this.toKeyFunction = toKeyFunction;
    }

    @Override
    Log getLog() {
        return log;
    }

    Publisher<S> applySubscribeExecutor(Publisher<S> publisher) {
        return Flowable.fromPublisher(publisher).subscribeOn(Schedulers.from((Executor)this.executor));
    }

    @Override
    public Publisher<S> decorateRemote(ClusterStreamManager.RemoteIteratorPublisher<S> remotePublisher) {
        Publisher convertedPublisher = s -> remotePublisher.subscribe(s, this.completedSegments, this.lostSegments);
        return this.iteratorOperation.handlePublisher(this.applySubscribeExecutor(convertedPublisher), this.keyConsumer, this.toKeyFunction);
    }

    @Override
    public Publisher<S> decorateLocal(ConsistentHash beginningCh, boolean onlyLocal, IntSet segmentsToFilter, Publisher<S> localPublisher) {
        return this.decorateLocal(this.completedSegments, beginningCh, onlyLocal, segmentsToFilter, localPublisher);
    }
}

