/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stream.impl.tx;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import org.infinispan.commons.util.AbstractDelegatingMap;
import org.infinispan.commons.util.IntSet;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.LocalTxInvocationContext;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.remoting.transport.Address;
import org.infinispan.stream.impl.ClusterStreamManager;
import org.infinispan.stream.impl.KeyTrackingTerminalOperation;
import org.infinispan.stream.impl.TerminalOperation;
import org.infinispan.stream.impl.intops.IntermediateOperation;

public class TxClusterStreamManager<Original, K>
implements ClusterStreamManager<Original, K> {
    private final ClusterStreamManager<Original, K> manager;
    private final LocalTxInvocationContext ctx;
    private final int maxSegments;
    private final ToIntFunction<Object> intFunction;

    public TxClusterStreamManager(ClusterStreamManager<Original, K> manager, LocalTxInvocationContext ctx, int maxSegments, ToIntFunction<Object> intFunction) {
        this.manager = manager;
        this.ctx = ctx;
        this.maxSegments = maxSegments;
        this.intFunction = intFunction;
    }

    @Override
    public <R> Object remoteStreamOperation(boolean parallelDistribution, boolean parallelStream, ConsistentHash ch, IntSet segments, Set<K> keysToInclude, Map<Integer, Set<K>> keysToExclude, boolean includeLoader, boolean entryStream, TerminalOperation<Original, R> operation, ClusterStreamManager.ResultsCallback<R> callback, Predicate<? super R> earlyTerminatePredicate) {
        TxExcludedKeys txExcludedKeys = new TxExcludedKeys(keysToExclude, this.ctx, this.intFunction);
        return this.manager.remoteStreamOperation(parallelDistribution, parallelStream, ch, segments, keysToInclude, (Map<Integer, Set<K>>)((Object)txExcludedKeys), includeLoader, entryStream, operation, callback, earlyTerminatePredicate);
    }

    @Override
    public <R> Object remoteStreamOperationRehashAware(boolean parallelDistribution, boolean parallelStream, ConsistentHash ch, IntSet segments, Set<K> keysToInclude, Map<Integer, Set<K>> keysToExclude, boolean includeLoader, boolean entryStream, TerminalOperation<Original, R> operation, ClusterStreamManager.ResultsCallback<R> callback, Predicate<? super R> earlyTerminatePredicate) {
        TxExcludedKeys txExcludedKeys = new TxExcludedKeys(keysToExclude, this.ctx, this.intFunction);
        return this.manager.remoteStreamOperationRehashAware(parallelDistribution, parallelStream, ch, segments, keysToInclude, (Map<Integer, Set<K>>)((Object)txExcludedKeys), includeLoader, entryStream, operation, callback, earlyTerminatePredicate);
    }

    @Override
    public <R> Object remoteStreamOperation(boolean parallelDistribution, boolean parallelStream, ConsistentHash ch, IntSet segments, Set<K> keysToInclude, Map<Integer, Set<K>> keysToExclude, boolean includeLoader, boolean entryStream, KeyTrackingTerminalOperation<Original, K, R> operation, ClusterStreamManager.ResultsCallback<Collection<R>> callback) {
        TxExcludedKeys txExcludedKeys = new TxExcludedKeys(keysToExclude, this.ctx, this.intFunction);
        return this.manager.remoteStreamOperation(parallelDistribution, parallelStream, ch, segments, keysToInclude, (Map<Integer, Set<K>>)((Object)txExcludedKeys), includeLoader, entryStream, operation, callback);
    }

    @Override
    public Object remoteStreamOperationRehashAware(boolean parallelDistribution, boolean parallelStream, ConsistentHash ch, IntSet segments, Set<K> keysToInclude, Map<Integer, Set<K>> keysToExclude, boolean includeLoader, boolean entryStream, KeyTrackingTerminalOperation<Original, K, ?> operation, ClusterStreamManager.ResultsCallback<Collection<K>> callback) {
        TxExcludedKeys txExcludedKeys = new TxExcludedKeys(keysToExclude, this.ctx, this.intFunction);
        return this.manager.remoteStreamOperationRehashAware(parallelDistribution, parallelStream, ch, segments, keysToInclude, (Map<Integer, Set<K>>)((Object)txExcludedKeys), includeLoader, entryStream, operation, callback);
    }

    @Override
    public boolean isComplete(Object id) {
        return this.manager.isComplete(id);
    }

    @Override
    public boolean awaitCompletion(Object id, long time, TimeUnit unit) throws InterruptedException {
        return this.manager.awaitCompletion(id, time, unit);
    }

    @Override
    public void forgetOperation(Object id) {
        this.manager.forgetOperation(id);
    }

    @Override
    public <R1> boolean receiveResponse(Object id, Address origin, boolean complete, IntSet segments, R1 response) {
        return this.manager.receiveResponse(id, origin, complete, segments, response);
    }

    @Override
    public <E> ClusterStreamManager.RemoteIteratorPublisher<E> remoteIterationPublisher(boolean parallelStream, Supplier<Map.Entry<Address, IntSet>> segments, Set<K> keysToInclude, IntFunction<Set<K>> keysToExclude, boolean includeLoader, boolean entryStream, Iterable<IntermediateOperation> intermediateOperations) {
        if (this.ctx.lookedUpEntriesCount() == 0) {
            return this.manager.remoteIterationPublisher(parallelStream, segments, keysToInclude, keysToExclude, includeLoader, entryStream, intermediateOperations);
        }
        Set[] contextSet = this.generateContextSet(this.ctx);
        if (keysToExclude == null) {
            return this.manager.remoteIterationPublisher(parallelStream, segments, keysToInclude, i -> contextSet[i], includeLoader, entryStream, intermediateOperations);
        }
        return this.manager.remoteIterationPublisher(parallelStream, segments, keysToInclude, i -> {
            Set set = contextSet[i];
            if (set != null) {
                set.addAll((Collection)keysToExclude.apply(i));
                return set;
            }
            return (Set)keysToExclude.apply(i);
        }, includeLoader, entryStream, intermediateOperations);
    }

    Set<K>[] generateContextSet(LocalTxInvocationContext ctx) {
        Set[] set = new Set[this.maxSegments];
        ctx.forEachEntry((k, entry) -> {
            int segment = this.intFunction.applyAsInt(k);
            HashSet<Object> innerSet = set[segment];
            if (innerSet == null) {
                set[segment] = innerSet = new HashSet<Object>();
            }
            innerSet.add(k);
        });
        return set;
    }

    @Override
    public InvocationContext getContext() {
        return this.ctx;
    }

    private static class TxExcludedKeys<K>
    extends AbstractDelegatingMap<Integer, Set<K>> {
        private final Map<Integer, Set<K>> map;
        private final Map<Integer, Set<K>> ctxMap;

        private TxExcludedKeys(Map<Integer, Set<K>> map, LocalTxInvocationContext ctx, ToIntFunction<Object> intFunction) {
            this.map = map;
            this.ctxMap = this.contextToMap(ctx, intFunction);
        }

        Map<Integer, Set<K>> contextToMap(LocalTxInvocationContext ctx, ToIntFunction<Object> intFunction) {
            HashMap contextMap = new HashMap();
            ctx.forEachEntry((key, entry) -> {
                Integer segment = intFunction.applyAsInt(key);
                Set innerSet = contextMap.computeIfAbsent(segment, k -> new HashSet());
                innerSet.add(key);
            });
            return contextMap;
        }

        protected Map<Integer, Set<K>> delegate() {
            return this.map;
        }

        public Set<K> get(Object key) {
            if (!(key instanceof Integer)) {
                return null;
            }
            Set<K> ctxSet = this.ctxMap.get(key);
            Set excludedSet = (Set)super.get(key);
            if (ctxSet != null) {
                if (excludedSet != null) {
                    ctxSet.addAll(excludedSet);
                }
                return ctxSet;
            }
            return excludedSet;
        }

        public boolean isEmpty() {
            return this.ctxMap.isEmpty() && super.isEmpty();
        }
    }
}

