/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.CacheStream;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.context.Flag;
import org.infinispan.stream.CacheCollectors;
import org.infinispan.util.function.SerializableConsumer;
import org.infinispan.util.function.SerializableSupplier;
import org.jboss.logging.Logger;
import org.keycloak.cluster.ClusterProvider;
import org.keycloak.common.util.Retry;
import org.keycloak.common.util.Time;
import org.keycloak.device.DeviceActivityManager;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakTransaction;
import org.keycloak.models.OfflineUserSessionModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserLoginFailureModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.UserSessionProvider;
import org.keycloak.models.sessions.infinispan.AuthenticatedClientSessionAdapter;
import org.keycloak.models.sessions.infinispan.CacheDecorators;
import org.keycloak.models.sessions.infinispan.UserLoginFailureAdapter;
import org.keycloak.models.sessions.infinispan.UserSessionAdapter;
import org.keycloak.models.sessions.infinispan.changes.InfinispanChangelogBasedTransaction;
import org.keycloak.models.sessions.infinispan.changes.SessionEntityWrapper;
import org.keycloak.models.sessions.infinispan.changes.SessionUpdateTask;
import org.keycloak.models.sessions.infinispan.changes.Tasks;
import org.keycloak.models.sessions.infinispan.changes.sessions.CrossDCLastSessionRefreshStore;
import org.keycloak.models.sessions.infinispan.changes.sessions.PersisterLastSessionRefreshStore;
import org.keycloak.models.sessions.infinispan.entities.AuthenticatedClientSessionEntity;
import org.keycloak.models.sessions.infinispan.entities.AuthenticatedClientSessionStore;
import org.keycloak.models.sessions.infinispan.entities.LoginFailureEntity;
import org.keycloak.models.sessions.infinispan.entities.LoginFailureKey;
import org.keycloak.models.sessions.infinispan.entities.UserSessionEntity;
import org.keycloak.models.sessions.infinispan.events.RealmRemovedSessionEvent;
import org.keycloak.models.sessions.infinispan.events.RemoveAllUserLoginFailuresEvent;
import org.keycloak.models.sessions.infinispan.events.RemoveUserSessionsEvent;
import org.keycloak.models.sessions.infinispan.events.SessionEventsSenderTransaction;
import org.keycloak.models.sessions.infinispan.remotestore.RemoteCacheInvoker;
import org.keycloak.models.sessions.infinispan.stream.AuthenticatedClientSessionPredicate;
import org.keycloak.models.sessions.infinispan.stream.Comparators;
import org.keycloak.models.sessions.infinispan.stream.Mappers;
import org.keycloak.models.sessions.infinispan.stream.SessionPredicate;
import org.keycloak.models.sessions.infinispan.stream.UserLoginFailurePredicate;
import org.keycloak.models.sessions.infinispan.stream.UserSessionPredicate;
import org.keycloak.models.sessions.infinispan.util.FuturesHelper;
import org.keycloak.models.sessions.infinispan.util.InfinispanKeyGenerator;
import org.keycloak.models.sessions.infinispan.util.InfinispanUtil;

public class InfinispanUserSessionProvider
implements UserSessionProvider {
    private static final Logger log = Logger.getLogger(InfinispanUserSessionProvider.class);
    protected final KeycloakSession session;
    protected final Cache<String, SessionEntityWrapper<UserSessionEntity>> sessionCache;
    protected final Cache<String, SessionEntityWrapper<UserSessionEntity>> offlineSessionCache;
    protected final Cache<UUID, SessionEntityWrapper<AuthenticatedClientSessionEntity>> clientSessionCache;
    protected final Cache<UUID, SessionEntityWrapper<AuthenticatedClientSessionEntity>> offlineClientSessionCache;
    protected final Cache<LoginFailureKey, SessionEntityWrapper<LoginFailureEntity>> loginFailureCache;
    protected final InfinispanChangelogBasedTransaction<String, UserSessionEntity> sessionTx;
    protected final InfinispanChangelogBasedTransaction<String, UserSessionEntity> offlineSessionTx;
    protected final InfinispanChangelogBasedTransaction<UUID, AuthenticatedClientSessionEntity> clientSessionTx;
    protected final InfinispanChangelogBasedTransaction<UUID, AuthenticatedClientSessionEntity> offlineClientSessionTx;
    protected final InfinispanChangelogBasedTransaction<LoginFailureKey, LoginFailureEntity> loginFailuresTx;
    protected final SessionEventsSenderTransaction clusterEventsSenderTx;
    protected final CrossDCLastSessionRefreshStore lastSessionRefreshStore;
    protected final CrossDCLastSessionRefreshStore offlineLastSessionRefreshStore;
    protected final PersisterLastSessionRefreshStore persisterLastSessionRefreshStore;
    protected final RemoteCacheInvoker remoteCacheInvoker;
    protected final InfinispanKeyGenerator keyGenerator;

    public InfinispanUserSessionProvider(KeycloakSession session, RemoteCacheInvoker remoteCacheInvoker, CrossDCLastSessionRefreshStore lastSessionRefreshStore, CrossDCLastSessionRefreshStore offlineLastSessionRefreshStore, PersisterLastSessionRefreshStore persisterLastSessionRefreshStore, InfinispanKeyGenerator keyGenerator, Cache<String, SessionEntityWrapper<UserSessionEntity>> sessionCache, Cache<String, SessionEntityWrapper<UserSessionEntity>> offlineSessionCache, Cache<UUID, SessionEntityWrapper<AuthenticatedClientSessionEntity>> clientSessionCache, Cache<UUID, SessionEntityWrapper<AuthenticatedClientSessionEntity>> offlineClientSessionCache, Cache<LoginFailureKey, SessionEntityWrapper<LoginFailureEntity>> loginFailureCache) {
        this.session = session;
        this.sessionCache = sessionCache;
        this.clientSessionCache = clientSessionCache;
        this.offlineSessionCache = offlineSessionCache;
        this.offlineClientSessionCache = offlineClientSessionCache;
        this.loginFailureCache = loginFailureCache;
        this.sessionTx = new InfinispanChangelogBasedTransaction<String, UserSessionEntity>(session, sessionCache, remoteCacheInvoker);
        this.offlineSessionTx = new InfinispanChangelogBasedTransaction<String, UserSessionEntity>(session, offlineSessionCache, remoteCacheInvoker);
        this.clientSessionTx = new InfinispanChangelogBasedTransaction<UUID, AuthenticatedClientSessionEntity>(session, clientSessionCache, remoteCacheInvoker);
        this.offlineClientSessionTx = new InfinispanChangelogBasedTransaction<UUID, AuthenticatedClientSessionEntity>(session, offlineClientSessionCache, remoteCacheInvoker);
        this.loginFailuresTx = new InfinispanChangelogBasedTransaction<LoginFailureKey, LoginFailureEntity>(session, loginFailureCache, remoteCacheInvoker);
        this.clusterEventsSenderTx = new SessionEventsSenderTransaction(session);
        this.lastSessionRefreshStore = lastSessionRefreshStore;
        this.offlineLastSessionRefreshStore = offlineLastSessionRefreshStore;
        this.persisterLastSessionRefreshStore = persisterLastSessionRefreshStore;
        this.remoteCacheInvoker = remoteCacheInvoker;
        this.keyGenerator = keyGenerator;
        session.getTransactionManager().enlistAfterCompletion((KeycloakTransaction)this.clusterEventsSenderTx);
        session.getTransactionManager().enlistAfterCompletion(this.sessionTx);
        session.getTransactionManager().enlistAfterCompletion(this.offlineSessionTx);
        session.getTransactionManager().enlistAfterCompletion(this.clientSessionTx);
        session.getTransactionManager().enlistAfterCompletion(this.offlineClientSessionTx);
        session.getTransactionManager().enlistAfterCompletion(this.loginFailuresTx);
    }

    protected Cache<String, SessionEntityWrapper<UserSessionEntity>> getCache(boolean offline) {
        return offline ? this.offlineSessionCache : this.sessionCache;
    }

    protected InfinispanChangelogBasedTransaction<String, UserSessionEntity> getTransaction(boolean offline) {
        return offline ? this.offlineSessionTx : this.sessionTx;
    }

    protected Cache<UUID, SessionEntityWrapper<AuthenticatedClientSessionEntity>> getClientSessionCache(boolean offline) {
        return offline ? this.offlineClientSessionCache : this.clientSessionCache;
    }

    protected InfinispanChangelogBasedTransaction<UUID, AuthenticatedClientSessionEntity> getClientSessionTransaction(boolean offline) {
        return offline ? this.offlineClientSessionTx : this.clientSessionTx;
    }

    protected CrossDCLastSessionRefreshStore getLastSessionRefreshStore() {
        return this.lastSessionRefreshStore;
    }

    protected CrossDCLastSessionRefreshStore getOfflineLastSessionRefreshStore() {
        return this.offlineLastSessionRefreshStore;
    }

    protected PersisterLastSessionRefreshStore getPersisterLastSessionRefreshStore() {
        return this.persisterLastSessionRefreshStore;
    }

    public AuthenticatedClientSessionModel createClientSession(RealmModel realm, ClientModel client, UserSessionModel userSession) {
        UUID clientSessionId = this.keyGenerator.generateKeyUUID(this.session, this.clientSessionCache);
        AuthenticatedClientSessionEntity entity = new AuthenticatedClientSessionEntity(clientSessionId);
        entity.setRealmId(realm.getId());
        entity.setTimestamp(Time.currentTime());
        InfinispanChangelogBasedTransaction<String, UserSessionEntity> userSessionUpdateTx = this.getTransaction(false);
        InfinispanChangelogBasedTransaction<UUID, AuthenticatedClientSessionEntity> clientSessionUpdateTx = this.getClientSessionTransaction(false);
        AuthenticatedClientSessionAdapter adapter = new AuthenticatedClientSessionAdapter(this.session, this, entity, client, userSession, userSessionUpdateTx, clientSessionUpdateTx, false);
        SessionUpdateTask createClientSessionTask = Tasks.addIfAbsentSync();
        clientSessionUpdateTx.addTask(clientSessionId, createClientSessionTask, entity);
        RegisterClientSessionTask registerClientSessionTask = new RegisterClientSessionTask(client.getId(), clientSessionId);
        userSessionUpdateTx.addTask(userSession.getId(), registerClientSessionTask);
        return adapter;
    }

    public UserSessionModel createUserSession(RealmModel realm, UserModel user, String loginUsername, String ipAddress, String authMethod, boolean rememberMe, String brokerSessionId, String brokerUserId) {
        String userSessionId = this.keyGenerator.generateKeyString(this.session, this.sessionCache);
        return this.createUserSession(userSessionId, realm, user, loginUsername, ipAddress, authMethod, rememberMe, brokerSessionId, brokerUserId);
    }

    public UserSessionModel createUserSession(String id, RealmModel realm, UserModel user, String loginUsername, String ipAddress, String authMethod, boolean rememberMe, String brokerSessionId, String brokerUserId) {
        UserSessionEntity entity = new UserSessionEntity();
        entity.setId(id);
        this.updateSessionEntity(entity, realm, user, loginUsername, ipAddress, authMethod, rememberMe, brokerSessionId, brokerUserId);
        SessionUpdateTask createSessionTask = Tasks.addIfAbsentSync();
        this.sessionTx.addTask(id, createSessionTask, entity);
        UserSessionAdapter adapter = this.wrap(realm, entity, false);
        if (adapter != null) {
            DeviceActivityManager.attachDevice((UserSessionModel)adapter, (KeycloakSession)this.session);
        }
        return adapter;
    }

    void updateSessionEntity(UserSessionEntity entity, RealmModel realm, UserModel user, String loginUsername, String ipAddress, String authMethod, boolean rememberMe, String brokerSessionId, String brokerUserId) {
        entity.setRealmId(realm.getId());
        entity.setUser(user.getId());
        entity.setLoginUsername(loginUsername);
        entity.setIpAddress(ipAddress);
        entity.setAuthMethod(authMethod);
        entity.setRememberMe(rememberMe);
        entity.setBrokerSessionId(brokerSessionId);
        entity.setBrokerUserId(brokerUserId);
        int currentTime = Time.currentTime();
        entity.setStarted(currentTime);
        entity.setLastSessionRefresh(currentTime);
    }

    public UserSessionModel getUserSession(RealmModel realm, String id) {
        return this.getUserSession(realm, id, false);
    }

    protected UserSessionAdapter getUserSession(RealmModel realm, String id, boolean offline) {
        UserSessionEntity entity = this.getUserSessionEntity(realm, id, offline);
        return this.wrap(realm, entity, offline);
    }

    private UserSessionEntity getUserSessionEntity(RealmModel realm, String id, boolean offline) {
        InfinispanChangelogBasedTransaction<String, UserSessionEntity> tx = this.getTransaction(offline);
        SessionEntityWrapper<UserSessionEntity> entityWrapper = tx.get(id);
        if (entityWrapper == null) {
            return null;
        }
        UserSessionEntity entity = entityWrapper.getEntity();
        if (!entity.getRealmId().equals(realm.getId())) {
            return null;
        }
        return entity;
    }

    protected List<UserSessionModel> getUserSessions(RealmModel realm, Predicate<Map.Entry<String, SessionEntityWrapper<UserSessionEntity>>> predicate, boolean offline) {
        Cache<String, SessionEntityWrapper<UserSessionEntity>> cache = this.getCache(offline);
        cache = CacheDecorators.skipCacheLoaders(cache);
        CacheStream cacheStream = cache.entrySet().stream();
        LinkedList<UserSessionModel> resultSessions = new LinkedList<UserSessionModel>();
        Iterator itr = cacheStream.filter(predicate).map(Mappers.userSessionEntity()).iterator();
        while (itr.hasNext()) {
            UserSessionEntity userSessionEntity = (UserSessionEntity)itr.next();
            resultSessions.add(this.wrap(realm, userSessionEntity, offline));
        }
        return resultSessions;
    }

    public AuthenticatedClientSessionAdapter getClientSession(UserSessionModel userSession, ClientModel client, UUID clientSessionId, boolean offline) {
        AuthenticatedClientSessionEntity entity = this.getClientSessionEntity(clientSessionId, offline);
        return this.wrap(userSession, client, entity, offline);
    }

    private AuthenticatedClientSessionEntity getClientSessionEntity(UUID id, boolean offline) {
        InfinispanChangelogBasedTransaction<UUID, AuthenticatedClientSessionEntity> tx = this.getClientSessionTransaction(offline);
        SessionEntityWrapper<AuthenticatedClientSessionEntity> entityWrapper = tx.get(id);
        return entityWrapper == null ? null : entityWrapper.getEntity();
    }

    public List<UserSessionModel> getUserSessions(RealmModel realm, UserModel user) {
        return this.getUserSessions(realm, UserSessionPredicate.create(realm.getId()).user(user.getId()), false);
    }

    public List<UserSessionModel> getUserSessionByBrokerUserId(RealmModel realm, String brokerUserId) {
        return this.getUserSessions(realm, UserSessionPredicate.create(realm.getId()).brokerUserId(brokerUserId), false);
    }

    public UserSessionModel getUserSessionByBrokerSessionId(RealmModel realm, String brokerSessionId) {
        List<UserSessionModel> userSessions = this.getUserSessions(realm, UserSessionPredicate.create(realm.getId()).brokerSessionId(brokerSessionId), false);
        return userSessions.isEmpty() ? null : userSessions.get(0);
    }

    public List<UserSessionModel> getUserSessions(RealmModel realm, ClientModel client) {
        return this.getUserSessions(realm, client, -1, -1);
    }

    public List<UserSessionModel> getUserSessions(RealmModel realm, ClientModel client, int firstResult, int maxResults) {
        return this.getUserSessions(realm, client, firstResult, maxResults, false);
    }

    protected List<UserSessionModel> getUserSessions(RealmModel realm, ClientModel client, int firstResult, int maxResults, boolean offline) {
        String clientUuid = client.getId();
        UserSessionPredicate predicate = UserSessionPredicate.create(realm.getId()).client(clientUuid);
        return this.getUserSessionModels(realm, firstResult, maxResults, offline, predicate);
    }

    protected List<UserSessionModel> getUserSessionModels(RealmModel realm, int firstResult, int maxResults, boolean offline, UserSessionPredicate predicate) {
        Cache<String, SessionEntityWrapper<UserSessionEntity>> cache = this.getCache(offline);
        cache = CacheDecorators.skipCacheLoaders(cache);
        Cache<UUID, SessionEntityWrapper<AuthenticatedClientSessionEntity>> clientSessionCache = this.getClientSessionCache(offline);
        AdvancedCache<UUID, SessionEntityWrapper<AuthenticatedClientSessionEntity>> clientSessionCacheDecorated = CacheDecorators.skipCacheLoaders(clientSessionCache);
        Object stream = cache.entrySet().stream().filter((Predicate)predicate).map(Mappers.userSessionEntity()).sorted(Comparators.userSessionLastSessionRefresh());
        if (firstResult > 0) {
            stream = stream.skip(firstResult);
        }
        if (maxResults > 0) {
            stream = stream.limit(maxResults);
        }
        LinkedList<UserSessionModel> sessions = new LinkedList<UserSessionModel>();
        Iterator itr = stream.iterator();
        while (itr.hasNext()) {
            UserSessionEntity userSessionEntity = (UserSessionEntity)itr.next();
            sessions.add(this.wrap(realm, userSessionEntity, offline));
        }
        return sessions;
    }

    public UserSessionModel getUserSessionWithPredicate(RealmModel realm, String id, boolean offline, Predicate<UserSessionModel> predicate) {
        UserSessionAdapter userSession = this.getUserSession(realm, id, offline);
        if (userSession == null) {
            return null;
        }
        if (predicate.test(userSession)) {
            log.debugf("getUserSessionWithPredicate(%s): found in local cache", (Object)id);
            return userSession;
        }
        Cache<String, SessionEntityWrapper<UserSessionEntity>> cache = this.getCache(offline);
        RemoteCache remoteCache = InfinispanUtil.getRemoteCache(cache);
        if (remoteCache != null) {
            SessionEntityWrapper remoteSessionEntityWrapper = (SessionEntityWrapper)remoteCache.get((Object)id);
            if (remoteSessionEntityWrapper != null) {
                UserSessionEntity remoteSessionEntity = (UserSessionEntity)remoteSessionEntityWrapper.getEntity();
                log.debugf("getUserSessionWithPredicate(%s): remote cache contains session entity %s", (Object)id, (Object)remoteSessionEntity);
                UserSessionAdapter remoteSessionAdapter = this.wrap(realm, remoteSessionEntity, offline);
                if (predicate.test(remoteSessionAdapter)) {
                    InfinispanChangelogBasedTransaction<String, UserSessionEntity> tx = this.getTransaction(offline);
                    SessionEntityWrapper sessionWrapper = remoteSessionEntity.mergeRemoteEntityWithLocalEntity(tx.get(id));
                    cache.getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_CACHE_STORE, Flag.SKIP_CACHE_LOAD, Flag.IGNORE_RETURN_VALUES}).replace((Object)id, (Object)sessionWrapper);
                    tx.reloadEntityInCurrentTransaction(realm, id, sessionWrapper);
                    return this.getUserSessionWithPredicate(realm, id, offline, predicate);
                }
                log.debugf("getUserSessionWithPredicate(%s): found, but predicate doesn't pass", (Object)id);
                return null;
            }
            log.debugf("getUserSessionWithPredicate(%s): not found", (Object)id);
            this.removeUserSession(realm, userSession);
            return null;
        }
        log.debugf("getUserSessionWithPredicate(%s): remote cache not available", (Object)id);
        return null;
    }

    public long getActiveUserSessions(RealmModel realm, ClientModel client) {
        return this.getUserSessionsCount(realm, client, false);
    }

    public Map<String, Long> getActiveClientSessionStats(RealmModel realm, boolean offline) {
        Cache<String, SessionEntityWrapper<UserSessionEntity>> cache = this.getCache(offline);
        cache = CacheDecorators.skipCacheLoaders(cache);
        return (Map)cache.entrySet().stream().filter((Predicate)UserSessionPredicate.create(realm.getId())).map(Mappers.authClientSessionSetMapper()).flatMap(Mappers::toStream).collect(CacheCollectors.serializableCollector((SerializableSupplier & Serializable)() -> Collectors.groupingBy(Function.identity(), Collectors.counting())));
    }

    protected long getUserSessionsCount(RealmModel realm, ClientModel client, boolean offline) {
        Cache<String, SessionEntityWrapper<UserSessionEntity>> cache = this.getCache(offline);
        cache = CacheDecorators.skipCacheLoaders(cache);
        String clientUuid = client.getId();
        return cache.entrySet().stream().filter((Predicate)UserSessionPredicate.create(realm.getId()).client(clientUuid)).count();
    }

    public void removeUserSession(RealmModel realm, UserSessionModel session) {
        UserSessionEntity entity = this.getUserSessionEntity(realm, session, false);
        if (entity != null) {
            this.removeUserSession(entity, false);
        }
    }

    public void removeUserSessions(RealmModel realm, UserModel user) {
        this.removeUserSessions(realm, user, false);
    }

    protected void removeUserSessions(RealmModel realm, UserModel user, boolean offline) {
        Cache<String, SessionEntityWrapper<UserSessionEntity>> cache = this.getCache(offline);
        cache = CacheDecorators.skipCacheLoaders(cache);
        for (UserSessionEntity userSessionEntity : cache.entrySet().stream().filter((Predicate)UserSessionPredicate.create(realm.getId()).user(user.getId())).map(Mappers.userSessionEntity())) {
            this.removeUserSession(userSessionEntity, offline);
        }
    }

    public void removeExpired(RealmModel realm) {
        log.debugf("Removing expired sessions", new Object[0]);
        this.removeExpiredUserSessions(realm);
        this.removeExpiredOfflineUserSessions(realm);
    }

    private void removeExpiredUserSessions(RealmModel realm) {
        int expired = Time.currentTime() - realm.getSsoSessionMaxLifespan();
        int expiredRefresh = Time.currentTime() - realm.getSsoSessionIdleTimeout() - 180;
        int expiredRememberMe = Time.currentTime() - (realm.getSsoSessionMaxLifespanRememberMe() > 0 ? realm.getSsoSessionMaxLifespanRememberMe() : realm.getSsoSessionMaxLifespan());
        int expiredRefreshRememberMe = Time.currentTime() - (realm.getSsoSessionIdleTimeoutRememberMe() > 0 ? realm.getSsoSessionIdleTimeoutRememberMe() : realm.getSsoSessionIdleTimeout()) - 180;
        final FuturesHelper futures = new FuturesHelper();
        AdvancedCache<String, SessionEntityWrapper<UserSessionEntity>> localCache = CacheDecorators.localCache(this.sessionCache);
        AdvancedCache<String, SessionEntityWrapper<UserSessionEntity>> localCacheStoreIgnore = CacheDecorators.skipCacheLoaders(localCache);
        final AtomicInteger userSessionsSize = new AtomicInteger();
        final AtomicInteger clientSessionsSize = new AtomicInteger();
        localCacheStoreIgnore.entrySet().stream().filter((Predicate)UserSessionPredicate.create(realm.getId()).expired(expired, expiredRefresh, expiredRememberMe, expiredRefreshRememberMe)).map(Mappers.userSessionEntity()).forEach((Consumer)new Consumer<UserSessionEntity>(){

            @Override
            public void accept(UserSessionEntity userSessionEntity) {
                userSessionsSize.incrementAndGet();
                CompletableFuture future = InfinispanUserSessionProvider.this.sessionCache.removeAsync((Object)userSessionEntity.getId());
                futures.addTask(future);
                userSessionEntity.getAuthenticatedClientSessions().forEach((clientUUID, clientSessionId) -> {
                    clientSessionsSize.incrementAndGet();
                    CompletableFuture f = InfinispanUserSessionProvider.this.clientSessionCache.removeAsync(clientSessionId);
                    futures.addTask(f);
                });
            }
        });
        AdvancedCache<UUID, SessionEntityWrapper<AuthenticatedClientSessionEntity>> localClientSessionCache = CacheDecorators.localCache(this.clientSessionCache);
        AdvancedCache<UUID, SessionEntityWrapper<AuthenticatedClientSessionEntity>> localClientSessionCacheStoreIgnore = CacheDecorators.skipCacheLoaders(localClientSessionCache);
        localClientSessionCacheStoreIgnore.entrySet().stream().filter((Predicate)AuthenticatedClientSessionPredicate.create(realm.getId()).expired(Math.min(expired, expiredRememberMe))).map(Mappers.clientSessionEntity()).forEach((Consumer)new Consumer<AuthenticatedClientSessionEntity>(){

            @Override
            public void accept(AuthenticatedClientSessionEntity clientSessionEntity) {
                clientSessionsSize.incrementAndGet();
                CompletableFuture future = InfinispanUserSessionProvider.this.clientSessionCache.removeAsync((Object)clientSessionEntity.getId());
                futures.addTask(future);
            }
        });
        futures.waitForAllToFinish();
        log.debugf("Removed %d expired user sessions and %d expired client sessions for realm '%s'", userSessionsSize.get(), clientSessionsSize.get(), (Object)realm.getName());
    }

    private void removeExpiredOfflineUserSessions(RealmModel realm) {
        int expiredOffline = Time.currentTime() - realm.getOfflineSessionIdleTimeout() - 180;
        AdvancedCache<String, SessionEntityWrapper<UserSessionEntity>> localCache = CacheDecorators.localCache(this.offlineSessionCache);
        UserSessionPredicate predicate = UserSessionPredicate.create(realm.getId()).expired(null, expiredOffline);
        final FuturesHelper futures = new FuturesHelper();
        AdvancedCache<String, SessionEntityWrapper<UserSessionEntity>> localCacheStoreIgnore = CacheDecorators.skipCacheLoaders(localCache);
        final AtomicInteger userSessionsSize = new AtomicInteger();
        final AtomicInteger clientSessionsSize = new AtomicInteger();
        localCacheStoreIgnore.entrySet().stream().filter((Predicate)predicate).map(Mappers.userSessionEntity()).forEach((Consumer)new Consumer<UserSessionEntity>(){

            @Override
            public void accept(UserSessionEntity userSessionEntity) {
                userSessionsSize.incrementAndGet();
                CompletableFuture future = InfinispanUserSessionProvider.this.offlineSessionCache.removeAsync((Object)userSessionEntity.getId());
                futures.addTask(future);
                userSessionEntity.getAuthenticatedClientSessions().forEach((clientUUID, clientSessionId) -> {
                    clientSessionsSize.incrementAndGet();
                    CompletableFuture f = InfinispanUserSessionProvider.this.offlineClientSessionCache.removeAsync(clientSessionId);
                    futures.addTask(f);
                });
            }
        });
        AdvancedCache<UUID, SessionEntityWrapper<AuthenticatedClientSessionEntity>> localClientSessionCache = CacheDecorators.localCache(this.offlineClientSessionCache);
        AdvancedCache<UUID, SessionEntityWrapper<AuthenticatedClientSessionEntity>> localClientSessionCacheStoreIgnore = CacheDecorators.skipCacheLoaders(localClientSessionCache);
        localClientSessionCacheStoreIgnore.entrySet().stream().filter((Predicate)AuthenticatedClientSessionPredicate.create(realm.getId()).expired(expiredOffline)).map(Mappers.clientSessionEntity()).forEach((Consumer)new Consumer<AuthenticatedClientSessionEntity>(){

            @Override
            public void accept(AuthenticatedClientSessionEntity clientSessionEntity) {
                clientSessionsSize.incrementAndGet();
                CompletableFuture future = InfinispanUserSessionProvider.this.offlineClientSessionCache.removeAsync((Object)clientSessionEntity.getId());
                futures.addTask(future);
            }
        });
        futures.waitForAllToFinish();
        log.debugf("Removed %d expired offline user sessions and %d expired offline client sessions for realm '%s'", userSessionsSize.get(), clientSessionsSize.get(), (Object)realm.getName());
    }

    public void removeUserSessions(RealmModel realm) {
        this.clusterEventsSenderTx.addEvent(RemoveUserSessionsEvent.createEvent(RemoveUserSessionsEvent.class, "REMOVE_USER_SESSIONS_EVENT", this.session, realm.getId(), true), ClusterProvider.DCNotify.LOCAL_DC_ONLY);
    }

    protected void onRemoveUserSessionsEvent(String realmId) {
        this.removeLocalUserSessions(realmId, false);
    }

    private void removeLocalUserSessions(String realmId, boolean offline) {
        final FuturesHelper futures = new FuturesHelper();
        Cache<String, SessionEntityWrapper<UserSessionEntity>> cache = this.getCache(offline);
        final AdvancedCache<String, SessionEntityWrapper<UserSessionEntity>> localCache = CacheDecorators.localCache(cache);
        Cache<UUID, SessionEntityWrapper<AuthenticatedClientSessionEntity>> clientSessionCache = this.getClientSessionCache(offline);
        final AdvancedCache<UUID, SessionEntityWrapper<AuthenticatedClientSessionEntity>> localClientSessionCache = CacheDecorators.localCache(clientSessionCache);
        AdvancedCache<String, SessionEntityWrapper<UserSessionEntity>> localCacheStoreIgnore = CacheDecorators.skipCacheLoaders(localCache);
        final AtomicInteger userSessionsSize = new AtomicInteger();
        localCacheStoreIgnore.entrySet().stream().filter((Predicate)SessionPredicate.create(realmId)).map(Mappers.userSessionEntity()).forEach((Consumer)new Consumer<UserSessionEntity>(){

            @Override
            public void accept(UserSessionEntity userSessionEntity) {
                userSessionsSize.incrementAndGet();
                CompletableFuture future = localCache.removeAsync((Object)userSessionEntity.getId());
                futures.addTask(future);
                userSessionEntity.getAuthenticatedClientSessions().forEach((clientUUID, clientSessionId) -> {
                    CompletableFuture f = localClientSessionCache.removeAsync(clientSessionId);
                    futures.addTask(f);
                });
            }
        });
        futures.waitForAllToFinish();
        log.debugf("Removed %d sessions in realm %s. Offline: %b", (Object)userSessionsSize.get(), (Object)realmId, (Object)offline);
    }

    public UserLoginFailureModel getUserLoginFailure(RealmModel realm, String userId) {
        LoginFailureKey key = new LoginFailureKey(realm.getId(), userId);
        LoginFailureEntity entity = this.getLoginFailureEntity(key);
        return this.wrap(key, entity);
    }

    private LoginFailureEntity getLoginFailureEntity(LoginFailureKey key) {
        InfinispanChangelogBasedTransaction<LoginFailureKey, LoginFailureEntity> tx = this.getLoginFailuresTx();
        SessionEntityWrapper<LoginFailureEntity> entityWrapper = tx.get(key);
        return entityWrapper == null ? null : entityWrapper.getEntity();
    }

    public UserLoginFailureModel addUserLoginFailure(RealmModel realm, String userId) {
        LoginFailureKey key = new LoginFailureKey(realm.getId(), userId);
        LoginFailureEntity entity = new LoginFailureEntity();
        entity.setRealmId(realm.getId());
        entity.setUserId(userId);
        SessionUpdateTask createLoginFailureTask = Tasks.addIfAbsentSync();
        this.loginFailuresTx.addTask(key, createLoginFailureTask, entity);
        return this.wrap(key, entity);
    }

    public void removeUserLoginFailure(RealmModel realm, String userId) {
        SessionUpdateTask removeTask = Tasks.removeSync();
        this.loginFailuresTx.addTask(new LoginFailureKey(realm.getId(), userId), removeTask);
    }

    public void removeAllUserLoginFailures(RealmModel realm) {
        this.clusterEventsSenderTx.addEvent(RemoveAllUserLoginFailuresEvent.createEvent(RemoveAllUserLoginFailuresEvent.class, "REMOVE_ALL_LOGIN_FAILURES_EVENT", this.session, realm.getId(), true), ClusterProvider.DCNotify.LOCAL_DC_ONLY);
    }

    protected void onRemoveAllUserLoginFailuresEvent(String realmId) {
        this.removeAllLocalUserLoginFailuresEvent(realmId);
    }

    private void removeAllLocalUserLoginFailuresEvent(String realmId) {
        FuturesHelper futures = new FuturesHelper();
        AdvancedCache<LoginFailureKey, SessionEntityWrapper<LoginFailureEntity>> localCache = CacheDecorators.localCache(this.loginFailureCache);
        AdvancedCache<LoginFailureKey, SessionEntityWrapper<LoginFailureEntity>> localCacheStoreIgnore = CacheDecorators.skipCacheLoaders(localCache);
        localCacheStoreIgnore.entrySet().stream().filter((Predicate)UserLoginFailurePredicate.create(realmId)).map(Mappers.loginFailureId()).forEach((SerializableConsumer & Serializable)loginFailureKey -> {
            CompletableFuture future = localCache.removeAsync(loginFailureKey);
            futures.addTask(future);
        });
        futures.waitForAllToFinish();
        log.debugf("Removed %d login failures in realm %s", futures.size(), (Object)realmId);
    }

    public void onRealmRemoved(RealmModel realm) {
        this.clusterEventsSenderTx.addEvent(RealmRemovedSessionEvent.createEvent(RealmRemovedSessionEvent.class, "REALM_REMOVED_EVENT_SESSIONS", this.session, realm.getId(), true), ClusterProvider.DCNotify.LOCAL_DC_ONLY);
    }

    protected void onRealmRemovedEvent(String realmId) {
        this.removeLocalUserSessions(realmId, true);
        this.removeLocalUserSessions(realmId, false);
        this.removeAllLocalUserLoginFailuresEvent(realmId);
    }

    public void onClientRemoved(RealmModel realm, ClientModel client) {
    }

    protected void onClientRemovedEvent(String realmId, String clientUuid) {
    }

    protected void onUserRemoved(RealmModel realm, UserModel user) {
        this.removeUserSessions(realm, user, true);
        this.removeUserSessions(realm, user, false);
        this.removeUserLoginFailure(realm, user.getId());
    }

    public void close() {
    }

    protected void removeUserSession(UserSessionEntity sessionEntity, boolean offline) {
        InfinispanChangelogBasedTransaction<String, UserSessionEntity> userSessionUpdateTx = this.getTransaction(offline);
        InfinispanChangelogBasedTransaction<UUID, AuthenticatedClientSessionEntity> clientSessionUpdateTx = this.getClientSessionTransaction(offline);
        sessionEntity.getAuthenticatedClientSessions().forEach((clientUUID, clientSessionId) -> clientSessionUpdateTx.addTask((UUID)clientSessionId, Tasks.removeSync()));
        SessionUpdateTask removeTask = Tasks.removeSync();
        userSessionUpdateTx.addTask(sessionEntity.getId(), removeTask);
    }

    InfinispanChangelogBasedTransaction<LoginFailureKey, LoginFailureEntity> getLoginFailuresTx() {
        return this.loginFailuresTx;
    }

    UserSessionAdapter wrap(RealmModel realm, UserSessionEntity entity, boolean offline) {
        InfinispanChangelogBasedTransaction<String, UserSessionEntity> userSessionUpdateTx = this.getTransaction(offline);
        InfinispanChangelogBasedTransaction<UUID, AuthenticatedClientSessionEntity> clientSessionUpdateTx = this.getClientSessionTransaction(offline);
        return entity != null ? new UserSessionAdapter(this.session, this, userSessionUpdateTx, clientSessionUpdateTx, realm, entity, offline) : null;
    }

    AuthenticatedClientSessionAdapter wrap(UserSessionModel userSession, ClientModel client, AuthenticatedClientSessionEntity entity, boolean offline) {
        InfinispanChangelogBasedTransaction<String, UserSessionEntity> userSessionUpdateTx = this.getTransaction(offline);
        InfinispanChangelogBasedTransaction<UUID, AuthenticatedClientSessionEntity> clientSessionUpdateTx = this.getClientSessionTransaction(offline);
        return entity != null ? new AuthenticatedClientSessionAdapter(this.session, this, entity, client, userSession, userSessionUpdateTx, clientSessionUpdateTx, offline) : null;
    }

    UserLoginFailureModel wrap(LoginFailureKey key, LoginFailureEntity entity) {
        return entity != null ? new UserLoginFailureAdapter(this, key, entity) : null;
    }

    UserSessionEntity getUserSessionEntity(RealmModel realm, UserSessionModel userSession, boolean offline) {
        if (userSession instanceof UserSessionAdapter) {
            if (!userSession.getRealm().equals(realm)) {
                return null;
            }
            return ((UserSessionAdapter)userSession).getEntity();
        }
        return this.getUserSessionEntity(realm, userSession.getId(), offline);
    }

    public UserSessionModel createOfflineUserSession(UserSessionModel userSession) {
        UserSessionAdapter offlineUserSession = this.importUserSession(userSession, true);
        int currentTime = Time.currentTime();
        offlineUserSession.getEntity().setStarted(currentTime);
        offlineUserSession.setLastSessionRefresh(currentTime);
        return offlineUserSession;
    }

    public UserSessionAdapter getOfflineUserSession(RealmModel realm, String userSessionId) {
        return this.getUserSession(realm, userSessionId, true);
    }

    public void removeOfflineUserSession(RealmModel realm, UserSessionModel userSession) {
        UserSessionEntity userSessionEntity = this.getUserSessionEntity(realm, userSession, true);
        if (userSessionEntity != null) {
            this.removeUserSession(userSessionEntity, true);
        }
    }

    public AuthenticatedClientSessionModel createOfflineClientSession(AuthenticatedClientSessionModel clientSession, UserSessionModel offlineUserSession) {
        UserSessionAdapter userSessionAdapter = offlineUserSession instanceof UserSessionAdapter ? (UserSessionAdapter)offlineUserSession : this.getOfflineUserSession(offlineUserSession.getRealm(), offlineUserSession.getId());
        InfinispanChangelogBasedTransaction<String, UserSessionEntity> userSessionUpdateTx = this.getTransaction(true);
        InfinispanChangelogBasedTransaction<UUID, AuthenticatedClientSessionEntity> clientSessionUpdateTx = this.getClientSessionTransaction(true);
        AuthenticatedClientSessionAdapter offlineClientSession = this.importClientSession(userSessionAdapter, clientSession, userSessionUpdateTx, clientSessionUpdateTx, true);
        offlineClientSession.setTimestamp(Time.currentTime());
        return offlineClientSession;
    }

    public List<UserSessionModel> getOfflineUserSessions(RealmModel realm, UserModel user) {
        LinkedList<UserSessionModel> userSessions = new LinkedList<UserSessionModel>();
        AdvancedCache<String, SessionEntityWrapper<UserSessionEntity>> cache = CacheDecorators.skipCacheLoaders(this.offlineSessionCache);
        for (UserSessionEntity userSessionEntity : cache.entrySet().stream().filter((Predicate)UserSessionPredicate.create(realm.getId()).user(user.getId())).map(Mappers.userSessionEntity())) {
            UserSessionAdapter userSession = this.wrap(realm, userSessionEntity, true);
            userSessions.add(userSession);
        }
        return userSessions;
    }

    public long getOfflineSessionsCount(RealmModel realm, ClientModel client) {
        return this.getUserSessionsCount(realm, client, true);
    }

    public List<UserSessionModel> getOfflineUserSessions(RealmModel realm, ClientModel client, int first, int max) {
        return this.getUserSessions(realm, client, first, max, true);
    }

    public void importUserSessions(Collection<UserSessionModel> persistentUserSessions, boolean offline) {
        if (persistentUserSessions == null || persistentUserSessions.isEmpty()) {
            return;
        }
        HashMap clientSessionsById = new HashMap();
        Map sessionsById = persistentUserSessions.stream().map(persistentUserSession -> {
            UserSessionEntity userSessionEntityToImport = this.createUserSessionEntityInstance((UserSessionModel)persistentUserSession);
            for (Map.Entry entry : persistentUserSession.getAuthenticatedClientSessions().entrySet()) {
                String clientUUID = (String)entry.getKey();
                AuthenticatedClientSessionModel clientSession = (AuthenticatedClientSessionModel)entry.getValue();
                AuthenticatedClientSessionEntity clientSessionToImport = this.createAuthenticatedClientSessionInstance(clientSession, userSessionEntityToImport.getRealmId(), offline);
                clientSessionToImport.setTimestamp(userSessionEntityToImport.getLastSessionRefresh());
                clientSessionsById.put(clientSessionToImport.getId(), new SessionEntityWrapper<AuthenticatedClientSessionEntity>(clientSessionToImport));
                AuthenticatedClientSessionStore clientSessions = userSessionEntityToImport.getAuthenticatedClientSessions();
                clientSessions.put(clientUUID, clientSessionToImport.getId());
            }
            return userSessionEntityToImport;
        }).map(SessionEntityWrapper::new).collect(Collectors.toMap(sessionEntityWrapper -> ((UserSessionEntity)sessionEntityWrapper.getEntity()).getId(), Function.identity()));
        AdvancedCache<String, SessionEntityWrapper<UserSessionEntity>> cache = CacheDecorators.skipCacheLoaders(this.getCache(offline));
        cache.putAll(sessionsById);
        RemoteCache remoteCache = InfinispanUtil.getRemoteCache(cache);
        if (remoteCache != null) {
            Map sessionsByIdForTransport = sessionsById.values().stream().map(SessionEntityWrapper::forTransport).collect(Collectors.toMap(sessionEntityWrapper -> ((UserSessionEntity)sessionEntityWrapper.getEntity()).getId(), Function.identity()));
            Retry.executeWithBackoff(iteration -> {
                try {
                    remoteCache.putAll(sessionsByIdForTransport);
                }
                catch (HotRodClientException re) {
                    if (log.isDebugEnabled()) {
                        log.debugf((Throwable)re, "Failed to put import %d sessions to remoteCache. Iteration '%s'. Will try to retry the task", sessionsByIdForTransport.size(), iteration);
                    }
                    throw re;
                }
            }, (int)10, (int)10);
        }
        Cache<UUID, SessionEntityWrapper<AuthenticatedClientSessionEntity>> clientSessCache = offline ? this.offlineClientSessionCache : this.clientSessionCache;
        clientSessCache = CacheDecorators.skipCacheLoaders(clientSessCache);
        clientSessCache.putAll(clientSessionsById);
        RemoteCache remoteCacheClientSessions = InfinispanUtil.getRemoteCache(clientSessCache);
        if (remoteCacheClientSessions != null) {
            Map sessionsByIdForTransport = clientSessionsById.values().stream().map(SessionEntityWrapper::forTransport).collect(Collectors.toMap(sessionEntityWrapper -> ((AuthenticatedClientSessionEntity)sessionEntityWrapper.getEntity()).getId(), Function.identity()));
            Retry.executeWithBackoff(iteration -> {
                try {
                    remoteCacheClientSessions.putAll(sessionsByIdForTransport);
                }
                catch (HotRodClientException re) {
                    if (log.isDebugEnabled()) {
                        log.debugf((Throwable)re, "Failed to put import %d client sessions to remoteCache. Iteration '%s'. Will try to retry the task", sessionsByIdForTransport.size(), iteration);
                    }
                    throw re;
                }
            }, (int)10, (int)10);
        }
    }

    protected UserSessionAdapter importUserSession(UserSessionModel userSession, boolean offline) {
        UserSessionEntity entity = this.createUserSessionEntityInstance(userSession);
        InfinispanChangelogBasedTransaction<String, UserSessionEntity> userSessionUpdateTx = this.getTransaction(offline);
        InfinispanChangelogBasedTransaction<UUID, AuthenticatedClientSessionEntity> clientSessionUpdateTx = this.getClientSessionTransaction(offline);
        SessionUpdateTask importTask = Tasks.addIfAbsentSync();
        userSessionUpdateTx.addTask(userSession.getId(), importTask, entity);
        UserSessionAdapter importedSession = this.wrap(userSession.getRealm(), entity, offline);
        return importedSession;
    }

    private UserSessionEntity createUserSessionEntityInstance(UserSessionModel userSession) {
        UserSessionEntity entity = new UserSessionEntity();
        entity.setId(userSession.getId());
        entity.setRealmId(userSession.getRealm().getId());
        entity.setAuthMethod(userSession.getAuthMethod());
        entity.setBrokerSessionId(userSession.getBrokerSessionId());
        entity.setBrokerUserId(userSession.getBrokerUserId());
        entity.setIpAddress(userSession.getIpAddress());
        entity.setNotes(userSession.getNotes() == null ? new ConcurrentHashMap() : userSession.getNotes());
        entity.setAuthenticatedClientSessions(new AuthenticatedClientSessionStore());
        entity.setRememberMe(userSession.isRememberMe());
        entity.setState(userSession.getState());
        if (userSession instanceof OfflineUserSessionModel) {
            OfflineUserSessionModel oline = (OfflineUserSessionModel)userSession;
            entity.setUser(oline.getUserId());
        } else {
            entity.setLoginUsername(userSession.getLoginUsername());
            entity.setUser(userSession.getUser().getId());
        }
        entity.setStarted(userSession.getStarted());
        entity.setLastSessionRefresh(userSession.getLastSessionRefresh());
        return entity;
    }

    private AuthenticatedClientSessionAdapter importClientSession(UserSessionAdapter sessionToImportInto, AuthenticatedClientSessionModel clientSession, InfinispanChangelogBasedTransaction<String, UserSessionEntity> userSessionUpdateTx, InfinispanChangelogBasedTransaction<UUID, AuthenticatedClientSessionEntity> clientSessionUpdateTx, boolean offline) {
        AuthenticatedClientSessionEntity entity = this.createAuthenticatedClientSessionInstance(clientSession, sessionToImportInto.getRealm().getId(), offline);
        UUID clientSessionId = entity.getId();
        SessionUpdateTask createClientSessionTask = Tasks.addIfAbsentSync();
        clientSessionUpdateTx.addTask(entity.getId(), createClientSessionTask, entity);
        AuthenticatedClientSessionStore clientSessions = sessionToImportInto.getEntity().getAuthenticatedClientSessions();
        clientSessions.put(clientSession.getClient().getId(), clientSessionId);
        RegisterClientSessionTask registerClientSessionTask = new RegisterClientSessionTask(clientSession.getClient().getId(), clientSessionId);
        userSessionUpdateTx.addTask(sessionToImportInto.getId(), registerClientSessionTask);
        return new AuthenticatedClientSessionAdapter(this.session, this, entity, clientSession.getClient(), sessionToImportInto, userSessionUpdateTx, clientSessionUpdateTx, offline);
    }

    private AuthenticatedClientSessionEntity createAuthenticatedClientSessionInstance(AuthenticatedClientSessionModel clientSession, String realmId, boolean offline) {
        UUID clientSessionId = this.keyGenerator.generateKeyUUID(this.session, this.getClientSessionCache(offline));
        AuthenticatedClientSessionEntity entity = new AuthenticatedClientSessionEntity(clientSessionId);
        entity.setRealmId(realmId);
        entity.setAction(clientSession.getAction());
        entity.setAuthMethod(clientSession.getProtocol());
        entity.setNotes(clientSession.getNotes() == null ? new ConcurrentHashMap() : clientSession.getNotes());
        entity.setRedirectUri(clientSession.getRedirectUri());
        entity.setTimestamp(clientSession.getTimestamp());
        return entity;
    }

    private static class RegisterClientSessionTask
    implements SessionUpdateTask<UserSessionEntity> {
        private final String clientUuid;
        private final UUID clientSessionId;

        public RegisterClientSessionTask(String clientUuid, UUID clientSessionId) {
            this.clientUuid = clientUuid;
            this.clientSessionId = clientSessionId;
        }

        @Override
        public void runUpdate(UserSessionEntity session) {
            AuthenticatedClientSessionStore clientSessions = session.getAuthenticatedClientSessions();
            clientSessions.put(this.clientUuid, this.clientSessionId);
        }

        @Override
        public SessionUpdateTask.CacheOperation getOperation(UserSessionEntity session) {
            return SessionUpdateTask.CacheOperation.REPLACE;
        }

        @Override
        public SessionUpdateTask.CrossDCMessageStatus getCrossDCMessageStatus(SessionEntityWrapper<UserSessionEntity> sessionWrapper) {
            return SessionUpdateTask.CrossDCMessageStatus.SYNC;
        }
    }
}

