/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.spi.core.security.jaas;

import java.io.IOException;
import java.security.Principal;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import javax.security.cert.X509Certificate;
import org.apache.activemq.artemis.spi.core.security.jaas.CertificateCallback;
import org.apache.activemq.artemis.spi.core.security.jaas.PropertiesLoader;
import org.apache.activemq.artemis.spi.core.security.jaas.RolePrincipal;
import org.apache.activemq.artemis.spi.core.security.jaas.UserPrincipal;
import org.jboss.logging.Logger;

public abstract class CertificateLoginModule
extends PropertiesLoader
implements LoginModule {
    private static final Logger logger = Logger.getLogger(CertificateLoginModule.class);
    private CallbackHandler callbackHandler;
    private Subject subject;
    private X509Certificate[] certificates;
    private String username;
    private final Set<Principal> principals = new HashSet<Principal>();

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.init(options);
    }

    @Override
    public boolean login() throws LoginException {
        Callback[] callbacks = new Callback[]{new CertificateCallback()};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (IOException ioe) {
            throw new LoginException(ioe.getMessage());
        }
        catch (UnsupportedCallbackException uce) {
            throw new LoginException("Unable to obtain client certificates: " + uce.getMessage());
        }
        this.certificates = ((CertificateCallback)callbacks[0]).getCertificates();
        this.username = this.getUserNameForCertificates(this.certificates);
        if (this.username == null) {
            throw new FailedLoginException("No user for client certificate: " + this.getDistinguishedName(this.certificates));
        }
        if (this.debug) {
            logger.debug((Object)("Certificate for user: " + this.username));
        }
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        this.principals.add(new UserPrincipal(this.username));
        for (String role : this.getUserRoles(this.username)) {
            this.principals.add(new RolePrincipal(role));
        }
        this.subject.getPrincipals().addAll(this.principals);
        this.clear();
        if (this.debug) {
            logger.debug((Object)"commit");
        }
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        this.clear();
        if (this.debug) {
            logger.debug((Object)"abort");
        }
        return true;
    }

    @Override
    public boolean logout() {
        this.subject.getPrincipals().removeAll(this.principals);
        this.principals.clear();
        if (this.debug) {
            logger.debug((Object)"logout");
        }
        return true;
    }

    private void clear() {
        this.certificates = null;
        this.username = null;
    }

    protected abstract String getUserNameForCertificates(X509Certificate[] var1) throws LoginException;

    protected abstract Set<String> getUserRoles(String var1) throws LoginException;

    protected String getDistinguishedName(X509Certificate[] certs) {
        if (certs != null && certs.length > 0 && certs[0] != null) {
            return certs[0].getSubjectDN().getName();
        }
        return null;
    }
}

