/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.adapters.jdbc;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import javax.resource.ResourceException;
import javax.transaction.xa.XAResource;
import org.jboss.jca.adapters.AdaptersLogger;
import org.jboss.jca.adapters.jdbc.BaseWrapperManagedConnection;
import org.jboss.jca.adapters.jdbc.JBossWrapper;
import org.jboss.jca.adapters.jdbc.SecurityActions;
import org.jboss.jca.adapters.jdbc.WrappedCallableStatement;
import org.jboss.jca.adapters.jdbc.WrappedPreparedStatement;
import org.jboss.jca.adapters.jdbc.WrappedStatement;
import org.jboss.jca.adapters.jdbc.WrapperDataSource;
import org.jboss.jca.adapters.jdbc.spi.ClassLoaderPlugin;
import org.jboss.logging.Logger;

public abstract class WrappedConnection
extends JBossWrapper
implements Connection {
    private static AdaptersLogger log = (AdaptersLogger)Logger.getMessageLogger(AdaptersLogger.class, (String)WrappedConnection.class.getName());
    protected static Logger spyLogger = Logger.getLogger((String)"jboss.jdbc.spy");
    private volatile BaseWrapperManagedConnection mc;
    private BaseWrapperManagedConnection lockedMC;
    private int lockCount;
    private WrapperDataSource dataSource;
    private HashMap<WrappedStatement, Throwable> statements;
    private boolean closed = false;
    private int trackStatements;
    protected boolean spy = false;
    protected String jndiName = null;
    protected final boolean doLocking;
    private final ClassLoaderPlugin classLoaderPlugin;

    public WrappedConnection(BaseWrapperManagedConnection mc, boolean spy, String jndiName, boolean doLocking, ClassLoaderPlugin classLoaderPlugin) {
        this.setManagedConnection(mc);
        this.setSpy(spy);
        this.setJndiName(jndiName);
        this.doLocking = doLocking;
        this.classLoaderPlugin = classLoaderPlugin;
    }

    void setManagedConnection(BaseWrapperManagedConnection mc) {
        this.mc = mc;
        if (mc != null) {
            this.trackStatements = mc.getTrackStatements();
            if (this.lockCount > 0) {
                throw new IllegalStateException(bundle.wrappedConnectionInUse());
            }
        } else {
            this.closed = true;
        }
    }

    void setSpy(boolean v) {
        this.spy = v;
    }

    void setJndiName(String v) {
        this.jndiName = v;
    }

    protected void lock() throws SQLException {
        BaseWrapperManagedConnection mc = this.mc;
        if (mc != null) {
            mc.tryLock();
            if (this.lockedMC == null) {
                this.lockedMC = mc;
            }
            ++this.lockCount;
        } else {
            throw new SQLException(bundle.connectionNotAssociated(this.toString()));
        }
    }

    protected void unlock() {
        BaseWrapperManagedConnection mc = this.lockedMC;
        if (--this.lockCount == 0) {
            this.lockedMC = null;
        }
        if (mc != null) {
            mc.unlock();
        }
    }

    public WrapperDataSource getDataSource() {
        return this.dataSource;
    }

    protected void setDataSource(WrapperDataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkStatus();
            if (this.spy) {
                spyLogger.debugf("%s [%s] setReadOnly(%s)", (Object)this.jndiName, (Object)"Connection", (Object)readOnly);
            }
            this.mc.setJdbcReadOnly(readOnly);
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.checkStatus();
        if (this.spy) {
            spyLogger.debugf("%s [%s] isReadOnly()", (Object)this.jndiName, (Object)"Connection");
        }
        return this.mc.isJdbcReadOnly();
    }

    public void invalidate() throws SQLException {
        if (this.spy) {
            spyLogger.debugf("%s [%s] invalidate()", (Object)this.jndiName, (Object)"Connection");
        }
        this.returnConnection(true);
    }

    @Override
    public void close() throws SQLException {
        if (this.spy) {
            spyLogger.debugf("%s [%s] close()", (Object)this.jndiName, (Object)"Connection");
        }
        this.returnConnection(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void returnConnection(boolean error) throws SQLException {
        this.closed = true;
        if (this.mc != null) {
            if (this.trackStatements != 0) {
                WrappedConnection wrappedConnection = this;
                synchronized (wrappedConnection) {
                    if (this.statements != null && this.statements.size() > 0) {
                        for (Map.Entry<WrappedStatement, Throwable> entry : this.statements.entrySet()) {
                            WrappedStatement ws = entry.getKey();
                            if (this.trackStatements == 1) {
                                Throwable stackTrace = entry.getValue();
                                log.closingStatement(this.jndiName, stackTrace);
                            }
                            try {
                                ws.internalClose();
                            }
                            catch (Throwable t) {
                                log.errorDuringClosingStatement(this.jndiName, t);
                            }
                        }
                    }
                }
            }
            if (!error) {
                this.mc.closeHandle(this);
            } else {
                this.mc.errorHandle(this);
            }
        }
        this.mc = null;
        this.dataSource = null;
    }

    @Override
    public boolean isClosed() throws SQLException {
        if (this.spy) {
            spyLogger.debugf("%s [%s] isClosed()", (Object)this.jndiName, (Object)"Connection");
        }
        return this.closed;
    }

    protected abstract WrappedStatement wrapStatement(Statement var1, boolean var2, String var3, boolean var4);

    @Override
    public Statement createStatement() throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] createStatement()", (Object)this.jndiName, (Object)"Connection");
                }
                Statement stmt = SecurityActions.executeInTccl(this.classLoaderPlugin.getClassLoader(), new SecurityActions.Producer<Statement>(){

                    @Override
                    public Statement produce() throws Exception {
                        return WrappedConnection.this.mc.getRealConnection().createStatement();
                    }
                });
                WrappedStatement wrappedStatement = this.wrapStatement(stmt, this.spy, this.jndiName, this.doLocking);
                return wrappedStatement;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public Statement createStatement(final int resultSetType, final int resultSetConcurrency) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] createStatement(%s, %s)", new Object[]{this.jndiName, "Connection", resultSetType, resultSetConcurrency});
                }
                Statement stmt = SecurityActions.executeInTccl(this.classLoaderPlugin.getClassLoader(), new SecurityActions.Producer<Statement>(){

                    @Override
                    public Statement produce() throws Exception {
                        return WrappedConnection.this.mc.getRealConnection().createStatement(resultSetType, resultSetConcurrency);
                    }
                });
                WrappedStatement wrappedStatement = this.wrapStatement(stmt, this.spy, this.jndiName, this.doLocking);
                return wrappedStatement;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public Statement createStatement(final int resultSetType, final int resultSetConcurrency, final int resultSetHoldability) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] createStatement(%s, %s, %s)", new Object[]{this.jndiName, "Connection", resultSetType, resultSetConcurrency, resultSetHoldability});
                }
                Statement stmt = SecurityActions.executeInTccl(this.classLoaderPlugin.getClassLoader(), new SecurityActions.Producer<Statement>(){

                    @Override
                    public Statement produce() throws Exception {
                        return WrappedConnection.this.mc.getRealConnection().createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
                    }
                });
                WrappedStatement wrappedStatement = this.wrapStatement(stmt, this.spy, this.jndiName, this.doLocking);
                return wrappedStatement;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    protected abstract WrappedPreparedStatement wrapPreparedStatement(PreparedStatement var1, boolean var2, String var3, boolean var4);

    @Override
    public PreparedStatement prepareStatement(final String sql) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] prepareStatement(%s)", (Object)this.jndiName, (Object)"Connection", (Object)sql);
                }
                PreparedStatement stmt = SecurityActions.executeInTccl(this.classLoaderPlugin.getClassLoader(), new SecurityActions.Producer<PreparedStatement>(){

                    @Override
                    public PreparedStatement produce() throws Exception {
                        return WrappedConnection.this.mc.prepareStatement(sql, 1003, 1007);
                    }
                });
                WrappedPreparedStatement wrappedPreparedStatement = this.wrapPreparedStatement(stmt, this.spy, this.jndiName, this.doLocking);
                return wrappedPreparedStatement;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public PreparedStatement prepareStatement(final String sql, final int resultSetType, final int resultSetConcurrency) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] prepareStatement(%s, %s, %s)", new Object[]{this.jndiName, "Connection", sql, resultSetType, resultSetConcurrency});
                }
                PreparedStatement stmt = SecurityActions.executeInTccl(this.classLoaderPlugin.getClassLoader(), new SecurityActions.Producer<PreparedStatement>(){

                    @Override
                    public PreparedStatement produce() throws Exception {
                        return WrappedConnection.this.mc.prepareStatement(sql, resultSetType, resultSetConcurrency);
                    }
                });
                WrappedPreparedStatement wrappedPreparedStatement = this.wrapPreparedStatement(stmt, this.spy, this.jndiName, this.doLocking);
                return wrappedPreparedStatement;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public PreparedStatement prepareStatement(final String sql, final int resultSetType, final int resultSetConcurrency, final int resultSetHoldability) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] prepareStatement(%s, %s, %s, %s)", new Object[]{this.jndiName, "Connection", sql, resultSetType, resultSetConcurrency, resultSetHoldability});
                }
                PreparedStatement stmt = SecurityActions.executeInTccl(this.classLoaderPlugin.getClassLoader(), new SecurityActions.Producer<PreparedStatement>(){

                    @Override
                    public PreparedStatement produce() throws Exception {
                        return WrappedConnection.this.mc.getRealConnection().prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
                    }
                });
                WrappedPreparedStatement wrappedPreparedStatement = this.wrapPreparedStatement(stmt, this.spy, this.jndiName, this.doLocking);
                return wrappedPreparedStatement;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public PreparedStatement prepareStatement(final String sql, final int autoGeneratedKeys) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] prepareStatement(%s, %s)", new Object[]{this.jndiName, "Connection", sql, autoGeneratedKeys});
                }
                PreparedStatement stmt = SecurityActions.executeInTccl(this.classLoaderPlugin.getClassLoader(), new SecurityActions.Producer<PreparedStatement>(){

                    @Override
                    public PreparedStatement produce() throws Exception {
                        return WrappedConnection.this.mc.getRealConnection().prepareStatement(sql, autoGeneratedKeys);
                    }
                });
                WrappedPreparedStatement wrappedPreparedStatement = this.wrapPreparedStatement(stmt, this.spy, this.jndiName, this.doLocking);
                return wrappedPreparedStatement;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public PreparedStatement prepareStatement(final String sql, final int[] columnIndexes) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] prepareStatement(%s, %s)", new Object[]{this.jndiName, "Connection", sql, Arrays.toString(columnIndexes)});
                }
                PreparedStatement stmt = SecurityActions.executeInTccl(this.classLoaderPlugin.getClassLoader(), new SecurityActions.Producer<PreparedStatement>(){

                    @Override
                    public PreparedStatement produce() throws Exception {
                        return WrappedConnection.this.mc.getRealConnection().prepareStatement(sql, columnIndexes);
                    }
                });
                WrappedPreparedStatement wrappedPreparedStatement = this.wrapPreparedStatement(stmt, this.spy, this.jndiName, this.doLocking);
                return wrappedPreparedStatement;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public PreparedStatement prepareStatement(final String sql, final String[] columnNames) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] prepareStatement(%s, %s)", new Object[]{this.jndiName, "Connection", sql, Arrays.toString(columnNames)});
                }
                PreparedStatement stmt = SecurityActions.executeInTccl(this.classLoaderPlugin.getClassLoader(), new SecurityActions.Producer<PreparedStatement>(){

                    @Override
                    public PreparedStatement produce() throws Exception {
                        return WrappedConnection.this.mc.getRealConnection().prepareStatement(sql, columnNames);
                    }
                });
                WrappedPreparedStatement wrappedPreparedStatement = this.wrapPreparedStatement(stmt, this.spy, this.jndiName, this.doLocking);
                return wrappedPreparedStatement;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    protected abstract WrappedCallableStatement wrapCallableStatement(CallableStatement var1, boolean var2, String var3, boolean var4);

    @Override
    public CallableStatement prepareCall(final String sql) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] prepareCall(%s)", (Object)this.jndiName, (Object)"Connection", (Object)sql);
                }
                CallableStatement stmt = SecurityActions.executeInTccl(this.classLoaderPlugin.getClassLoader(), new SecurityActions.Producer<CallableStatement>(){

                    @Override
                    public CallableStatement produce() throws Exception {
                        return WrappedConnection.this.mc.prepareCall(sql, 1003, 1007);
                    }
                });
                WrappedCallableStatement wrappedCallableStatement = this.wrapCallableStatement(stmt, this.spy, this.jndiName, this.doLocking);
                return wrappedCallableStatement;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public CallableStatement prepareCall(final String sql, final int resultSetType, final int resultSetConcurrency) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] prepareCall(%s, %s, %s)", new Object[]{this.jndiName, "Connection", sql, resultSetType, resultSetConcurrency});
                }
                CallableStatement stmt = SecurityActions.executeInTccl(this.classLoaderPlugin.getClassLoader(), new SecurityActions.Producer<CallableStatement>(){

                    @Override
                    public CallableStatement produce() throws Exception {
                        return WrappedConnection.this.mc.prepareCall(sql, resultSetType, resultSetConcurrency);
                    }
                });
                WrappedCallableStatement wrappedCallableStatement = this.wrapCallableStatement(stmt, this.spy, this.jndiName, this.doLocking);
                return wrappedCallableStatement;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public CallableStatement prepareCall(final String sql, final int resultSetType, final int resultSetConcurrency, final int resultSetHoldability) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] prepareCall(%s, %s, %s, %s)", new Object[]{this.jndiName, "Connection", sql, resultSetType, resultSetConcurrency, resultSetHoldability});
                }
                CallableStatement stmt = SecurityActions.executeInTccl(this.classLoaderPlugin.getClassLoader(), new SecurityActions.Producer<CallableStatement>(){

                    @Override
                    public CallableStatement produce() throws Exception {
                        return WrappedConnection.this.mc.getRealConnection().prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
                    }
                });
                WrappedCallableStatement wrappedCallableStatement = this.wrapCallableStatement(stmt, this.spy, this.jndiName, this.doLocking);
                return wrappedCallableStatement;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public String nativeSQL(final String sql) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] nativeSQL(%s)", (Object)this.jndiName, (Object)"Connection", (Object)sql);
                }
                String string = SecurityActions.executeInTccl(this.classLoaderPlugin.getClassLoader(), new SecurityActions.Producer<String>(){

                    @Override
                    public String produce() throws Exception {
                        return WrappedConnection.this.mc.getRealConnection().nativeSQL(sql);
                    }
                });
                return string;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public void setAutoCommit(boolean autocommit) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkStatus();
            if (this.spy) {
                spyLogger.debugf("%s [%s] setAutoCommit(%s)", (Object)this.jndiName, (Object)"Connection", (Object)autocommit);
            }
            this.mc.setJdbcAutoCommit(autocommit);
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkStatus();
            if (this.spy) {
                spyLogger.debugf("%s [%s] getAutoCommit()", (Object)this.jndiName, (Object)"Connection");
            }
            boolean bl = this.mc.isJdbcAutoCommit();
            return bl;
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public void commit() throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] commit()", (Object)this.jndiName, (Object)"Connection");
                }
                this.mc.jdbcCommit();
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public void rollback() throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] rollback()", (Object)this.jndiName, (Object)"Connection");
                }
                this.mc.jdbcRollback();
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] rollback(%s)", (Object)this.jndiName, (Object)"Connection", (Object)savepoint);
                }
                this.mc.jdbcRollback(savepoint);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getMetaData()", (Object)this.jndiName, (Object)"Connection");
                }
                DatabaseMetaData databaseMetaData = this.mc.getRealConnection().getMetaData();
                return databaseMetaData;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setCatalog(%s)", (Object)this.jndiName, (Object)"Connection", (Object)catalog);
                }
                this.mc.getRealConnection().setCatalog(catalog);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public String getCatalog() throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getCatalog()", (Object)this.jndiName, (Object)"Connection");
                }
                String string = this.mc.getRealConnection().getCatalog();
                return string;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public void setTransactionIsolation(int isolationLevel) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkStatus();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setTransactionIsolation(%s)", (Object)this.jndiName, (Object)"Connection", (Object)isolationLevel);
                }
                this.mc.setJdbcTransactionIsolation(isolationLevel);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkStatus();
            if (this.spy) {
                spyLogger.debugf("%s [%s] getTransactionIsolation()", (Object)this.jndiName, (Object)"Connection");
            }
            int n = this.mc.getJdbcTransactionIsolation();
            return n;
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getWarnings()", (Object)this.jndiName, (Object)"Connection");
                }
                SQLWarning sQLWarning = this.mc.getRealConnection().getWarnings();
                return sQLWarning;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] clearWarnings()", (Object)this.jndiName, (Object)"Connection");
                }
                this.mc.getRealConnection().clearWarnings();
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getTypeMap()", (Object)this.jndiName, (Object)"Connection");
                }
                Map<String, Class<?>> map = this.mc.getRealConnection().getTypeMap();
                return map;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> typeMap) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setTypeMap(%s)", (Object)this.jndiName, (Object)"Connection", typeMap);
                }
                this.mc.getRealConnection().setTypeMap(typeMap);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setHoldability(%s)", (Object)this.jndiName, (Object)"Connection", (Object)holdability);
                }
                this.mc.getRealConnection().setHoldability(holdability);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getHoldability()", (Object)this.jndiName, (Object)"Connection");
                }
                int n = this.mc.getRealConnection().getHoldability();
                return n;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setSavepoint()", (Object)this.jndiName, (Object)"Connection");
                }
                Savepoint savepoint = this.mc.getRealConnection().setSavepoint();
                return savepoint;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setSavepoint(%s)", (Object)this.jndiName, (Object)"Connection", (Object)name);
                }
                Savepoint savepoint = this.mc.getRealConnection().setSavepoint(name);
                return savepoint;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] releaseSavepoint(%s)", (Object)this.jndiName, (Object)"Connection", (Object)savepoint);
                }
                this.mc.getRealConnection().releaseSavepoint(savepoint);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] createArrayOf(%s, %s)", new Object[]{this.jndiName, "Connection", typeName, Arrays.toString(elements)});
                }
                Array array = this.mc.getRealConnection().createArrayOf(typeName, elements);
                return array;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public Blob createBlob() throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] createBlob()", (Object)this.jndiName, (Object)"Connection");
                }
                Blob blob = this.mc.getRealConnection().createBlob();
                return blob;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public Clob createClob() throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] createClob()", (Object)this.jndiName, (Object)"Connection");
                }
                Clob clob = this.mc.getRealConnection().createClob();
                return clob;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public NClob createNClob() throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] createNClob()", (Object)this.jndiName, (Object)"Connection");
                }
                NClob nClob = this.mc.getRealConnection().createNClob();
                return nClob;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] createSQLXML()", (Object)this.jndiName, (Object)"Connection");
                }
                SQLXML sQLXML = this.mc.getRealConnection().createSQLXML();
                return sQLXML;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] createStruct(%s, %s)", new Object[]{this.jndiName, "Connection", typeName, Arrays.toString(attributes)});
                }
                Struct struct = this.mc.getRealConnection().createStruct(typeName, attributes);
                return struct;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getClientInfo()", (Object)this.jndiName, (Object)"Connection");
                }
                Properties properties = this.mc.getRealConnection().getClientInfo();
                return properties;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getClientInfo(%s)", (Object)this.jndiName, (Object)"Connection", (Object)name);
                }
                String string = this.mc.getRealConnection().getClientInfo(name);
                return string;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkStatus();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] isValid(%s)", (Object)this.jndiName, (Object)"Connection", (Object)timeout);
                }
                boolean bl = this.mc.getRealConnection().isValid(timeout);
                return bl;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        try {
            if (this.doLocking) {
                this.lock();
            }
            try {
                this.checkTransaction();
                try {
                    if (this.spy) {
                        spyLogger.debugf("%s [%s] setClientInfo(%s)", (Object)this.jndiName, (Object)"Connection", (Object)properties);
                    }
                    this.mc.getRealConnection().setClientInfo(properties);
                }
                catch (Throwable t) {
                    try {
                        this.checkException(t);
                    }
                    catch (SQLClientInfoException e) {
                        throw e;
                    }
                    catch (SQLException e) {
                        SQLClientInfoException scie = new SQLClientInfoException();
                        scie.initCause(e);
                        throw scie;
                    }
                }
            }
            finally {
                if (this.doLocking) {
                    this.unlock();
                }
            }
        }
        catch (SQLClientInfoException e) {
            throw e;
        }
        catch (SQLException e) {
            SQLClientInfoException t = new SQLClientInfoException();
            t.initCause(e);
            throw t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        try {
            if (this.doLocking) {
                this.lock();
            }
            try {
                this.checkTransaction();
                try {
                    if (this.spy) {
                        spyLogger.debugf("%s [%s] setClientInfo(%s, %s)", new Object[]{this.jndiName, "Connection", name, value});
                    }
                    this.mc.getRealConnection().setClientInfo(name, value);
                }
                catch (Throwable t) {
                    try {
                        this.checkException(t);
                    }
                    catch (SQLClientInfoException e) {
                        throw e;
                    }
                    catch (SQLException e) {
                        SQLClientInfoException scie = new SQLClientInfoException();
                        scie.initCause(e);
                        throw scie;
                    }
                }
            }
            finally {
                if (this.doLocking) {
                    this.unlock();
                }
            }
        }
        catch (SQLClientInfoException e) {
            throw e;
        }
        catch (SQLException e) {
            SQLClientInfoException t = new SQLClientInfoException();
            t.initCause(e);
            throw t;
        }
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setSchema(%s)", (Object)this.jndiName, (Object)"Connection", (Object)schema);
                }
                this.mc.getRealConnection().setSchema(schema);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public String getSchema() throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getSchema()", (Object)this.jndiName, (Object)"Connection");
                }
                String string = this.mc.getRealConnection().getSchema();
                return string;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] abort(%s)", (Object)this.jndiName, (Object)"Connection", (Object)executor);
                }
                this.mc.getRealConnection().abort(executor);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setNetworkTimeout(%s, %s)", new Object[]{this.jndiName, "Connection", executor, milliseconds});
                }
                this.mc.getRealConnection().setNetworkTimeout(executor, milliseconds);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getNetworkTimeout()", (Object)this.jndiName, (Object)"Connection");
                }
                int n = this.mc.getRealConnection().getNetworkTimeout();
                return n;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    public Connection getUnderlyingConnection() throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            Connection connection = this.mc.getRealConnection();
            return connection;
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    public boolean isXA() {
        return this.mc.isXA();
    }

    public XAResource getXAResource() throws ResourceException {
        return this.mc.getXAResource();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        this.checkStatus();
        return super.isWrapperFor(iface);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        this.checkStatus();
        this.mc.checkTransaction();
        return super.unwrap(iface);
    }

    @Override
    protected Connection getWrappedObject() throws SQLException {
        return this.mc.getRealConnection();
    }

    protected void checkTransaction() throws SQLException {
        this.checkStatus();
        this.mc.checkTransaction();
    }

    void checkTransactionActive() throws SQLException {
        if (this.dataSource == null) {
            return;
        }
        this.dataSource.checkTransactionActive();
    }

    protected void checkStatus() throws SQLException {
        if (this.closed) {
            throw new SQLException(bundle.connectionClosed());
        }
        if (this.mc == null) {
            throw new SQLException(bundle.connectionNotAssociated(this.toString()));
        }
        this.checkTransactionActive();
    }

    protected SQLException checkException(Throwable t) throws SQLException {
        Throwable result = t;
        if (result instanceof AbstractMethodError) {
            result = new SQLFeatureNotSupportedException(bundle.methodNotImplemented(), result);
        }
        if (this.mc != null) {
            result = this.mc.connectionError(result);
        }
        if (result instanceof SQLException) {
            throw (SQLException)result;
        }
        throw new SQLException("Error", result);
    }

    int getTrackStatements() {
        return this.trackStatements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerStatement(WrappedStatement ws) {
        if (this.trackStatements == 0) {
            return;
        }
        WrappedConnection wrappedConnection = this;
        synchronized (wrappedConnection) {
            if (this.statements == null) {
                this.statements = new HashMap(1);
            }
            if (this.trackStatements == 1) {
                this.statements.put(ws, new Throwable("STACKTRACE"));
            } else {
                this.statements.put(ws, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterStatement(WrappedStatement ws) {
        if (this.trackStatements == 0) {
            return;
        }
        WrappedConnection wrappedConnection = this;
        synchronized (wrappedConnection) {
            if (this.statements != null) {
                this.statements.remove(ws);
            }
        }
    }

    void checkConfiguredQueryTimeout(WrappedStatement ws, int explicitTimeout) throws SQLException {
        if (this.mc == null || this.dataSource == null) {
            return;
        }
        int timeout = 0;
        if (this.mc.isTransactionQueryTimeout() && (timeout = this.dataSource.getTimeLeftBeforeTransactionTimeout()) > 0 && explicitTimeout > 0 && timeout > explicitTimeout) {
            timeout = explicitTimeout;
        }
        if (timeout <= 0 && explicitTimeout <= 0) {
            timeout = this.mc.getQueryTimeout();
        }
        if (timeout > 0) {
            ws.setQueryTimeout(timeout);
        }
    }

    AdaptersLogger getLogger() {
        return log;
    }
}

