/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.adapter;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserModelDefaultMethods;
import org.keycloak.models.utils.DefaultRoles;
import org.keycloak.models.utils.RoleUtils;
import org.keycloak.storage.StorageId;
import org.keycloak.storage.federated.UserFederatedStorageProvider;

public abstract class AbstractUserAdapterFederatedStorage
extends UserModelDefaultMethods {
    public static String FIRST_NAME_ATTRIBUTE = "FIRST_NAME";
    public static String LAST_NAME_ATTRIBUTE = "LAST_NAME";
    public static String EMAIL_ATTRIBUTE = "EMAIL";
    public static String EMAIL_VERIFIED_ATTRIBUTE = "EMAIL_VERIFIED";
    public static String CREATED_TIMESTAMP_ATTRIBUTE = "CREATED_TIMESTAMP";
    public static String ENABLED_ATTRIBUTE = "ENABLED";
    protected KeycloakSession session;
    protected RealmModel realm;
    protected ComponentModel storageProviderModel;
    protected StorageId storageId;

    public AbstractUserAdapterFederatedStorage(KeycloakSession session, RealmModel realm, ComponentModel storageProviderModel) {
        this.session = session;
        this.realm = realm;
        this.storageProviderModel = storageProviderModel;
    }

    public UserFederatedStorageProvider getFederatedStorage() {
        return this.session.userFederatedStorage();
    }

    @Override
    public Set<String> getRequiredActions() {
        return this.getFederatedStorage().getRequiredActions(this.realm, this.getId());
    }

    @Override
    public void addRequiredAction(String action) {
        this.getFederatedStorage().addRequiredAction(this.realm, this.getId(), action);
    }

    @Override
    public void removeRequiredAction(String action) {
        this.getFederatedStorage().removeRequiredAction(this.realm, this.getId(), action);
    }

    @Override
    public void addRequiredAction(UserModel.RequiredAction action) {
        this.getFederatedStorage().addRequiredAction(this.realm, this.getId(), action.name());
    }

    @Override
    public void removeRequiredAction(UserModel.RequiredAction action) {
        this.getFederatedStorage().removeRequiredAction(this.realm, this.getId(), action.name());
    }

    protected Set<GroupModel> getGroupsInternal() {
        return Collections.emptySet();
    }

    protected boolean appendDefaultGroups() {
        return true;
    }

    @Override
    public Set<GroupModel> getGroups() {
        HashSet<GroupModel> set = new HashSet<GroupModel>(this.getFederatedStorage().getGroups(this.realm, this.getId()));
        if (this.appendDefaultGroups()) {
            set.addAll(this.realm.getDefaultGroups());
        }
        set.addAll(this.getGroupsInternal());
        return set;
    }

    @Override
    public void joinGroup(GroupModel group) {
        this.getFederatedStorage().joinGroup(this.realm, this.getId(), group);
    }

    @Override
    public void leaveGroup(GroupModel group) {
        this.getFederatedStorage().leaveGroup(this.realm, this.getId(), group);
    }

    @Override
    public boolean isMemberOf(GroupModel group) {
        Set<GroupModel> roles = this.getGroups();
        return RoleUtils.isMember(roles, group);
    }

    @Override
    public Set<RoleModel> getRealmRoleMappings() {
        Set<RoleModel> roleMappings = this.getRoleMappings();
        HashSet<RoleModel> realmRoles = new HashSet<RoleModel>();
        for (RoleModel role : roleMappings) {
            RoleContainerModel container = role.getContainer();
            if (!(container instanceof RealmModel)) continue;
            realmRoles.add(role);
        }
        return realmRoles;
    }

    @Override
    public Set<RoleModel> getClientRoleMappings(ClientModel app) {
        Set<RoleModel> roleMappings = this.getRoleMappings();
        HashSet<RoleModel> roles = new HashSet<RoleModel>();
        for (RoleModel role : roleMappings) {
            ClientModel appModel;
            RoleContainerModel container = role.getContainer();
            if (!(container instanceof ClientModel) || !(appModel = (ClientModel)container).getId().equals(app.getId())) continue;
            roles.add(role);
        }
        return roles;
    }

    @Override
    public boolean hasRole(RoleModel role) {
        Set<RoleModel> roles = this.getRoleMappings();
        return RoleUtils.hasRole(roles, role) || RoleUtils.hasRoleFromGroup(this.getGroups(), role, true);
    }

    @Override
    public void grantRole(RoleModel role) {
        this.getFederatedStorage().grantRole(this.realm, this.getId(), role);
    }

    protected boolean appendDefaultRolesToRoleMappings() {
        return true;
    }

    protected Set<RoleModel> getRoleMappingsInternal() {
        return Collections.emptySet();
    }

    @Override
    public Set<RoleModel> getRoleMappings() {
        HashSet<RoleModel> set = new HashSet<RoleModel>(this.getFederatedRoleMappings());
        if (this.appendDefaultRolesToRoleMappings()) {
            set.addAll(DefaultRoles.getDefaultRoles(this.realm));
        }
        set.addAll(this.getRoleMappingsInternal());
        return set;
    }

    protected Set<RoleModel> getFederatedRoleMappings() {
        return this.getFederatedStorage().getRoleMappings(this.realm, this.getId());
    }

    @Override
    public void deleteRoleMapping(RoleModel role) {
        this.getFederatedStorage().deleteRoleMapping(this.realm, this.getId(), role);
    }

    @Override
    public boolean isEnabled() {
        String val = this.getFirstAttribute(ENABLED_ATTRIBUTE);
        if (val == null) {
            return true;
        }
        return Boolean.valueOf(val);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.setSingleAttribute(ENABLED_ATTRIBUTE, Boolean.toString(enabled));
    }

    @Override
    public String getFederationLink() {
        return null;
    }

    @Override
    public void setFederationLink(String link) {
    }

    @Override
    public String getServiceAccountClientLink() {
        return null;
    }

    @Override
    public void setServiceAccountClientLink(String clientInternalId) {
    }

    @Override
    public String getId() {
        if (this.storageId == null) {
            this.storageId = new StorageId(this.storageProviderModel.getId(), this.getUsername());
        }
        return this.storageId.getId();
    }

    @Override
    public Long getCreatedTimestamp() {
        String val = this.getFirstAttribute(CREATED_TIMESTAMP_ATTRIBUTE);
        if (val == null) {
            return null;
        }
        return Long.valueOf(val);
    }

    @Override
    public void setCreatedTimestamp(Long timestamp) {
        if (timestamp == null) {
            this.setSingleAttribute(CREATED_TIMESTAMP_ATTRIBUTE, null);
        } else {
            this.setSingleAttribute(CREATED_TIMESTAMP_ATTRIBUTE, Long.toString(timestamp));
        }
    }

    @Override
    public void setSingleAttribute(String name, String value) {
        if ("username".equals(name)) {
            this.setUsername(value);
        } else {
            this.getFederatedStorage().setSingleAttribute(this.realm, this.getId(), this.mapAttribute(name), value);
        }
    }

    @Override
    public void removeAttribute(String name) {
        this.getFederatedStorage().removeAttribute(this.realm, this.getId(), name);
    }

    @Override
    public void setAttribute(String name, List<String> values) {
        if ("username".equals(name)) {
            this.setUsername(values != null && values.size() > 0 ? values.get(0) : null);
        } else {
            this.getFederatedStorage().setAttribute(this.realm, this.getId(), this.mapAttribute(name), values);
        }
    }

    @Override
    public String getFirstAttribute(String name) {
        if ("username".equals(name)) {
            return this.getUsername();
        }
        return (String)this.getFederatedStorage().getAttributes(this.realm, this.getId()).getFirst((Object)this.mapAttribute(name));
    }

    @Override
    public Map<String, List<String>> getAttributes() {
        List firstName;
        MultivaluedHashMap attributes = this.getFederatedStorage().getAttributes(this.realm, this.getId());
        if (attributes == null) {
            attributes = new MultivaluedHashMap();
        }
        attributes.add((Object)"firstName", (firstName = (List)attributes.remove((Object)FIRST_NAME_ATTRIBUTE)) != null && firstName.size() >= 1 ? (String)firstName.get(0) : null);
        List lastName = (List)attributes.remove((Object)LAST_NAME_ATTRIBUTE);
        attributes.add((Object)"lastName", lastName != null && lastName.size() >= 1 ? (String)lastName.get(0) : null);
        List email = (List)attributes.remove((Object)EMAIL_ATTRIBUTE);
        attributes.add((Object)"email", email != null && email.size() >= 1 ? (String)email.get(0) : null);
        attributes.add((Object)"username", (Object)this.getUsername());
        return attributes;
    }

    @Override
    public List<String> getAttribute(String name) {
        if ("username".equals(name)) {
            return Collections.singletonList(this.getUsername());
        }
        List result = (List)this.getFederatedStorage().getAttributes(this.realm, this.getId()).get((Object)this.mapAttribute(name));
        return result == null ? Collections.emptyList() : result;
    }

    private String mapAttribute(String attributeName) {
        if ("firstName".equals(attributeName)) {
            return FIRST_NAME_ATTRIBUTE;
        }
        if ("lastName".equals(attributeName)) {
            return LAST_NAME_ATTRIBUTE;
        }
        if ("email".equals(attributeName)) {
            return EMAIL_ATTRIBUTE;
        }
        return attributeName;
    }

    @Override
    public boolean isEmailVerified() {
        String val = this.getFirstAttribute(EMAIL_VERIFIED_ATTRIBUTE);
        if (val == null) {
            return false;
        }
        return Boolean.valueOf(val);
    }

    @Override
    public void setEmailVerified(boolean verified) {
        this.setSingleAttribute(EMAIL_VERIFIED_ATTRIBUTE, Boolean.toString(verified));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof UserModel)) {
            return false;
        }
        UserModel that = (UserModel)o;
        return that.getId().equals(this.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }
}

