/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.jpa;

import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.jpa.ClientScopeAdapter;
import org.keycloak.models.jpa.JpaModel;
import org.keycloak.models.jpa.RoleAdapter;
import org.keycloak.models.jpa.entities.ClientAttributeEntity;
import org.keycloak.models.jpa.entities.ClientEntity;
import org.keycloak.models.jpa.entities.ClientScopeClientMappingEntity;
import org.keycloak.models.jpa.entities.ProtocolMapperEntity;
import org.keycloak.models.jpa.entities.RoleEntity;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.provider.ProviderEvent;

public class ClientAdapter
implements ClientModel,
JpaModel<ClientEntity> {
    protected KeycloakSession session;
    protected RealmModel realm;
    protected EntityManager em;
    protected ClientEntity entity;

    public ClientAdapter(RealmModel realm, EntityManager em, KeycloakSession session, ClientEntity entity) {
        this.session = session;
        this.realm = realm;
        this.em = em;
        this.entity = entity;
    }

    @Override
    public ClientEntity getEntity() {
        return this.entity;
    }

    public String getId() {
        return this.entity.getId();
    }

    public RealmModel getRealm() {
        return this.realm;
    }

    public String getName() {
        return this.entity.getName();
    }

    public void setName(String name) {
        this.entity.setName(name);
    }

    public String getDescription() {
        return this.entity.getDescription();
    }

    public void setDescription(String description) {
        this.entity.setDescription(description);
    }

    public boolean isEnabled() {
        return this.entity.isEnabled();
    }

    public void setEnabled(boolean enabled) {
        this.entity.setEnabled(enabled);
    }

    public boolean isAlwaysDisplayInConsole() {
        return this.entity.isAlwaysDisplayInConsole();
    }

    public void setAlwaysDisplayInConsole(boolean alwaysDisplayInConsole) {
        this.entity.setAlwaysDisplayInConsole(alwaysDisplayInConsole);
    }

    public boolean isPublicClient() {
        return this.entity.isPublicClient();
    }

    public void setPublicClient(boolean flag) {
        this.entity.setPublicClient(flag);
    }

    public boolean isFrontchannelLogout() {
        return this.entity.isFrontchannelLogout();
    }

    public void setFrontchannelLogout(boolean flag) {
        this.entity.setFrontchannelLogout(flag);
    }

    public boolean isFullScopeAllowed() {
        return this.entity.isFullScopeAllowed();
    }

    public void setFullScopeAllowed(boolean value) {
        this.entity.setFullScopeAllowed(value);
    }

    public Set<String> getWebOrigins() {
        HashSet<String> result = new HashSet<String>();
        result.addAll(this.entity.getWebOrigins());
        return result;
    }

    public void setWebOrigins(Set<String> webOrigins) {
        this.entity.setWebOrigins(webOrigins);
    }

    public void addWebOrigin(String webOrigin) {
        this.entity.getWebOrigins().add(webOrigin);
    }

    public void removeWebOrigin(String webOrigin) {
        this.entity.getWebOrigins().remove(webOrigin);
    }

    public Set<String> getRedirectUris() {
        HashSet<String> result = new HashSet<String>();
        result.addAll(this.entity.getRedirectUris());
        return result;
    }

    public void setRedirectUris(Set<String> redirectUris) {
        this.entity.setRedirectUris(redirectUris);
    }

    public void addRedirectUri(String redirectUri) {
        this.entity.getRedirectUris().add(redirectUri);
    }

    public void removeRedirectUri(String redirectUri) {
        this.entity.getRedirectUris().remove(redirectUri);
    }

    public String getClientAuthenticatorType() {
        return this.entity.getClientAuthenticatorType();
    }

    public void setClientAuthenticatorType(String clientAuthenticatorType) {
        this.entity.setClientAuthenticatorType(clientAuthenticatorType);
    }

    public String getSecret() {
        return this.entity.getSecret();
    }

    public void setSecret(String secret) {
        this.entity.setSecret(secret);
    }

    public String getRegistrationToken() {
        return this.entity.getRegistrationToken();
    }

    public void setRegistrationToken(String registrationToken) {
        this.entity.setRegistrationToken(registrationToken);
    }

    public boolean validateSecret(String secret) {
        return MessageDigest.isEqual(secret.getBytes(), this.entity.getSecret().getBytes());
    }

    public int getNotBefore() {
        return this.entity.getNotBefore();
    }

    public void setNotBefore(int notBefore) {
        this.entity.setNotBefore(notBefore);
    }

    public Set<RoleModel> getRealmScopeMappings() {
        Set roleMappings = this.getScopeMappings();
        HashSet<RoleModel> appRoles = new HashSet<RoleModel>();
        for (RoleModel role : roleMappings) {
            RoleContainerModel container = role.getContainer();
            if (!(container instanceof RealmModel) || !((RealmModel)container).getId().equals(this.realm.getId())) continue;
            appRoles.add(role);
        }
        return appRoles;
    }

    public Stream<RoleModel> getScopeMappingsStream() {
        return this.getEntity().getScopeMapping().stream().map(RoleEntity::getId).map(arg_0 -> ((RealmModel)this.realm).getRoleById(arg_0)).filter(Objects::nonNull);
    }

    public void addScopeMapping(RoleModel role) {
        RoleEntity roleEntity = RoleAdapter.toRoleEntity(role, this.em);
        this.getEntity().getScopeMapping().add(roleEntity);
    }

    public void deleteScopeMapping(RoleModel role) {
        this.getEntity().getScopeMapping().remove(RoleAdapter.toRoleEntity(role, this.em));
    }

    public String getProtocol() {
        return this.entity.getProtocol();
    }

    public void setProtocol(String protocol) {
        this.entity.setProtocol(protocol);
    }

    public void setAuthenticationFlowBindingOverride(String name, String value) {
        this.entity.getAuthFlowBindings().put(name, value);
    }

    public void removeAuthenticationFlowBindingOverride(String name) {
        this.entity.getAuthFlowBindings().remove(name);
    }

    public String getAuthenticationFlowBindingOverride(String name) {
        return this.entity.getAuthFlowBindings().get(name);
    }

    public Map<String, String> getAuthenticationFlowBindingOverrides() {
        HashMap<String, String> copy = new HashMap<String, String>();
        copy.putAll(this.entity.getAuthFlowBindings());
        return copy;
    }

    public void setAttribute(String name, String value) {
        for (ClientAttributeEntity attr : this.entity.getAttributes()) {
            if (!attr.getName().equals(name)) continue;
            attr.setValue(value);
            return;
        }
        ClientAttributeEntity attr = new ClientAttributeEntity();
        attr.setName(name);
        attr.setValue(value);
        attr.setClient(this.entity);
        this.em.persist((Object)attr);
        this.entity.getAttributes().add(attr);
    }

    public void removeAttribute(String name) {
        Iterator<ClientAttributeEntity> it = this.entity.getAttributes().iterator();
        while (it.hasNext()) {
            ClientAttributeEntity attr = it.next();
            if (!attr.getName().equals(name)) continue;
            it.remove();
            this.em.remove((Object)attr);
        }
    }

    public String getAttribute(String name) {
        return this.getAttributes().get(name);
    }

    public Map<String, String> getAttributes() {
        HashMap<String, String> attrs = new HashMap<String, String>();
        for (ClientAttributeEntity attr : this.entity.getAttributes()) {
            attrs.put(attr.getName(), attr.getValue());
        }
        return attrs;
    }

    public void addClientScope(ClientScopeModel clientScope, boolean defaultScope) {
        if (this.getClientScopes(defaultScope, false).containsKey(clientScope.getName())) {
            return;
        }
        this.persist(clientScope, defaultScope);
    }

    public void addClientScopes(Set<ClientScopeModel> clientScopes, boolean defaultScope) {
        Map<String, ClientScopeModel> existingClientScopes = this.getClientScopes(defaultScope, false);
        clientScopes.stream().filter(clientScope -> !existingClientScopes.containsKey(clientScope.getName())).forEach(clientScope -> this.persist((ClientScopeModel)clientScope, defaultScope));
    }

    private void persist(ClientScopeModel clientScope, boolean defaultScope) {
        ClientScopeClientMappingEntity entity = new ClientScopeClientMappingEntity();
        entity.setClientScope(ClientScopeAdapter.toClientScopeEntity(clientScope, this.em));
        entity.setClient(this.getEntity());
        entity.setDefaultScope(defaultScope);
        this.em.persist((Object)entity);
        this.em.flush();
        this.em.detach((Object)entity);
    }

    public void removeClientScope(ClientScopeModel clientScope) {
        int numRemoved = this.em.createNamedQuery("deleteClientScopeClientMapping").setParameter("clientScope", (Object)ClientScopeAdapter.toClientScopeEntity(clientScope, this.em)).setParameter("client", (Object)this.getEntity()).executeUpdate();
        this.em.flush();
    }

    public Map<String, ClientScopeModel> getClientScopes(boolean defaultScope, boolean filterByProtocol) {
        TypedQuery query = this.em.createNamedQuery("clientScopeClientMappingIdsByClient", String.class);
        query.setParameter("client", (Object)this.getEntity());
        query.setParameter("defaultScope", (Object)defaultScope);
        List ids = query.getResultList();
        String clientProtocol = this.getProtocol() == null ? "openid-connect" : this.getProtocol();
        HashMap<String, ClientScopeModel> clientScopes = new HashMap<String, ClientScopeModel>();
        for (String clientScopeId : ids) {
            ClientScopeModel clientScope = this.realm.getClientScopeById(clientScopeId);
            if (clientScope == null || filterByProtocol && !clientScope.getProtocol().equals(clientProtocol)) continue;
            clientScopes.put(clientScope.getName(), clientScope);
        }
        return clientScopes;
    }

    public static boolean contains(String str, String[] array) {
        for (String s : array) {
            if (!str.equals(s)) continue;
            return true;
        }
        return false;
    }

    public Set<ProtocolMapperModel> getProtocolMappers() {
        HashSet<ProtocolMapperModel> mappings = new HashSet<ProtocolMapperModel>();
        for (ProtocolMapperEntity entity : this.entity.getProtocolMappers()) {
            ProtocolMapperModel mapping = new ProtocolMapperModel();
            mapping.setId(entity.getId());
            mapping.setName(entity.getName());
            mapping.setProtocol(entity.getProtocol());
            mapping.setProtocolMapper(entity.getProtocolMapper());
            HashMap<String, String> config = new HashMap<String, String>();
            if (entity.getConfig() != null) {
                config.putAll(entity.getConfig());
            }
            mapping.setConfig(config);
            mappings.add(mapping);
        }
        return mappings;
    }

    public ProtocolMapperModel addProtocolMapper(ProtocolMapperModel model) {
        if (this.getProtocolMapperByName(model.getProtocol(), model.getName()) != null) {
            throw new ModelDuplicateException("Protocol mapper name must be unique per protocol");
        }
        String id = model.getId() != null ? model.getId() : KeycloakModelUtils.generateId();
        ProtocolMapperEntity entity = new ProtocolMapperEntity();
        entity.setId(id);
        entity.setName(model.getName());
        entity.setProtocol(model.getProtocol());
        entity.setProtocolMapper(model.getProtocolMapper());
        entity.setClient(this.entity);
        entity.setConfig(model.getConfig());
        this.em.persist((Object)entity);
        this.entity.getProtocolMappers().add(entity);
        return this.entityToModel(entity);
    }

    protected ProtocolMapperEntity getProtocolMapperEntity(String id) {
        for (ProtocolMapperEntity entity : this.entity.getProtocolMappers()) {
            if (!entity.getId().equals(id)) continue;
            return entity;
        }
        return null;
    }

    protected ProtocolMapperEntity getProtocolMapperEntityByName(String protocol, String name) {
        for (ProtocolMapperEntity entity : this.entity.getProtocolMappers()) {
            if (!entity.getProtocol().equals(protocol) || !entity.getName().equals(name)) continue;
            return entity;
        }
        return null;
    }

    public void removeProtocolMapper(ProtocolMapperModel mapping) {
        ProtocolMapperEntity toDelete = this.getProtocolMapperEntity(mapping.getId());
        if (toDelete != null) {
            this.session.users().preRemove(mapping);
            this.entity.getProtocolMappers().remove(toDelete);
            this.em.remove((Object)toDelete);
        }
    }

    public void updateProtocolMapper(ProtocolMapperModel mapping) {
        ProtocolMapperEntity entity = this.getProtocolMapperEntity(mapping.getId());
        entity.setProtocolMapper(mapping.getProtocolMapper());
        if (entity.getConfig() == null) {
            entity.setConfig(mapping.getConfig());
        } else {
            entity.getConfig().clear();
            entity.getConfig().putAll(mapping.getConfig());
        }
        this.em.flush();
    }

    public ProtocolMapperModel getProtocolMapperById(String id) {
        ProtocolMapperEntity entity = this.getProtocolMapperEntity(id);
        if (entity == null) {
            return null;
        }
        return this.entityToModel(entity);
    }

    public ProtocolMapperModel getProtocolMapperByName(String protocol, String name) {
        ProtocolMapperEntity entity = this.getProtocolMapperEntityByName(protocol, name);
        if (entity == null) {
            return null;
        }
        return this.entityToModel(entity);
    }

    protected ProtocolMapperModel entityToModel(ProtocolMapperEntity entity) {
        ProtocolMapperModel mapping = new ProtocolMapperModel();
        mapping.setId(entity.getId());
        mapping.setName(entity.getName());
        mapping.setProtocol(entity.getProtocol());
        mapping.setProtocolMapper(entity.getProtocolMapper());
        HashMap<String, String> config = new HashMap<String, String>();
        if (entity.getConfig() != null) {
            config.putAll(entity.getConfig());
        }
        mapping.setConfig(config);
        return mapping;
    }

    public void updateClient() {
        this.em.flush();
        this.session.getKeycloakSessionFactory().publish((ProviderEvent)new RealmModel.ClientUpdatedEvent(){

            public ClientModel getUpdatedClient() {
                return ClientAdapter.this;
            }

            public KeycloakSession getKeycloakSession() {
                return ClientAdapter.this.session;
            }
        });
    }

    public String getClientId() {
        return this.entity.getClientId();
    }

    public void setClientId(String clientId) {
        this.entity.setClientId(clientId);
    }

    public boolean isSurrogateAuthRequired() {
        return this.entity.isSurrogateAuthRequired();
    }

    public void setSurrogateAuthRequired(boolean surrogateAuthRequired) {
        this.entity.setSurrogateAuthRequired(surrogateAuthRequired);
    }

    public String getManagementUrl() {
        return this.entity.getManagementUrl();
    }

    public void setManagementUrl(String url) {
        this.entity.setManagementUrl(url);
    }

    public String getRootUrl() {
        return this.entity.getRootUrl();
    }

    public void setRootUrl(String url) {
        this.entity.setRootUrl(url);
    }

    public String getBaseUrl() {
        return this.entity.getBaseUrl();
    }

    public void setBaseUrl(String url) {
        this.entity.setBaseUrl(url);
    }

    public boolean isBearerOnly() {
        return this.entity.isBearerOnly();
    }

    public void setBearerOnly(boolean only) {
        this.entity.setBearerOnly(only);
    }

    public boolean isConsentRequired() {
        return this.entity.isConsentRequired();
    }

    public void setConsentRequired(boolean consentRequired) {
        this.entity.setConsentRequired(consentRequired);
    }

    public boolean isStandardFlowEnabled() {
        return this.entity.isStandardFlowEnabled();
    }

    public void setStandardFlowEnabled(boolean standardFlowEnabled) {
        this.entity.setStandardFlowEnabled(standardFlowEnabled);
    }

    public boolean isImplicitFlowEnabled() {
        return this.entity.isImplicitFlowEnabled();
    }

    public void setImplicitFlowEnabled(boolean implicitFlowEnabled) {
        this.entity.setImplicitFlowEnabled(implicitFlowEnabled);
    }

    public boolean isDirectAccessGrantsEnabled() {
        return this.entity.isDirectAccessGrantsEnabled();
    }

    public void setDirectAccessGrantsEnabled(boolean directAccessGrantsEnabled) {
        this.entity.setDirectAccessGrantsEnabled(directAccessGrantsEnabled);
    }

    public boolean isServiceAccountsEnabled() {
        return this.entity.isServiceAccountsEnabled();
    }

    public void setServiceAccountsEnabled(boolean serviceAccountsEnabled) {
        this.entity.setServiceAccountsEnabled(serviceAccountsEnabled);
    }

    public RoleModel getRole(String name) {
        return this.session.realms().getClientRole(this.realm, (ClientModel)this, name);
    }

    public RoleModel addRole(String name) {
        return this.session.realms().addClientRole(this.realm, (ClientModel)this, name);
    }

    public RoleModel addRole(String id, String name) {
        return this.session.realms().addClientRole(this.realm, (ClientModel)this, id, name);
    }

    public boolean removeRole(RoleModel roleModel) {
        return this.session.realms().removeRole(this.realm, roleModel);
    }

    public Set<RoleModel> getRoles() {
        return this.session.realms().getClientRoles(this.realm, (ClientModel)this);
    }

    public Set<RoleModel> getRoles(Integer first, Integer max) {
        return this.session.realms().getClientRoles(this.realm, (ClientModel)this, first, max);
    }

    public Set<RoleModel> searchForRoles(String search, Integer first, Integer max) {
        return this.session.realms().searchForClientRoles(this.realm, (ClientModel)this, search, first, max);
    }

    public boolean hasScope(RoleModel role) {
        if (this.isFullScopeAllowed()) {
            return true;
        }
        Set<RoleModel> roles = this.getScopeMappings();
        if (roles.contains(role)) {
            return true;
        }
        for (RoleModel mapping : roles) {
            if (!mapping.hasRole(role)) continue;
            return true;
        }
        roles = this.getRoles();
        if (roles.contains(role)) {
            return true;
        }
        for (RoleModel mapping : roles) {
            if (!mapping.hasRole(role)) continue;
            return true;
        }
        return false;
    }

    public List<String> getDefaultRoles() {
        Collection<RoleEntity> entities = this.entity.getDefaultRoles();
        ArrayList<String> roles = new ArrayList<String>();
        if (entities == null) {
            return roles;
        }
        for (RoleEntity entity : entities) {
            roles.add(entity.getName());
        }
        return roles;
    }

    public void addDefaultRole(String name) {
        RoleModel role = this.getRole(name);
        if (role == null) {
            role = this.addRole(name);
        }
        Collection<RoleEntity> entities = this.entity.getDefaultRoles();
        for (RoleEntity entity : entities) {
            if (!entity.getId().equals(role.getId())) continue;
            return;
        }
        RoleEntity roleEntity = RoleAdapter.toRoleEntity(role, this.em);
        entities.add(roleEntity);
    }

    public void updateDefaultRoles(String ... defaultRoles) {
        Collection<RoleEntity> entities = this.entity.getDefaultRoles();
        HashSet<String> already = new HashSet<String>();
        ArrayList<RoleEntity> remove = new ArrayList<RoleEntity>();
        for (RoleEntity rel : entities) {
            if (!ClientAdapter.contains(rel.getName(), defaultRoles)) {
                remove.add(rel);
                continue;
            }
            already.add(rel.getName());
        }
        for (RoleEntity entity : remove) {
            entities.remove(entity);
        }
        this.em.flush();
        for (Iterator<RoleEntity> iterator : defaultRoles) {
            if (already.contains(iterator)) continue;
            this.addDefaultRole((String)((Object)iterator));
        }
        this.em.flush();
    }

    public void removeDefaultRoles(String ... defaultRoles) {
        Collection<RoleEntity> entities = this.entity.getDefaultRoles();
        ArrayList<RoleEntity> remove = new ArrayList<RoleEntity>();
        for (RoleEntity rel : entities) {
            if (!ClientAdapter.contains(rel.getName(), defaultRoles)) continue;
            remove.add(rel);
        }
        for (RoleEntity entity : remove) {
            entities.remove(entity);
        }
        this.em.flush();
    }

    public int getNodeReRegistrationTimeout() {
        return this.entity.getNodeReRegistrationTimeout();
    }

    public void setNodeReRegistrationTimeout(int timeout) {
        this.entity.setNodeReRegistrationTimeout(timeout);
    }

    public Map<String, Integer> getRegisteredNodes() {
        return this.entity.getRegisteredNodes();
    }

    public void registerNode(String nodeHost, int registrationTime) {
        Map<String, Integer> currentNodes = this.getRegisteredNodes();
        currentNodes.put(nodeHost, registrationTime);
        this.em.flush();
    }

    public void unregisterNode(String nodeHost) {
        Map<String, Integer> currentNodes = this.getRegisteredNodes();
        currentNodes.remove(nodeHost);
        this.em.flush();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof ClientModel)) {
            return false;
        }
        ClientModel that = (ClientModel)o;
        return that.getId().equals(this.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public String toString() {
        return this.getClientId();
    }
}

