/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.mw.wscf.protocols;

import com.arjuna.mw.wscf.exceptions.ProtocolNotRegisteredException;
import com.arjuna.mw.wscf.logging.wscfLogger;
import com.arjuna.mwlabs.wscf.utils.ContextProvider;
import com.arjuna.mwlabs.wscf.utils.HLSProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import org.jboss.jbossts.xts.environment.WSCFEnvironmentBean;
import org.jboss.jbossts.xts.environment.XTSPropertyManager;

public class ProtocolManager {
    private HashMap _protocols = new HashMap();
    private boolean _initialised = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getProtocolImplementation(String protocolName) throws ProtocolNotRegisteredException, IllegalArgumentException {
        ProtocolManager protocolManager = this;
        synchronized (protocolManager) {
            if (protocolName == null) {
                throw new IllegalArgumentException();
            }
            Object object = this._protocols.get(protocolName);
            if (object == null) {
                throw new ProtocolNotRegisteredException(wscfLogger.i18NLogger.get_mw_wscf11_protocols_ProtocolManager_1() + protocolName);
            }
            return object;
        }
    }

    public final synchronized void initialise() {
        Object object;
        String className;
        HLSProvider hlsProvider;
        if (this._initialised) {
            return;
        }
        this._initialised = true;
        WSCFEnvironmentBean wscfEnvironmentBean = XTSPropertyManager.getWSCFEnvironmentBean();
        List<String> protocolImplementations = wscfEnvironmentBean.getProtocolImplementations();
        if (protocolImplementations == null) {
            wscfLogger.i18NLogger.info_protocols_ProtocolManager_1();
            return;
        }
        ListIterator<String> iterator = protocolImplementations.listIterator();
        ArrayList<Class> contextProviderClasses = new ArrayList<Class>();
        ArrayList<Class> hlsProviderClasses = new ArrayList<Class>();
        while (iterator.hasNext()) {
            String className2 = iterator.next();
            Class clazz = null;
            try {
                clazz = this.getClass().getClassLoader().loadClass(className2);
                ContextProvider contextProvider = clazz.getAnnotation(ContextProvider.class);
                if (contextProvider != null) {
                    contextProviderClasses.add(clazz);
                    continue;
                }
                hlsProvider = clazz.getAnnotation(HLSProvider.class);
                if (hlsProvider != null) {
                    hlsProviderClasses.add(clazz);
                    continue;
                }
                wscfLogger.i18NLogger.error_protocols_ProtocolManager_2(className2);
            }
            catch (ClassNotFoundException cnfe) {
                wscfLogger.i18NLogger.error_protocols_ProtocolManager_3(className2, cnfe);
            }
        }
        for (Class clazz : hlsProviderClasses) {
            className = clazz.getName();
            try {
                hlsProvider = clazz.getAnnotation(HLSProvider.class);
                String serviceType = hlsProvider.serviceType();
                wscfLogger.i18NLogger.info_protocols_ProtocolManager_4(className, serviceType);
                object = clazz.newInstance();
                this._protocols.put(serviceType, object);
            }
            catch (InstantiationException ie) {
                wscfLogger.i18NLogger.error_protocols_ProtocolManager_5(className, ie);
            }
            catch (IllegalAccessException iae) {
                wscfLogger.i18NLogger.error_protocols_ProtocolManager_5(className, iae);
            }
        }
        for (Class clazz : contextProviderClasses) {
            className = clazz.getName();
            try {
                ContextProvider contextProvider = clazz.getAnnotation(ContextProvider.class);
                if (contextProvider == null) continue;
                String coordinationType = contextProvider.coordinationType();
                wscfLogger.i18NLogger.info_protocols_ProtocolManager_4(className, coordinationType);
                object = clazz.newInstance();
                this._protocols.put(coordinationType, object);
            }
            catch (InstantiationException ie) {
                wscfLogger.i18NLogger.error_protocols_ProtocolManager_5(className, ie);
                ie.printStackTrace();
            }
            catch (IllegalAccessException iae) {
                wscfLogger.i18NLogger.error_protocols_ProtocolManager_5(className, iae);
                iae.printStackTrace();
            }
        }
    }
}

