/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;

public enum ResidentKeyRequirement {
    DISCOURAGED("discouraged"),
    PREFERRED("preferred"),
    REQUIRED("required");

    private final String value;

    private ResidentKeyRequirement(String value) {
        this.value = value;
    }

    public static ResidentKeyRequirement create(String value) {
        if (value == null) {
            return null;
        }
        switch (value) {
            case "discouraged": {
                return DISCOURAGED;
            }
            case "preferred": {
                return PREFERRED;
            }
            case "required": {
                return REQUIRED;
            }
        }
        throw new IllegalArgumentException("value '" + value + "' is out of range");
    }

    @JsonCreator
    private static ResidentKeyRequirement deserialize(String value) throws InvalidFormatException {
        try {
            return ResidentKeyRequirement.create(value);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidFormatException(null, "value is out of range", (Object)value, ResidentKeyRequirement.class);
        }
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }
}

