/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.extensions.grep;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.aesh.command.Command;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandException;
import org.aesh.command.CommandResult;
import org.aesh.command.completer.CompleterInvocation;
import org.aesh.command.completer.OptionCompleter;
import org.aesh.command.invocation.CommandInvocation;
import org.aesh.command.option.Arguments;
import org.aesh.command.option.Option;
import org.aesh.complete.AeshCompleteOperation;
import org.aesh.impl.util.FileLister;
import org.aesh.io.Resource;

@CommandDefinition(name="grep", description="[OPTION]... PATTERN [FILE]...\nSearch for PATTERN in each FILE or standard input.\nPATTERN is a regular expression.\nExample: grep -i 'hello world' menu.h main.c\n")
public class Grep
implements Command<CommandInvocation> {
    @Option(shortName=72, name="help", hasValue=false, description="display this help and exit")
    private boolean help;
    @Option(shortName=105, name="ignore-case", hasValue=false, description="ignore case distinctions")
    private boolean ignoreCase;
    @Option(shortName=110, name="line-number", hasValue=false, description="Prefix each line of output with the 1-based line number within its input file.")
    private boolean lineNumber;
    @Option(shortName=111, name="only-matching", hasValue=false, description="Print only the matched (non-empty) parts of a matching line, with each such  part  on  a separate output line.")
    private boolean onlyMatching;
    @Option(shortName=99, name="count", hasValue=false, description="Suppress normal output; instead print a count of matching lines for each input file.")
    private boolean count;
    @Arguments(completer=GrepCompletor.class, description="The pattern to grep followed by file paths.")
    private List<String> arguments;
    private Pattern pattern;
    private int numberOfLines;
    private int numberOfMatchedLines;

    public List<String> getArguments() {
        return this.arguments;
    }

    public CommandResult execute(CommandInvocation commandInvocation) throws CommandException, InterruptedException {
        block10: {
            if (this.help || this.arguments == null || this.arguments.size() == 0) {
                commandInvocation.println(commandInvocation.getHelpInfo("grep"), true);
                return CommandResult.SUCCESS;
            }
            this.numberOfLines = 0;
            this.numberOfMatchedLines = 0;
            try {
                this.pattern = this.ignoreCase ? Pattern.compile(this.arguments.remove(0), 2) : Pattern.compile(this.arguments.remove(0));
            }
            catch (PatternSyntaxException pse) {
                commandInvocation.println("grep: invalid pattern.");
                return CommandResult.FAILURE;
            }
            try {
                if (commandInvocation.getConfiguration().getPipedData() != null && commandInvocation.getConfiguration().getPipedData().available() > 0) {
                    Scanner s = new Scanner(commandInvocation.getConfiguration().getPipedData()).useDelimiter("\\A");
                    String input = s.hasNext() ? s.next() : "";
                    for (String line : input.split("\\R")) {
                        ++this.numberOfLines;
                        this.doGrep(line, commandInvocation);
                    }
                    if (this.count) {
                        commandInvocation.println(String.valueOf(this.numberOfMatchedLines), true);
                    }
                    break block10;
                }
                if (this.arguments != null && this.arguments.size() > 0) {
                    for (String s : this.arguments) {
                        this.doGrep(commandInvocation.getConfiguration().getAeshContext().getCurrentWorkingDirectory().newInstance(s), commandInvocation);
                    }
                    break block10;
                }
                commandInvocation.println("grep: no file or input given.");
                return CommandResult.SUCCESS;
            }
            catch (IOException ex) {
                throw new CommandException((Throwable)ex);
            }
        }
        return null;
    }

    private void doGrep(Resource file, CommandInvocation invocation) throws IOException {
        if (!file.exists()) {
            invocation.println("grep: " + file.toString() + ": No such file or directory");
        } else if (file.isLeaf()) {
            try (BufferedReader reader = Files.newBufferedReader(Paths.get(file.getAbsolutePath(), new String[0]));){
                if (this.pattern != null) {
                    String line;
                    while ((line = reader.readLine()) != null) {
                        ++this.numberOfLines;
                        this.doGrep(line, invocation);
                    }
                    if (this.count) {
                        invocation.println(String.valueOf(this.numberOfMatchedLines), true);
                    }
                } else {
                    invocation.println("No pattern given");
                }
            }
        }
    }

    private void doGrep(String line, CommandInvocation invocation) {
        Matcher matcher;
        if (this.pattern != null && (matcher = this.pattern.matcher(line)).find()) {
            ++this.numberOfMatchedLines;
            if (!this.count) {
                if (this.lineNumber) {
                    if (this.onlyMatching) {
                        invocation.println(this.numberOfLines + ": " + line.substring(matcher.start(), matcher.end()), true);
                    } else {
                        invocation.println(this.numberOfLines + ": " + line, true);
                    }
                } else if (this.onlyMatching) {
                    invocation.println(line.substring(matcher.start(), matcher.end()), true);
                } else {
                    invocation.println(line, true);
                }
            }
        }
    }

    public static class GrepCompletor
    implements OptionCompleter<CompleterInvocation> {
        public void complete(CompleterInvocation completerData) {
            Grep grep = (Grep)completerData.getCommand();
            if (grep.getArguments() != null && grep.getArguments().size() > 0) {
                AeshCompleteOperation completeOperation = new AeshCompleteOperation(completerData.getAeshContext(), completerData.getGivenCompleteValue(), 0);
                ArrayList candidates = new ArrayList();
                if (completerData.getGivenCompleteValue() == null) {
                    new FileLister("", completerData.getAeshContext().getCurrentWorkingDirectory()).findMatchingDirectories(candidates);
                    completeOperation.addCompletionCandidates(candidates);
                } else {
                    int offset = new FileLister(completerData.getGivenCompleteValue(), completerData.getAeshContext().getCurrentWorkingDirectory()).findMatchingDirectories(candidates);
                    completeOperation.addCompletionCandidates(candidates);
                    completeOperation.setOffset(completerData.getGivenCompleteValue().length() - offset);
                }
                if (completeOperation.getCompletionCandidates().size() > 1) {
                    completeOperation.removeEscapedSpacesFromCompletionCandidates();
                }
                completerData.setCompleterValuesTerminalString(completeOperation.getCompletionCandidates());
                completerData.setOffset(completeOperation.getOffset());
                if (completerData.getGivenCompleteValue() != null && completerData.getCompleterValues().size() == 1) {
                    completerData.setAppendSpace(completeOperation.hasAppendSeparator());
                }
            }
        }
    }
}

