/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.mechanism._private;

import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.Param;
import org.jboss.logging.annotations.ValidIdRange;
import org.jboss.logging.annotations.ValidIdRanges;
import org.wildfly.security.asn1.ASN1Exception;
import org.wildfly.security.http.HttpAuthenticationException;
import org.wildfly.security.mechanism.AuthenticationMechanismException;
import org.wildfly.security.mechanism.ScramServerErrorCode;
import org.wildfly.security.mechanism.ScramServerException;

@MessageLogger(projectCode="ELY", length=5)
@ValidIdRanges(value={@ValidIdRange(min=7, max=7), @ValidIdRange(min=1151, max=1151), @ValidIdRange(min=5001, max=5177), @ValidIdRange(min=6001, max=6022), @ValidIdRange(min=7001, max=7004)})
public interface ElytronMessages
extends BasicLogger {
    public static final ElytronMessages log = (ElytronMessages)Logger.getMessageLogger(ElytronMessages.class, (String)"org.wildfly.security");
    public static final ElytronMessages sasl = (ElytronMessages)Logger.getMessageLogger(ElytronMessages.class, (String)"org.wildfly.security.sasl");
    public static final ElytronMessages saslAnonymous = (ElytronMessages)Logger.getMessageLogger(ElytronMessages.class, (String)"org.wildfly.security.sasl.anonymous");
    public static final ElytronMessages saslDigest = (ElytronMessages)Logger.getMessageLogger(ElytronMessages.class, (String)"org.wildfly.security.sasl.digest");
    public static final ElytronMessages saslEntity = (ElytronMessages)Logger.getMessageLogger(ElytronMessages.class, (String)"org.wildfly.security.sasl.entity");
    public static final ElytronMessages saslExternal = (ElytronMessages)Logger.getMessageLogger(ElytronMessages.class, (String)"org.wildfly.security.sasl.external");
    public static final ElytronMessages saslGs2 = (ElytronMessages)Logger.getMessageLogger(ElytronMessages.class, (String)"org.wildfly.security.sasl.gs2");
    public static final ElytronMessages saslGssapi = (ElytronMessages)Logger.getMessageLogger(ElytronMessages.class, (String)"org.wildfly.security.sasl.gssapi");
    public static final ElytronMessages saslLocal = (ElytronMessages)Logger.getMessageLogger(ElytronMessages.class, (String)"org.wildfly.security.sasl.local");
    public static final ElytronMessages saslOAuth2 = (ElytronMessages)Logger.getMessageLogger(ElytronMessages.class, (String)"org.wildfly.security.sasl.oauth2");
    public static final ElytronMessages saslOTP = (ElytronMessages)Logger.getMessageLogger(ElytronMessages.class, (String)"org.wildfly.security.sasl.otp");
    public static final ElytronMessages saslPlain = (ElytronMessages)Logger.getMessageLogger(ElytronMessages.class, (String)"org.wildfly.security.sasl.plain");
    public static final ElytronMessages saslScram = (ElytronMessages)Logger.getMessageLogger(ElytronMessages.class, (String)"org.wildfly.security.sasl.scram");
    public static final ElytronMessages httpSpnego = (ElytronMessages)Logger.getMessageLogger(ElytronMessages.class, (String)"org.wildfly.security.http.spnego");
    public static final ElytronMessages httpClientCert = (ElytronMessages)Logger.getMessageLogger(ElytronMessages.class, (String)"org.wildfly.security.http.cert");
    public static final ElytronMessages httpDigest = (ElytronMessages)Logger.getMessageLogger(ElytronMessages.class, (String)"org.wildfly.security.http.digest");
    public static final ElytronMessages httpUserPass = (ElytronMessages)Logger.getMessageLogger(ElytronMessages.class, (String)"org.wildfly.security.http.password");
    public static final ElytronMessages httpForm = (ElytronMessages)Logger.getMessageLogger(ElytronMessages.class, (String)"org.wildfly.security.http.form");
    public static final ElytronMessages httpBearer = (ElytronMessages)Logger.getMessageLogger(ElytronMessages.class, (String)"org.wildfly.security.http.bearer");
    public static final ElytronMessages httpBasic = (ElytronMessages)Logger.getMessageLogger(ElytronMessages.class, (String)"org.wildfly.security.http.basic");

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=7, value="Credential destroying failed")
    public void credentialDestroyingFailed(@Cause Throwable var1);

    @Message(id=1151, value="Evidence Verification Failed.")
    public SecurityException authenticationFailedEvidenceVerification();

    @Message(id=5001, value="Authentication mechanism exchange received a message after authentication was already complete")
    public AuthenticationMechanismException mechMessageAfterComplete();

    @Message(id=5002, value="Authentication mechanism user name contains an invalid or disallowed character")
    public AuthenticationMechanismException mechUserNameContainsInvalidCharacter();

    @Message(id=5004, value="Authentication mechanism authorization failed")
    public AuthenticationMechanismException mechAuthorizationFailed(@Cause Throwable var1);

    @Message(id=5005, value="Authentication mechanism authentication is not yet complete")
    public IllegalStateException mechAuthenticationNotComplete();

    @Message(id=5006, value="Authentication mechanism does not support security layer (wrapping/unwrapping)")
    public IllegalStateException mechNoSecurityLayer();

    @Message(id=5007, value="Invalid authentication mechanism negotiation message received")
    public AuthenticationMechanismException mechInvalidMessageReceived();

    @Message(id=5008, value="No authentication mechanism login name was given")
    public AuthenticationMechanismException mechNoLoginNameGiven();

    @Message(id=5009, value="No authentication mechanism password was given")
    public AuthenticationMechanismException mechNoPasswordGiven();

    @Message(id=5010, value="Authentication mechanism authentication failed due to one or more malformed fields")
    public AuthenticationMechanismException mechMalformedFields(@Cause IllegalArgumentException var1);

    @Message(id=5011, value="Authentication mechanism message is too long")
    public AuthenticationMechanismException mechMessageTooLong();

    @Message(id=5012, value="Authentication mechanism server-side authentication failed")
    public AuthenticationMechanismException mechServerSideAuthenticationFailed(@Cause Exception var1);

    @Message(id=5013, value="Authentication mechanism password not verified")
    public AuthenticationMechanismException mechPasswordNotVerified();

    @Message(id=5014, value="Authentication mechanism authorization failed: \"%s\" running as \"%s\"")
    public AuthenticationMechanismException mechAuthorizationFailed(String var1, String var2);

    @Message(id=5018, value="Channel binding data changed")
    public AuthenticationMechanismException mechChannelBindingChanged();

    @Message(id=5019, value="No token was given")
    public AuthenticationMechanismException mechNoTokenGiven();

    @Message(id=5022, value="Initial challenge must be empty")
    public AuthenticationMechanismException mechInitialChallengeMustBeEmpty();

    @Message(id=5023, value="Unable to set channel binding")
    public AuthenticationMechanismException mechUnableToSetChannelBinding(@Cause Exception var1);

    @Message(id=5024, value="Failed to determine channel binding status")
    public AuthenticationMechanismException mechFailedToDetermineChannelBindingStatus(@Cause Exception var1);

    @Message(id=5025, value="Mutual authentication not enabled")
    public AuthenticationMechanismException mechMutualAuthenticationNotEnabled();

    @Message(id=5026, value="Unable to map SASL mechanism name to a GSS-API OID")
    public AuthenticationMechanismException mechMechanismToOidMappingFailed(@Cause Exception var1);

    @Message(id=5027, value="Unable to dispose of GSSContext")
    public AuthenticationMechanismException mechUnableToDisposeGssContext(@Cause Exception var1);

    @Message(id=5028, value="Unable to create name for acceptor")
    public AuthenticationMechanismException mechUnableToCreateNameForAcceptor(@Cause Exception var1);

    @Message(id=5029, value="Unable to create GSSContext")
    public AuthenticationMechanismException mechUnableToCreateGssContext(@Cause Exception var1);

    @Message(id=5030, value="Unable to set GSSContext request flags")
    public AuthenticationMechanismException mechUnableToSetGssContextRequestFlags(@Cause Exception var1);

    @Message(id=5031, value="Unable to accept SASL client message")
    public AuthenticationMechanismException mechUnableToAcceptClientMessage(@Cause Exception var1);

    @Message(id=5032, value="GSS-API mechanism mismatch between SASL client and server")
    public AuthenticationMechanismException mechGssApiMechanismMismatch();

    @Message(id=5033, value="Channel binding not supported for this SASL mechanism")
    public AuthenticationMechanismException mechChannelBindingNotSupported();

    @Message(id=5034, value="Channel binding type mismatch between SASL client and server")
    public AuthenticationMechanismException mechChannelBindingTypeMismatch();

    @Message(id=5035, value="Channel binding not provided by client")
    public AuthenticationMechanismException mechChannelBindingNotProvided();

    @Message(id=5036, value="Unable to determine peer name")
    public AuthenticationMechanismException mechUnableToDeterminePeerName(@Cause Exception var1);

    @Message(id=5037, value="Authentication mechanism client refuses to initiate authentication")
    public AuthenticationMechanismException mechClientRefusesToInitiateAuthentication();

    @Message(id=5038, value="Nonces do not match")
    public AuthenticationMechanismException mechNoncesDoNotMatch();

    @Message(id=5039, value="Invalid length of nonce received")
    public AuthenticationMechanismException invalidNonceLength();

    @Message(id=5040, value="Iteration count %d is below the minimum of %d")
    public AuthenticationMechanismException mechIterationCountIsTooLow(int var1, int var2);

    @Message(id=5041, value="Iteration count %d is above the maximum of %d")
    public AuthenticationMechanismException mechIterationCountIsTooHigh(int var1, int var2);

    @Message(id=5043, value="Invalid server message")
    public AuthenticationMechanismException mechInvalidServerMessage();

    @Message(id=5044, value="Invalid server message")
    public AuthenticationMechanismException mechInvalidServerMessageWithCause(@Cause Throwable var1);

    @Message(id=5045, value="Invalid client message")
    public AuthenticationMechanismException mechInvalidClientMessage();

    @Message(id=5046, value="Invalid client message")
    public AuthenticationMechanismException mechInvalidClientMessageWithCause(@Cause Throwable var1);

    @Message(id=5047, value="[%s] Authentication mechanism message is for mismatched mechanism \"%s\"")
    public AuthenticationMechanismException mechUnmatchedMechanism(String var1, String var2);

    @Message(id=5049, value="Server authenticity cannot be verified")
    public AuthenticationMechanismException mechServerAuthenticityCannotBeVerified();

    @Message(id=5050, value="Callback handler does not support user name")
    public AuthenticationMechanismException mechCallbackHandlerDoesNotSupportUserName(@Cause Throwable var1);

    @Message(id=5051, value="Callback handler does not support credential acquisition")
    public AuthenticationMechanismException mechCallbackHandlerDoesNotSupportCredentialAcquisition(@Cause Throwable var1);

    @Message(id=5052, value="Callback handler does not support authorization")
    public AuthenticationMechanismException mechAuthorizationUnsupported(@Cause Throwable var1);

    @Message(id=5053, value="Callback handler failed for unknown reason")
    public AuthenticationMechanismException mechCallbackHandlerFailedForUnknownReason(@Cause Throwable var1);

    @Message(id=5055, value="Authentication rejected (invalid proof)")
    public AuthenticationMechanismException mechAuthenticationRejectedInvalidProof();

    @Message(id=5056, value="Client sent extra message")
    public AuthenticationMechanismException mechClientSentExtraMessage();

    @Message(id=5057, value="Server sent extra message")
    public AuthenticationMechanismException mechServerSentExtraMessage();

    @Message(id=5058, value="Authentication failed")
    public AuthenticationMechanismException mechAuthenticationFailed();

    @Message(id=5060, value="Empty number")
    public NumberFormatException emptyNumber();

    @Message(id=5061, value="Invalid numeric character")
    public NumberFormatException invalidNumericCharacter();

    @Message(id=5062, value="Too big number")
    public NumberFormatException tooBigNumber();

    @Message(id=5063, value="Cannot get clear password from two way password")
    public AuthenticationMechanismException mechCannotGetTwoWayPasswordChars(@Cause Throwable var1);

    @Message(id=5064, value="Hashing algorithm not supported")
    public AuthenticationMechanismException mechMacAlgorithmNotSupported(@Cause Throwable var1);

    @Message(id=5065, value="keyword cannot be empty")
    public AuthenticationMechanismException mechKeywordCannotBeEmpty();

    @Message(id=5066, value="No value found for keyword: %s")
    public AuthenticationMechanismException mechNoValueFoundForKeyword(String var1);

    @Message(id=5067, value="'=' expected after keyword: %s")
    public AuthenticationMechanismException mechKeywordNotFollowedByEqual(String var1);

    @Message(id=5068, value="Unmatched quote found for value: %s")
    public AuthenticationMechanismException mechUnmatchedQuoteFoundForValue(String var1);

    @Message(id=5069, value="Expecting comma or linear whitespace after quoted string: %s")
    public AuthenticationMechanismException mechExpectingCommaOrLinearWhitespaceAfterQuoted(String var1);

    @Message(id=5070, value="MessageType must equal to %d, but it is %d")
    public AuthenticationMechanismException mechMessageTypeMustEqual(int var1, int var2);

    @Message(id=5071, value="Bad sequence number while unwrapping: expected %d, but %d received")
    public AuthenticationMechanismException mechBadSequenceNumberWhileUnwrapping(int var1, int var2);

    @Message(id=5072, value="Problem during crypt")
    public AuthenticationMechanismException mechProblemDuringCrypt(@Cause Throwable var1);

    @Message(id=5073, value="Problem during decrypt")
    public AuthenticationMechanismException mechProblemDuringDecrypt(@Cause Throwable var1);

    @Message(id=5074, value="Unknown cipher \"%s\"")
    public AuthenticationMechanismException mechUnknownCipher(String var1);

    @Message(id=5075, value="Authorization ID changed unexpectedly")
    public AuthenticationMechanismException mechAuthorizationIdChanged();

    @Message(id=5076, value="Problem getting required cipher. Check your transformation mapper settings.")
    public AuthenticationMechanismException mechProblemGettingRequiredCipher(@Cause Throwable var1);

    @Message(id=5077, value="No common protection layer between client and server")
    public AuthenticationMechanismException mechNoCommonProtectionLayer();

    @Message(id=5078, value="No common cipher between client and server")
    public AuthenticationMechanismException mechNoCommonCipher();

    @Message(id=5079, value="No ciphers offered by server")
    public AuthenticationMechanismException mechNoCiphersOfferedByServer();

    @Message(id=5080, value="Callback handler not provided user name")
    public AuthenticationMechanismException mechNotProvidedUserName();

    @Message(id=5083, value="Missing \"%s\" directive")
    public AuthenticationMechanismException mechMissingDirective(String var1);

    @Message(id=5084, value="nonce-count must equal to %d, but it is %d")
    public AuthenticationMechanismException mechNonceCountMustEqual(int var1, int var2);

    @Message(id=5085, value="Server is set to not support %s charset")
    public AuthenticationMechanismException mechUnsupportedCharset(String var1);

    @Message(id=5086, value="Charset can be only \"utf-8\" or unspecified (to use ISO 8859-1)")
    public AuthenticationMechanismException mechUnknownCharset();

    @Message(id=5087, value="Client selected realm not offered by server (%s)")
    public AuthenticationMechanismException mechDisallowedClientRealm(String var1);

    @Message(id=5088, value="digest-uri \"%s\" not accepted")
    public AuthenticationMechanismException mechMismatchedWrongDigestUri(String var1);

    @Message(id=5089, value="Unexpected qop value: \"%s\"")
    public AuthenticationMechanismException mechUnexpectedQop(String var1);

    @Message(id=5090, value="Wrapping is not configured")
    public IllegalStateException wrappingNotConfigured();

    @Message(id=5091, value="Authentication name string is too long")
    public AuthenticationMechanismException mechAuthenticationNameTooLong();

    @Message(id=5092, value="Authentication name is empty")
    public AuthenticationMechanismException mechAuthenticationNameIsEmpty();

    @Message(id=5093, value="Authorization for anonymous access is denied")
    public AuthenticationMechanismException mechAnonymousAuthorizationDenied();

    @Message(id=5094, value="Required padded length (%d) is less than length of conversion result (%d)")
    public IllegalArgumentException requiredNegativePadding(int var1, int var2);

    @Message(id=5095, value="Invalid key provided for Digest HMAC computing")
    public AuthenticationMechanismException mechInvalidKeyForDigestHMAC();

    @Message(id=5097, value="Unable to determine subject name from X.509 certificate")
    public IllegalStateException unableToDetermineSubjectName(@Cause Throwable var1);

    @Message(id=5098, value="Unable to verify client signature")
    public AuthenticationMechanismException mechUnableToVerifyClientSignature(@Cause Throwable var1);

    @Message(id=5099, value="Unable to verify server signature")
    public AuthenticationMechanismException mechUnableToVerifyServerSignature(@Cause Throwable var1);

    @Message(id=5101, value="Callback handler not provided server certificate")
    public AuthenticationMechanismException mechCallbackHandlerNotProvidedServerCertificate();

    @Message(id=5102, value="Callback handler not provided client certificate")
    public AuthenticationMechanismException mechCallbackHandlerNotProvidedClientCertificate();

    @Message(id=5103, value="Server identifier mismatch")
    public AuthenticationMechanismException mechServerIdentifierMismatch();

    @Message(id=5104, value="Client identifier mismatch")
    public AuthenticationMechanismException mechClientIdentifierMismatch();

    @Message(id=5105, value="Unable to determine client name")
    public AuthenticationMechanismException mechUnableToDetermineClientName(@Cause Throwable var1);

    @Message(id=5106, value="Callback handler not provided private key")
    public AuthenticationMechanismException mechCallbackHandlerNotProvidedPrivateKey();

    @Message(id=5107, value="Unable to create signature")
    public AuthenticationMechanismException mechUnableToCreateSignature(@Cause Throwable var1);

    @Message(id=5108, value="Unable to create response token")
    public AuthenticationMechanismException mechUnableToCreateResponseToken(@Cause Throwable var1);

    @Message(id=5109, value="Unable to create response token")
    public AuthenticationMechanismException mechUnableToCreateResponseTokenWithCause(@Cause Throwable var1);

    @Message(id=5112, value="Getting authentication mechanisms supported by GSS-API failed")
    public AuthenticationMechanismException mechGettingSupportedMechanismsFailed(@Cause Throwable var1);

    @Message(id=5113, value="Unable to initialize OID of Kerberos V5")
    public RuntimeException unableToInitialiseOid(@Cause Throwable var1);

    @Message(id=5114, value="Receive buffer requested '%d' is greater than supported maximum '%d'")
    public AuthenticationMechanismException mechReceiveBufferIsGreaterThanMaximum(int var1, int var2);

    @Message(id=5115, value="Unable to wrap message")
    public AuthenticationMechanismException mechUnableToWrapMessage(@Cause Throwable var1);

    @Message(id=5116, value="Unable to unwrap message")
    public AuthenticationMechanismException mechUnableToUnwrapMessage(@Cause Throwable var1);

    @Message(id=5117, value="Unable to unwrap security layer negotiation message")
    public AuthenticationMechanismException mechUnableToUnwrapSecurityLayerNegotiationMessage(@Cause Throwable var1);

    @Message(id=5118, value="Invalid message of length %d on unwrapping")
    public AuthenticationMechanismException mechInvalidMessageOnUnwrapping(int var1);

    @Message(id=5119, value="Negotiated mechanism was not Kerberos V5")
    public AuthenticationMechanismException mechNegotiatedMechanismWasNotKerberosV5();

    @Message(id=5120, value="Insufficient levels of protection available for supported security layers")
    public AuthenticationMechanismException mechInsufficientQopsAvailable();

    @Message(id=5121, value="Unable to generate security layer challenge")
    public AuthenticationMechanismException mechUnableToGenerateChallenge(@Cause Throwable var1);

    @Message(id=5122, value="Client selected a security layer that was not offered by server")
    public AuthenticationMechanismException mechSelectedUnofferedQop();

    @Message(id=5123, value="No security layer selected but message length received")
    public AuthenticationMechanismException mechNoSecurityLayerButLengthReceived();

    @Message(id=5124, value="Unable to get maximum size of message before wrap")
    public AuthenticationMechanismException mechUnableToGetMaximumSizeOfMessage(@Cause Throwable var1);

    @Message(id=5125, value="Unable to handle response from server")
    public AuthenticationMechanismException mechUnableToHandleResponseFromServer(@Cause Throwable var1);

    @Message(id=5126, value="Bad length of message for negotiating security layer")
    public AuthenticationMechanismException mechBadLengthOfMessageForNegotiatingSecurityLayer();

    @Message(id=5127, value="No security layer supported by server but maximum message size received: \"%d\"")
    public AuthenticationMechanismException mechReceivedMaxMessageSizeWhenNoSecurityLayer(int var1);

    @Message(id=5128, value="Failed to read challenge file")
    public AuthenticationMechanismException mechFailedToReadChallengeFile(@Cause Throwable var1);

    @Message(id=5129, value="Failed to create challenge file")
    public AuthenticationMechanismException mechFailedToCreateChallengeFile(@Cause Throwable var1);

    @Message(id=5150, value="Authentication mechanism authorization ID is too long")
    public AuthenticationMechanismException mechAuthorizationIdTooLong();

    @Message(id=5151, value="Invalid OTP algorithm \"%s\"")
    public AuthenticationMechanismException mechInvalidOTPAlgorithm(String var1);

    @Message(id=5152, value="Invalid OTP response type")
    public AuthenticationMechanismException mechInvalidOTPResponseType();

    @Message(id=5153, value="Incorrect parity in SASL client message")
    public AuthenticationMechanismException mechIncorrectParity();

    @Message(id=5154, value="Invalid character in seed")
    public AuthenticationMechanismException mechInvalidCharacterInSeed();

    @Message(id=5155, value="Invalid OTP seed, must be between 1 and 16 characters long")
    public AuthenticationMechanismException mechInvalidOTPSeed();

    @Message(id=5156, value="Invalid OTP pass phrase, must be between 10 and 63 characters long")
    public AuthenticationMechanismException mechInvalidOTPPassPhrase();

    @Message(id=5157, value="Invalid OTP sequence number")
    public AuthenticationMechanismException mechInvalidOTPSequenceNumber();

    @Message(id=5158, value="Invalid OTP")
    public AuthenticationMechanismException mechInvalidOTP();

    @Message(id=5159, value="OTP pass phrase and seed must not match")
    public AuthenticationMechanismException mechOTPPassPhraseAndSeedMustNotMatch();

    @Message(id=5160, value="Invalid OTP alternate dictionary")
    public AuthenticationMechanismException mechInvalidOTPAlternateDictionary();

    @Message(id=5161, value="Unable to retrieve password for \"%s\"")
    public AuthenticationMechanismException mechUnableToRetrievePassword(String var1);

    @Message(id=5162, value="Unable to update password for \"%s\"")
    public AuthenticationMechanismException mechUnableToUpdatePassword(String var1);

    @Message(id=5163, value="Authentication mechanism server timed out")
    public AuthenticationMechanismException mechServerTimedOut();

    @Message(id=5164, value="Unable to obtain exclusive access for \"%s\"")
    public AuthenticationMechanismException mechUnableToObtainExclusiveAccess(String var1);

    @Message(id=5165, value="OTP re-initialization failed")
    public AuthenticationMechanismException mechOTPReinitializationFailed(@Cause Throwable var1);

    @Message(id=5166, value="Server rejected authentication")
    public ScramServerException scramServerRejectedAuthentication(@Param ScramServerErrorCode var1);

    @Message(id=5167, value="Invalid OTP password format type")
    public AuthenticationMechanismException mechInvalidOTPPasswordFormatType();

    @Message(id=5168, value="Unsupported algorithm selected \"%s\"")
    public AuthenticationMechanismException mechUnsupportedAlgorithm(String var1);

    @Message(id=5169, value="[%s] Clients response token does not match expected token")
    public String mechResponseTokenMismatch(String var1);

    @Message(id=5170, value="Problem during crypt: The encrypted result is null. The input data has a length of zero or too short to result in a new block.")
    public AuthenticationMechanismException mechProblemDuringCryptResultIsNull();

    @Message(id=5171, value="Problem during decrypt: The decrypted result is null. The input data has a length of zero or too short to result in a new block.")
    public AuthenticationMechanismException mechProblemDuringDecryptResultIsNull();

    @Message(id=5173, value="Unable to obtain server credential.")
    public AuthenticationMechanismException unableToObtainServerCredential();

    @Message(id=5174, value="Callback handler has not chosen realm")
    public AuthenticationMechanismException mechNotChosenRealm();

    @Message(id=5175, value="Unable to determine bound server name")
    public AuthenticationMechanismException mechUnableToDetermineBoundServerName(@Cause Exception var1);

    @Message(id=5176, value="Unsupported callback")
    public AuthenticationMechanismException mechCallbackHandlerUnsupportedCallback(@Cause Throwable var1);

    @Message(id=5177, value="One of \"%s\" and \"%s\" directives has to be defined")
    public AuthenticationMechanismException mechOneOfDirectivesHasToBeDefined(String var1, String var2);

    @Message(id=6001, value="An incorrectly formatted '%s'header was encountered.")
    public String incorrectlyFormattedHeader(String var1);

    @Message(id=6002, value="An authentication attempt for user '%s' failed validation using mechanism '%s'.")
    public String authenticationFailed(String var1, String var2);

    @Message(id=6003, value="An authentication attempt failed validation.")
    public String authenticationFailed();

    @Message(id=6006, value="An authorization check for user '%s' failed.")
    public String authorizationFailed(String var1);

    @Message(id=6007, value="Username or password missing from authentication attempt.")
    public String usernameOrPasswordMissing();

    @Message(id=6015, value="Unable to authenticate using DIGEST mechanism - realm name needs to be specified")
    public HttpAuthenticationException digestMechanismRequireRealm();

    @Message(id=6019, value="Unable to authenticate using DIGEST mechanism - mechanism realm name (%s) is not valid")
    public HttpAuthenticationException digestMechanismInvalidRealm(String var1);

    @Message(id=6020, value="Scope unsuitable for use with authentication state '%s'")
    public IllegalArgumentException unsuitableScope(String var1);

    @Message(id=6021, value="Unable to identify suitable HttpScope for mechanism state storage")
    public IllegalArgumentException unableToIdentifyHttpScope();

    @Message(id=6022, value="Invalid nonce count %s")
    public HttpAuthenticationException invalidNonceCount(int var1);

    @Message(id=7001, value="Unrecognized encoding algorithm [%s]")
    public ASN1Exception asnUnrecognisedAlgorithm(String var1);

    @Message(id=7002, value="Invalid general name type")
    public ASN1Exception asnInvalidGeneralNameType();

    @Message(id=7004, value="Unexpected ASN.1 tag encountered")
    public ASN1Exception asnUnexpectedTag();
}

