/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.spi.util;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.OptionalDouble;
import org.wildfly.clustering.marshalling.Externalizer;

public class OptionalDoubleExternalizer
implements Externalizer<OptionalDouble> {
    public void writeObject(ObjectOutput output, OptionalDouble value) throws IOException {
        boolean present = value.isPresent();
        output.writeBoolean(present);
        if (present) {
            output.writeDouble(value.getAsDouble());
        }
    }

    public OptionalDouble readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        return input.readBoolean() ? OptionalDouble.of(input.readDouble()) : OptionalDouble.empty();
    }

    public Class<OptionalDouble> getTargetClass() {
        return OptionalDouble.class;
    }
}

