/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleListAttributeDefinition;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.services.path.PathResourceDefinition;
import org.jboss.as.logging.Attribute;
import org.jboss.as.logging.CommonAttributes;
import org.jboss.as.logging.Element;
import org.jboss.as.logging.LoggingSubsystemParser;
import org.jboss.as.logging.formatters.PatternFormatterResourceDefinition;
import org.jboss.as.logging.handlers.AbstractHandlerDefinition;
import org.jboss.as.logging.handlers.AsyncHandlerResourceDefinition;
import org.jboss.as.logging.handlers.ConsoleHandlerResourceDefinition;
import org.jboss.as.logging.handlers.FileHandlerResourceDefinition;
import org.jboss.as.logging.handlers.PeriodicHandlerResourceDefinition;
import org.jboss.as.logging.handlers.SizeRotatingHandlerResourceDefinition;
import org.jboss.as.logging.loggers.LoggerAttributes;
import org.jboss.as.logging.loggers.LoggerResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;

class LoggingSubsystemParser_1_0
extends LoggingSubsystemParser
implements XMLStreamConstants,
XMLElementReader<List<ModelNode>> {
    LoggingSubsystemParser_1_0() {
    }

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        operations.add(Util.createAddOperation((PathAddress)SUBSYSTEM_ADDRESS));
        ArrayList<ModelNode> loggerOperations = new ArrayList<ModelNode>();
        ArrayList<ModelNode> asyncHandlerOperations = new ArrayList<ModelNode>();
        ArrayList<ModelNode> handlerOperations = new ArrayList<ModelNode>();
        HashSet<String> loggerNames = new HashSet<String>();
        HashSet<String> handlerNames = new HashSet<String>();
        boolean rootDefined = false;
        block9: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case LOGGER: {
                    this.parseLoggerElement(reader, SUBSYSTEM_ADDRESS, loggerOperations, loggerNames);
                    continue block9;
                }
                case ROOT_LOGGER: {
                    if (rootDefined) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    rootDefined = true;
                    this.parseRootLoggerElement(reader, SUBSYSTEM_ADDRESS, loggerOperations);
                    continue block9;
                }
                case CONSOLE_HANDLER: {
                    this.parseConsoleHandlerElement(reader, SUBSYSTEM_ADDRESS, handlerOperations, handlerNames);
                    continue block9;
                }
                case FILE_HANDLER: {
                    this.parseFileHandlerElement(reader, SUBSYSTEM_ADDRESS, handlerOperations, handlerNames);
                    continue block9;
                }
                case PERIODIC_ROTATING_FILE_HANDLER: {
                    this.parsePeriodicRotatingFileHandlerElement(reader, SUBSYSTEM_ADDRESS, handlerOperations, handlerNames);
                    continue block9;
                }
                case SIZE_ROTATING_FILE_HANDLER: {
                    this.parseSizeRotatingHandlerElement(reader, SUBSYSTEM_ADDRESS, handlerOperations, handlerNames);
                    continue block9;
                }
                case ASYNC_HANDLER: {
                    this.parseAsyncHandlerElement(reader, SUBSYSTEM_ADDRESS, asyncHandlerOperations, handlerNames);
                    continue block9;
                }
            }
            reader.handleAny(operations);
        }
        operations.addAll(handlerOperations);
        operations.addAll(asyncHandlerOperations);
        operations.addAll(loggerOperations);
    }

    void parseLoggerElement(XMLExtendedStreamReader reader, PathAddress address, List<ModelNode> operations, Set<String> names) throws XMLStreamException {
        ModelNode operation = Util.createAddOperation();
        String name = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.CATEGORY);
        int count = reader.getAttributeCount();
        block9: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case CATEGORY: {
                    if (value == null || value.trim().isEmpty()) {
                        throw ParseUtils.invalidAttributeValue((XMLExtendedStreamReader)reader, (int)i);
                    }
                    name = value;
                    continue block9;
                }
                case USE_PARENT_HANDLERS: {
                    LoggerResourceDefinition.USE_PARENT_HANDLERS.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block9;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        assert (name != null);
        if (!names.add(name)) {
            throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, name);
        }
        LoggingSubsystemParser_1_0.addOperationAddress(operation, address, "logger", name);
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        block10: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (!encountered.add(element)) {
                throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)reader.getLocalName());
            }
            switch (element) {
                case LEVEL: {
                    CommonAttributes.LEVEL.parseAndSetParameter(LoggingSubsystemParser_1_0.readNameAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block10;
                }
                case HANDLERS: {
                    this.parseHandlersElement(element.getDefinition(), operation, reader);
                    continue block10;
                }
                case FILTER: {
                    LoggingSubsystemParser_1_0.parseFilter(operation, (AttributeDefinition)LoggerAttributes.FILTER_SPEC, reader);
                    continue block10;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        operations.add(operation);
    }

    void parseAsyncHandlerElement(XMLExtendedStreamReader reader, PathAddress address, List<ModelNode> operations, Set<String> names) throws XMLStreamException {
        ModelNode operation = Util.createAddOperation();
        String name = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        int count = reader.getAttributeCount();
        block11: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block11;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        if (!names.add(name)) {
            throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, name);
        }
        LoggingSubsystemParser_1_0.addOperationAddress(operation, address, "async-handler", name);
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        block12: while (reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (!encountered.add(element)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            switch (element) {
                case LEVEL: {
                    CommonAttributes.LEVEL.parseAndSetParameter(LoggingSubsystemParser_1_0.readNameAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block12;
                }
                case SUBHANDLERS: {
                    this.parseHandlersElement(element.getDefinition(), operation, reader);
                    continue block12;
                }
                case FILTER: {
                    LoggingSubsystemParser_1_0.parseFilter(operation, (AttributeDefinition)AsyncHandlerResourceDefinition.FILTER_SPEC, reader);
                    continue block12;
                }
                case FORMATTER: {
                    this.parseHandlerFormatterElement(reader, operation);
                    continue block12;
                }
                case QUEUE_LENGTH: {
                    AsyncHandlerResourceDefinition.QUEUE_LENGTH.parseAndSetParameter(LoggingSubsystemParser_1_0.readValueAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block12;
                }
                case OVERFLOW_ACTION: {
                    AsyncHandlerResourceDefinition.OVERFLOW_ACTION.parseAndSetParameter(LoggingSubsystemParser_1_0.readValueAttribute(reader).toUpperCase(Locale.US), operation, (XMLStreamReader)reader);
                    continue block12;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        operations.add(operation);
    }

    void parseRootLoggerElement(XMLExtendedStreamReader reader, PathAddress address, List<ModelNode> operations) throws XMLStreamException {
        if (reader.getAttributeCount() > 0) {
            throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)0);
        }
        ModelNode operation = Util.createAddOperation((PathAddress)address.append("root-logger", "ROOT"));
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        block5: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (encountered.contains((Object)element)) {
                throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)reader.getLocalName());
            }
            encountered.add(element);
            switch (element) {
                case FILTER: {
                    LoggingSubsystemParser_1_0.parseFilter(operation, (AttributeDefinition)LoggerAttributes.FILTER_SPEC, reader);
                    continue block5;
                }
                case LEVEL: {
                    CommonAttributes.LEVEL.parseAndSetParameter(LoggingSubsystemParser_1_0.readNameAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block5;
                }
                case HANDLERS: {
                    this.parseHandlersElement(element.getDefinition(), operation, reader);
                    continue block5;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        operations.add(operation);
    }

    void parseConsoleHandlerElement(XMLExtendedStreamReader reader, PathAddress address, List<ModelNode> operations, Set<String> names) throws XMLStreamException {
        ModelNode operation = Util.createAddOperation();
        String name = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        int count = reader.getAttributeCount();
        block11: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block11;
                }
                case AUTOFLUSH: {
                    CommonAttributes.AUTOFLUSH.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block11;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        if (!names.add(name)) {
            throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, name);
        }
        LoggingSubsystemParser_1_0.addOperationAddress(operation, address, "console-handler", name);
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        block12: while (reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (!encountered.add(element)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            switch (element) {
                case LEVEL: {
                    CommonAttributes.LEVEL.parseAndSetParameter(LoggingSubsystemParser_1_0.readNameAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block12;
                }
                case ENCODING: {
                    CommonAttributes.ENCODING.parseAndSetParameter(LoggingSubsystemParser_1_0.readValueAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block12;
                }
                case FILTER: {
                    LoggingSubsystemParser_1_0.parseFilter(operation, (AttributeDefinition)ConsoleHandlerResourceDefinition.FILTER_SPEC, reader);
                    continue block12;
                }
                case FORMATTER: {
                    this.parseHandlerFormatterElement(reader, operation);
                    continue block12;
                }
                case TARGET: {
                    String target = LoggingSubsystemParser_1_0.readNameAttribute(reader);
                    ConsoleHandlerResourceDefinition.TARGET.parseAndSetParameter(target, operation, (XMLStreamReader)reader);
                    continue block12;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        operations.add(operation);
    }

    void parseFileHandlerElement(XMLExtendedStreamReader reader, PathAddress address, List<ModelNode> operations, Set<String> names) throws XMLStreamException {
        ModelNode operation = Util.createAddOperation();
        String name = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        int count = reader.getAttributeCount();
        block12: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block12;
                }
                case AUTOFLUSH: {
                    CommonAttributes.AUTOFLUSH.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block12;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        if (!names.add(name)) {
            throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, name);
        }
        LoggingSubsystemParser_1_0.addOperationAddress(operation, address, "file-handler", name);
        EnumSet<Element> requiredElem = EnumSet.of(Element.FILE);
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        block13: while (reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (!encountered.add(element)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            requiredElem.remove((Object)element);
            switch (element) {
                case LEVEL: {
                    CommonAttributes.LEVEL.parseAndSetParameter(LoggingSubsystemParser_1_0.readNameAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block13;
                }
                case ENCODING: {
                    CommonAttributes.ENCODING.parseAndSetParameter(LoggingSubsystemParser_1_0.readValueAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block13;
                }
                case FILTER: {
                    LoggingSubsystemParser_1_0.parseFilter(operation, (AttributeDefinition)FileHandlerResourceDefinition.FILTER_SPEC, reader);
                    continue block13;
                }
                case FORMATTER: {
                    this.parseHandlerFormatterElement(reader, operation);
                    continue block13;
                }
                case FILE: {
                    this.parseFileElement(operation.get(CommonAttributes.FILE.getName()), reader);
                    continue block13;
                }
                case APPEND: {
                    CommonAttributes.APPEND.parseAndSetParameter(LoggingSubsystemParser_1_0.readValueAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block13;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (!requiredElem.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, requiredElem);
        }
        operations.add(operation);
    }

    void parsePeriodicRotatingFileHandlerElement(XMLExtendedStreamReader reader, PathAddress address, List<ModelNode> operations, Set<String> names) throws XMLStreamException {
        ModelNode operation = Util.createAddOperation();
        String name = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        int count = reader.getAttributeCount();
        block13: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block13;
                }
                case AUTOFLUSH: {
                    CommonAttributes.AUTOFLUSH.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block13;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        if (!names.add(name)) {
            throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, name);
        }
        LoggingSubsystemParser_1_0.addOperationAddress(operation, address, "periodic-rotating-file-handler", name);
        EnumSet<Element> requiredElem = EnumSet.of(Element.FILE, Element.SUFFIX);
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        block14: while (reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (!encountered.add(element)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            requiredElem.remove((Object)element);
            switch (element) {
                case LEVEL: {
                    CommonAttributes.LEVEL.parseAndSetParameter(LoggingSubsystemParser_1_0.readNameAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block14;
                }
                case ENCODING: {
                    CommonAttributes.ENCODING.parseAndSetParameter(LoggingSubsystemParser_1_0.readValueAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block14;
                }
                case FILTER: {
                    LoggingSubsystemParser_1_0.parseFilter(operation, (AttributeDefinition)PeriodicHandlerResourceDefinition.FILTER_SPEC, reader);
                    continue block14;
                }
                case FORMATTER: {
                    this.parseHandlerFormatterElement(reader, operation);
                    continue block14;
                }
                case FILE: {
                    this.parseFileElement(operation.get(CommonAttributes.FILE.getName()), reader);
                    continue block14;
                }
                case APPEND: {
                    CommonAttributes.APPEND.parseAndSetParameter(LoggingSubsystemParser_1_0.readValueAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block14;
                }
                case SUFFIX: {
                    PeriodicHandlerResourceDefinition.SUFFIX.parseAndSetParameter(LoggingSubsystemParser_1_0.readValueAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block14;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (!requiredElem.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, requiredElem);
        }
        operations.add(operation);
    }

    void parseSizeRotatingHandlerElement(XMLExtendedStreamReader reader, PathAddress address, List<ModelNode> operations, Set<String> names) throws XMLStreamException {
        ModelNode operation = Util.createAddOperation();
        String name = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        int count = reader.getAttributeCount();
        block14: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block14;
                }
                case AUTOFLUSH: {
                    CommonAttributes.AUTOFLUSH.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block14;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        if (!names.add(name)) {
            throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, name);
        }
        LoggingSubsystemParser_1_0.addOperationAddress(operation, address, "size-rotating-file-handler", name);
        EnumSet<Element> requiredElem = EnumSet.of(Element.FILE);
        EnumSet<Element> encountered = EnumSet.noneOf(Element.class);
        block15: while (reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (!encountered.add(element)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            requiredElem.remove((Object)element);
            switch (element) {
                case LEVEL: {
                    CommonAttributes.LEVEL.parseAndSetParameter(LoggingSubsystemParser_1_0.readNameAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block15;
                }
                case ENCODING: {
                    CommonAttributes.ENCODING.parseAndSetParameter(LoggingSubsystemParser_1_0.readValueAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block15;
                }
                case FILTER: {
                    LoggingSubsystemParser_1_0.parseFilter(operation, (AttributeDefinition)SizeRotatingHandlerResourceDefinition.FILTER_SPEC, reader);
                    continue block15;
                }
                case FORMATTER: {
                    this.parseHandlerFormatterElement(reader, operation);
                    continue block15;
                }
                case FILE: {
                    this.parseFileElement(operation.get(CommonAttributes.FILE.getName()), reader);
                    continue block15;
                }
                case APPEND: {
                    CommonAttributes.APPEND.parseAndSetParameter(LoggingSubsystemParser_1_0.readValueAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block15;
                }
                case ROTATE_SIZE: {
                    SizeRotatingHandlerResourceDefinition.ROTATE_SIZE.parseAndSetParameter(LoggingSubsystemParser_1_0.readValueAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block15;
                }
                case MAX_BACKUP_INDEX: {
                    SizeRotatingHandlerResourceDefinition.MAX_BACKUP_INDEX.parseAndSetParameter(LoggingSubsystemParser_1_0.readValueAttribute(reader), operation, (XMLStreamReader)reader);
                    continue block15;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        operations.add(operation);
    }

    void parseFileElement(ModelNode operation, XMLExtendedStreamReader reader) throws XMLStreamException {
        EnumSet<Attribute> required = EnumSet.of(Attribute.PATH);
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case PATH: {
                    PathResourceDefinition.PATH.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block4;
                }
                case RELATIVE_TO: {
                    CommonAttributes.RELATIVE_TO.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    void parseHandlerFormatterElement(XMLExtendedStreamReader reader, ModelNode operation) throws XMLStreamException {
        if (reader.getAttributeCount() > 0) {
            throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)0);
        }
        boolean formatterDefined = false;
        block3: while (reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PATTERN_FORMATTER: {
                    if (formatterDefined) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)PatternFormatterResourceDefinition.PATTERN.getName());
                    formatterDefined = true;
                    AbstractHandlerDefinition.FORMATTER.parseAndSetParameter(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)PatternFormatterResourceDefinition.PATTERN.getName()), operation, (XMLStreamReader)reader);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    void parseHandlersElement(AttributeDefinition attribute, ModelNode operation, XMLExtendedStreamReader reader) throws XMLStreamException {
        if (reader.getAttributeCount() > 0) {
            throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)0);
        }
        ModelNode handlers = operation.get(attribute.getName());
        assert (attribute instanceof SimpleListAttributeDefinition);
        AttributeDefinition valueType = ((SimpleListAttributeDefinition)attribute).getValueType();
        while (reader.hasNext() && reader.nextTag() != 2) {
            String localName = reader.getLocalName();
            if (localName.equals(valueType.getXmlName())) {
                handlers.add(LoggingSubsystemParser_1_0.readNameAttribute(reader));
                continue;
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }
}

