/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.jms.Connection;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.jms.ActiveMQJMSClient;
import org.apache.activemq.artemis.jms.client.ActiveMQConnection;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;

public class ServerUtil {
    public static Process startServer(String artemisInstance, String serverName) throws Exception {
        return ServerUtil.startServer(artemisInstance, serverName, 0, 0);
    }

    public static Process startServer(String artemisInstance, String serverName, int id, int timeout) throws Exception {
        boolean IS_WINDOWS = System.getProperty("os.name").toLowerCase().trim().startsWith("win");
        ProcessBuilder builder = null;
        builder = IS_WINDOWS ? new ProcessBuilder("cmd", "/c", "artemis.cmd", "run") : new ProcessBuilder("./artemis", "run");
        builder.directory(new File(artemisInstance + "/bin"));
        final Process process = builder.start();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                process.destroy();
            }
        });
        ProcessLogger outputLogger = new ProcessLogger(true, process.getInputStream(), serverName, false);
        outputLogger.start();
        ProcessLogger errorLogger = new ProcessLogger(true, process.getErrorStream(), serverName, true);
        errorLogger.start();
        if (timeout != 0) {
            ServerUtil.waitForServerToStart(id, timeout);
        }
        return process;
    }

    public static void waitForServerToStart(int id, int timeout) throws InterruptedException {
        ServerUtil.waitForServerToStart("tcp://localhost:" + (61616 + id), (long)timeout);
    }

    public static void waitForServerToStart(String uri, long timeout) throws InterruptedException {
        long realTimeout = System.currentTimeMillis() + timeout;
        while (System.currentTimeMillis() < realTimeout) {
            try (ActiveMQConnectionFactory cf = ActiveMQJMSClient.createConnectionFactory((String)uri, null);){
                cf.createConnection().close();
                System.out.println("server " + uri + " started");
                break;
            }
            catch (Exception e) {
                System.out.println("awaiting server " + uri + " start at ");
                Thread.sleep(500L);
            }
        }
    }

    public static void killServer(Process server) throws Exception {
        if (server != null) {
            System.out.println("**********************************");
            System.out.println("Killing server " + server);
            System.out.println("**********************************");
            server.destroy();
            server.waitFor();
            Thread.sleep(1000L);
        }
    }

    public static int getServer(Connection connection) {
        ClientSession session = ((ActiveMQConnection)connection).getInitialSession();
        TransportConfiguration transportConfiguration = session.getSessionFactory().getConnectorConfiguration();
        String port = (String)transportConfiguration.getParams().get("port");
        return Integer.valueOf(port) - 61616;
    }

    public static Connection getServerConnection(int server, Connection ... connections) {
        for (Connection connection : connections) {
            ClientSession session = ((ActiveMQConnection)connection).getInitialSession();
            TransportConfiguration transportConfiguration = session.getSessionFactory().getConnectorConfiguration();
            String port = (String)transportConfiguration.getParams().get("port");
            if (Integer.valueOf(port) != server + 61616) continue;
            return connection;
        }
        return null;
    }

    static class ProcessLogger
    extends Thread {
        private final InputStream is;
        private final String logName;
        private final boolean print;
        private final boolean sendToErr;

        ProcessLogger(boolean print, InputStream is, String logName, boolean sendToErr) throws ClassNotFoundException {
            this.is = is;
            this.print = print;
            this.logName = logName;
            this.sendToErr = sendToErr;
            this.setDaemon(false);
        }

        @Override
        public void run() {
            try {
                String line;
                InputStreamReader isr = new InputStreamReader(this.is);
                BufferedReader br = new BufferedReader(isr);
                while ((line = br.readLine()) != null) {
                    if (!this.print) continue;
                    if (this.sendToErr) {
                        System.err.println(this.logName + "-err:" + line);
                        continue;
                    }
                    System.out.println(this.logName + "-out:" + line);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

