/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.migration.migrators;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.keycloak.migration.ModelVersion;
import org.keycloak.migration.migrators.Migration;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RequiredActionProviderModel;
import org.keycloak.representations.idm.RealmRepresentation;

public class MigrateTo4_2_0
implements Migration {
    public static final ModelVersion VERSION = new ModelVersion("4.2.0");
    private static final Logger LOG = Logger.getLogger(MigrateTo4_2_0.class);

    @Override
    public ModelVersion getVersion() {
        return VERSION;
    }

    @Override
    public void migrate(KeycloakSession session) {
        session.realms().getRealms().stream().forEach(r -> this.migrateRealm(session, (RealmModel)r, false));
    }

    @Override
    public void migrateImport(KeycloakSession session, RealmModel realm, RealmRepresentation rep, boolean skipUserDependent) {
        this.migrateRealm(session, realm, true);
    }

    protected void migrateRealm(KeycloakSession session, RealmModel realm, boolean json) {
        List actions = realm.getRequiredActionProviders().stream().sorted(Comparator.comparing(RequiredActionProviderModel::getName)).collect(Collectors.toList());
        int priority = 10;
        for (RequiredActionProviderModel model : actions) {
            LOG.debugf("Setting priority '%d' for required action '%s' in realm '%s'", priority, (Object)model.getAlias(), (Object)realm.getName());
            model.setPriority(priority);
            priority += 10;
            realm.updateRequiredActionProvider(model);
        }
    }
}

