/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.Collections;
import java.util.List;
import org.infinispan.commons.configuration.ConfigurationInfo;
import org.infinispan.commons.configuration.attributes.Matchable;
import org.infinispan.commons.configuration.elements.DefaultElementDefinition;
import org.infinispan.commons.configuration.elements.ElementDefinition;
import org.infinispan.configuration.cache.MemoryStorageConfiguration;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.configuration.parsing.Element;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.eviction.EvictionType;

public class MemoryConfiguration
implements Matchable<MemoryConfiguration>,
ConfigurationInfo {
    private final List<ConfigurationInfo> subElements;
    private final MemoryStorageConfiguration memoryStorageConfiguration;
    public static final ElementDefinition ELEMENT_DEFINITION = new DefaultElementDefinition(Element.MEMORY.getLocalName());

    MemoryConfiguration(MemoryStorageConfiguration memoryStorageConfiguration) {
        this.memoryStorageConfiguration = memoryStorageConfiguration;
        this.subElements = Collections.singletonList(memoryStorageConfiguration);
    }

    public ElementDefinition getElementDefinition() {
        return ELEMENT_DEFINITION;
    }

    public List<ConfigurationInfo> subElements() {
        return this.subElements;
    }

    public StorageType storageType() {
        return this.memoryStorageConfiguration.storageType();
    }

    public long size() {
        return this.memoryStorageConfiguration.size();
    }

    public void size(long newSize) {
        this.memoryStorageConfiguration.size(newSize);
    }

    public EvictionType evictionType() {
        return this.memoryStorageConfiguration.evictionType();
    }

    public EvictionStrategy evictionStrategy() {
        return this.memoryStorageConfiguration.evictionStrategy();
    }

    public boolean isEvictionEnabled() {
        return this.memoryStorageConfiguration.size() > 0L && this.memoryStorageConfiguration.evictionStrategy().isRemovalBased();
    }

    @Deprecated
    public int addressCount() {
        return this.memoryStorageConfiguration.addressCount();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MemoryConfiguration that = (MemoryConfiguration)o;
        return this.memoryStorageConfiguration.equals(that.memoryStorageConfiguration);
    }

    public int hashCode() {
        return this.memoryStorageConfiguration.hashCode();
    }

    public String toString() {
        return "MemoryConfiguration{memoryStorageConfiguration=" + this.memoryStorageConfiguration + '}';
    }

    public MemoryStorageConfiguration heapConfiguration() {
        return this.memoryStorageConfiguration;
    }
}

