/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.ch.impl;

import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.infinispan.commons.hash.Hash;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.ch.ConsistentHashFactory;
import org.infinispan.distribution.ch.impl.DefaultConsistentHash;
import org.infinispan.distribution.ch.impl.ReplicatedConsistentHash;
import org.infinispan.distribution.ch.impl.SyncConsistentHashFactory;
import org.infinispan.globalstate.ScopedPersistentState;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.logging.Log;

public class SyncReplicatedConsistentHashFactory
implements ConsistentHashFactory<ReplicatedConsistentHash> {
    public static final float OWNED_SEGMENTS_ALLOWED_VARIATION = 1.1f;
    public static final float PRIMARY_SEGMENTS_ALLOWED_VARIATION = 1.2f;
    private static final SyncConsistentHashFactory syncCHF = new SyncConsistentHashFactory();

    @Override
    public ReplicatedConsistentHash create(Hash hashFunction, int numOwners, int numSegments, List<Address> members, Map<Address, Float> capacityFactors) {
        ConsistentHash dch = syncCHF.create(hashFunction, 1, numSegments, (List)members, (Map)null);
        return this.replicatedFromDefault((DefaultConsistentHash)dch);
    }

    @Override
    public ReplicatedConsistentHash fromPersistentState(ScopedPersistentState state) {
        String consistentHashClass = state.getProperty("consistentHash");
        if (!ReplicatedConsistentHash.class.getName().equals(consistentHashClass)) {
            throw Log.CONTAINER.persistentConsistentHashMismatch(this.getClass().getName(), consistentHashClass);
        }
        return new ReplicatedConsistentHash(state);
    }

    private ReplicatedConsistentHash replicatedFromDefault(DefaultConsistentHash dch) {
        int numSegments = dch.getNumSegments();
        List<Address> members = dch.getMembers();
        int[] primaryOwners = new int[numSegments];
        for (int segment = 0; segment < numSegments; ++segment) {
            primaryOwners[segment] = members.indexOf(dch.locatePrimaryOwnerForSegment(segment));
        }
        return new ReplicatedConsistentHash(dch.getHashFunction(), members, primaryOwners);
    }

    @Override
    public ReplicatedConsistentHash updateMembers(ReplicatedConsistentHash baseCH, List<Address> newMembers, Map<Address, Float> actualCapacityFactors) {
        DefaultConsistentHash baseDCH = this.defaultFromReplicated(baseCH);
        DefaultConsistentHash dch = syncCHF.updateMembers(baseDCH, newMembers, (Map<Address, Float>)null);
        return this.replicatedFromDefault(dch);
    }

    private DefaultConsistentHash defaultFromReplicated(ReplicatedConsistentHash baseCH) {
        int numSegments = baseCH.getNumSegments();
        List[] baseSegmentOwners = new List[numSegments];
        for (int segment = 0; segment < numSegments; ++segment) {
            baseSegmentOwners[segment] = Collections.singletonList(baseCH.locatePrimaryOwnerForSegment(segment));
        }
        return new DefaultConsistentHash(baseCH.getHashFunction(), 1, numSegments, baseCH.getMembers(), null, (List<Address>[])baseSegmentOwners);
    }

    @Override
    public ReplicatedConsistentHash rebalance(ReplicatedConsistentHash baseCH) {
        DefaultConsistentHash baseDCH = this.defaultFromReplicated(baseCH);
        DefaultConsistentHash dch = syncCHF.rebalance(baseDCH);
        return this.replicatedFromDefault(dch);
    }

    @Override
    public ReplicatedConsistentHash union(ReplicatedConsistentHash ch1, ReplicatedConsistentHash ch2) {
        return ch1.union(ch2);
    }

    public static class Externalizer
    extends AbstractExternalizer<SyncReplicatedConsistentHashFactory> {
        public void writeObject(ObjectOutput output, SyncReplicatedConsistentHashFactory chf) {
        }

        public SyncReplicatedConsistentHashFactory readObject(ObjectInput unmarshaller) {
            return new SyncReplicatedConsistentHashFactory();
        }

        public Integer getId() {
            return 96;
        }

        public Set<Class<? extends SyncReplicatedConsistentHashFactory>> getTypeClasses() {
            return Collections.singleton(SyncReplicatedConsistentHashFactory.class);
        }
    }
}

