/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.persistence.impl;

import org.infinispan.commons.io.ByteBuffer;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.marshall.core.MarshalledEntry;
import org.infinispan.marshall.core.MarshalledEntryFactory;
import org.infinispan.marshall.persistence.impl.MarshallableEntryImpl;
import org.infinispan.marshall.persistence.impl.MarshalledEntryImpl;
import org.infinispan.marshall.persistence.impl.MarshalledValueImpl;
import org.infinispan.metadata.InternalMetadata;
import org.infinispan.metadata.Metadata;
import org.infinispan.persistence.spi.MarshallableEntry;
import org.infinispan.persistence.spi.MarshallableEntryFactory;
import org.infinispan.persistence.spi.MarshalledValue;

@Scope(value=Scopes.NAMED_CACHE)
public class MarshalledEntryFactoryImpl
implements MarshalledEntryFactory,
MarshallableEntryFactory {
    private static final MarshallableEntry EMPTY = new MarshalledEntryImpl(null, null, (ByteBuffer)null, null);
    @Inject
    @ComponentName(value="org.infinispan.marshaller.persistence")
    Marshaller marshaller;

    public MarshalledEntryFactoryImpl() {
    }

    public MarshalledEntryFactoryImpl(Marshaller marshaller) {
        this.marshaller = marshaller;
    }

    public MarshallableEntry create(ByteBuffer key, ByteBuffer valueBytes) {
        return this.create(key, valueBytes, (ByteBuffer)null, -1L, -1L);
    }

    public MarshallableEntry create(ByteBuffer key, ByteBuffer valueBytes, ByteBuffer metadataBytes, long created, long lastUsed) {
        return new MarshallableEntryImpl(key, valueBytes, metadataBytes, created, lastUsed, this.marshaller);
    }

    public MarshallableEntry create(Object key, ByteBuffer valueBytes, ByteBuffer metadataBytes, long created, long lastUsed) {
        return new MarshallableEntryImpl(key, valueBytes, metadataBytes, created, lastUsed, this.marshaller);
    }

    public MarshallableEntry create(Object key) {
        return this.create(key, MarshalledValueImpl.EMPTY);
    }

    public MarshallableEntry create(Object key, Object value) {
        return this.create(key, value, null, -1L, -1L);
    }

    public MarshallableEntry create(Object key, Object value, Metadata metadata, long created, long lastUsed) {
        return new MarshallableEntryImpl<Object, Object>(key, value, metadata, created, lastUsed, this.marshaller);
    }

    public MarshallableEntry create(Object key, MarshalledValue value) {
        return new MarshallableEntryImpl(key, value.getValueBytes(), value.getMetadataBytes(), value.getCreated(), value.getLastUsed(), this.marshaller);
    }

    public MarshallableEntry getEmpty() {
        return EMPTY;
    }

    public MarshalledEntry newMarshalledEntry(ByteBuffer key, ByteBuffer valueBytes, ByteBuffer metadataBytes) {
        return new MarshalledEntryImpl(key, valueBytes, metadataBytes, this.marshaller);
    }

    public MarshalledEntry newMarshalledEntry(Object key, ByteBuffer valueBytes, ByteBuffer metadataBytes) {
        return new MarshalledEntryImpl(key, valueBytes, metadataBytes, this.marshaller);
    }

    public MarshalledEntry newMarshalledEntry(Object key, Object value, InternalMetadata im) {
        return new MarshalledEntryImpl<Object, Object>(key, value, im, this.marshaller);
    }
}

