/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.cfg;

import java.lang.annotation.ElementType;
import java.util.HashMap;
import org.apache.lucene.analysis.util.TokenizerFactory;
import org.hibernate.search.analyzer.Discriminator;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.cfg.AnalyzerDefMapping;
import org.hibernate.search.cfg.ClassBridgeMapping;
import org.hibernate.search.cfg.EntityDescriptor;
import org.hibernate.search.cfg.EntitySpatialMapping;
import org.hibernate.search.cfg.FullTextFilterDefMapping;
import org.hibernate.search.cfg.IndexedMapping;
import org.hibernate.search.cfg.NormalizerDefMapping;
import org.hibernate.search.cfg.PropertyMapping;
import org.hibernate.search.cfg.SearchMapping;
import org.hibernate.search.engine.BoostStrategy;

public class EntityMapping {
    private final SearchMapping mapping;
    private final EntityDescriptor entity;

    public EntityMapping(Class<?> entityType, SearchMapping mapping) {
        this.mapping = mapping;
        this.entity = mapping.getEntity(entityType);
    }

    public IndexedMapping indexed() {
        return new IndexedMapping(this.mapping, this.entity);
    }

    public EntitySpatialMapping spatial() {
        return new EntitySpatialMapping(this.mapping, this.entity);
    }

    public EntityMapping boost(float boost) {
        HashMap<String, Object> boostAnn = new HashMap<String, Object>();
        boostAnn.put("value", Float.valueOf(boost));
        this.entity.setBoost(boostAnn);
        return this;
    }

    @Deprecated
    public EntityMapping dynamicBoost(Class<? extends BoostStrategy> impl) {
        HashMap<String, Object> dynamicBoost = new HashMap<String, Object>();
        dynamicBoost.put("impl", impl);
        this.entity.setDynamicBoost(dynamicBoost);
        return this;
    }

    public EntityMapping analyzerDiscriminator(Class<? extends Discriminator> discriminator) {
        HashMap<String, Object> discriminatorAnn = new HashMap<String, Object>();
        discriminatorAnn.put("impl", discriminator);
        this.entity.setAnalyzerDiscriminator(discriminatorAnn);
        return this;
    }

    public FullTextFilterDefMapping fullTextFilterDef(String name, Class<?> impl) {
        return new FullTextFilterDefMapping(this.mapping, name, impl);
    }

    public PropertyMapping property(String name, ElementType type) {
        return new PropertyMapping(name, type, this.entity, this.mapping);
    }

    public AnalyzerDefMapping analyzerDef(String name, Class<? extends TokenizerFactory> tokenizerFactory) {
        return this.analyzerDef(name, "", tokenizerFactory);
    }

    public AnalyzerDefMapping analyzerDef(String name, String tokenizerName, Class<? extends TokenizerFactory> tokenizerFactory) {
        return new AnalyzerDefMapping(name, tokenizerName, tokenizerFactory, this.mapping);
    }

    public NormalizerDefMapping normalizerDef(String name) {
        return new NormalizerDefMapping(name, this.mapping);
    }

    public EntityMapping entity(Class<?> entityType) {
        return new EntityMapping(entityType, this.mapping);
    }

    public ClassBridgeMapping classBridge(Class<?> impl) {
        return new ClassBridgeMapping(this.mapping, this.entity, impl);
    }

    public ClassBridgeMapping classBridgeInstance(FieldBridge classBridge) {
        return new ClassBridgeMapping(this.mapping, this.entity, classBridge);
    }
}

