/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.opentracing;

import java.util.Collection;
import java.util.Collections;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.registry.RuntimePackageDependency;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.extension.microprofile.opentracing.JaegerTracerConfigurationDefinition;
import org.wildfly.extension.microprofile.opentracing.SubsystemAdd;
import org.wildfly.extension.microprofile.opentracing.SubsystemExtension;
import org.wildfly.microprofile.opentracing.smallrye.TracerConfiguration;

public class SubsystemDefinition
extends PersistentResourceDefinition {
    private static final String OPENTRACING_CAPABILITY_NAME = "org.wildfly.microprofile.opentracing";
    public static final String DEFAULT_TRACER_CAPABILITY_NAME = "org.wildfly.microprofile.opentracing.default-tracer";
    private static final RuntimeCapability<Void> OPENTRACING_CAPABILITY = RuntimeCapability.Builder.of((String)"org.wildfly.microprofile.opentracing").addRequirements(new String[]{"org.wildfly.weld"}).build();
    public static final RuntimeCapability<Void> DEFAULT_TRACER_CAPABILITY = RuntimeCapability.Builder.of((String)"org.wildfly.microprofile.opentracing.default-tracer", (boolean)false, TracerConfiguration.class).build();
    public static final RuntimeCapability<Void> TRACER_CAPABILITY = RuntimeCapability.Builder.of((String)"org.wildfly.microprofile.opentracing.tracer", (boolean)true, TracerConfiguration.class).build();
    static final String[] MODULES = new String[]{"io.opentracing.contrib.opentracing-tracerresolver", "io.opentracing.opentracing-api", "io.opentracing.opentracing-util", "org.eclipse.microprofile.opentracing", "org.eclipse.microprofile.restclient", "io.opentracing.contrib.opentracing-jaxrs2"};
    static final String[] EXPORTED_MODULES = new String[]{"io.smallrye.opentracing", "org.wildfly.microprofile.opentracing-smallrye", "io.opentracing.contrib.opentracing-interceptors"};
    public static final SimpleAttributeDefinition DEFAULT_TRACER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"default-tracer", (ModelType)ModelType.STRING, (boolean)true).setCapabilityReference("org.wildfly.microprofile.opentracing.tracer")).setRestartAllServices()).build();

    protected SubsystemDefinition() {
        super(new SimpleResourceDefinition.Parameters(SubsystemExtension.SUBSYSTEM_PATH, SubsystemExtension.getResourceDescriptionResolver(new String[0])).setAddHandler((OperationStepHandler)SubsystemAdd.INSTANCE).setRemoveHandler((OperationStepHandler)new SubsystemRemoveHandler()).setCapabilities(new RuntimeCapability[]{OPENTRACING_CAPABILITY}));
    }

    public void registerChildren(ManagementResourceRegistration resourceRegistration) {
        super.registerChildren(resourceRegistration);
        resourceRegistration.registerSubModel((ResourceDefinition)new JaegerTracerConfigurationDefinition());
    }

    public Collection<AttributeDefinition> getAttributes() {
        return Collections.singletonList(DEFAULT_TRACER);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)DEFAULT_TRACER, null, (OperationStepHandler)new DefaultTracerWriteAttributeHandler());
    }

    public void registerAdditionalRuntimePackages(ManagementResourceRegistration resourceRegistration) {
        for (String m : MODULES) {
            resourceRegistration.registerAdditionalRuntimePackages(new RuntimePackageDependency[]{RuntimePackageDependency.required((String)m)});
        }
        for (String m : EXPORTED_MODULES) {
            resourceRegistration.registerAdditionalRuntimePackages(new RuntimePackageDependency[]{RuntimePackageDependency.required((String)m)});
        }
    }

    private static final class SubsystemRemoveHandler
    extends ReloadRequiredRemoveStepHandler {
        private SubsystemRemoveHandler() {
        }

        protected void recordCapabilitiesAndRequirements(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
            super.recordCapabilitiesAndRequirements(context, operation, resource);
            ModelNode defaultTracer = DEFAULT_TRACER.resolveModelAttribute(context, resource.getModel());
            if (defaultTracer.isDefined()) {
                context.deregisterCapability(SubsystemDefinition.DEFAULT_TRACER_CAPABILITY_NAME);
            }
        }
    }

    private static final class DefaultTracerWriteAttributeHandler
    extends ReloadRequiredWriteAttributeHandler {
        private DefaultTracerWriteAttributeHandler() {
            super(new AttributeDefinition[]{DEFAULT_TRACER});
        }

        protected void recordCapabilitiesAndRequirements(OperationContext context, AttributeDefinition attributeDefinition, ModelNode newValue, ModelNode oldValue) {
            if (oldValue.isDefined()) {
                context.deregisterCapability(SubsystemDefinition.DEFAULT_TRACER_CAPABILITY_NAME);
            }
            if (newValue.isDefined()) {
                context.registerCapability(DEFAULT_TRACER_CAPABILITY);
            }
        }
    }
}

