/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.structure;

import java.util.EnumSet;
import java.util.Map;
import java.util.Properties;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.ee.metadata.EJBClientDescriptorMetaData;
import org.jboss.as.ee.structure.EJBClientDescriptor10Parser;
import org.jboss.as.ee.structure.EJBClientDescriptorXMLAttribute;
import org.jboss.as.ee.structure.EJBClientDescriptorXMLElement;
import org.jboss.metadata.property.PropertyReplacer;
import org.jboss.staxmapper.XMLExtendedStreamReader;

class EJBClientDescriptor11Parser
extends EJBClientDescriptor10Parser {
    public static final String NAMESPACE_1_1 = "urn:jboss:ejb-client:1.1";

    protected EJBClientDescriptor11Parser(PropertyReplacer propertyReplacer) {
        super(propertyReplacer);
    }

    @Override
    protected void parseClientContext(XMLExtendedStreamReader reader, EJBClientDescriptorMetaData ejbClientDescriptorMetaData) throws XMLStreamException {
        EnumSet<EJBClientDescriptorXMLElement> visited = EnumSet.noneOf(EJBClientDescriptorXMLElement.class);
        block8: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    EJBClientDescriptorXMLElement element = EJBClientDescriptorXMLElement.forName(reader.getLocalName());
                    if (visited.contains((Object)element)) {
                        EJBClientDescriptor11Parser.unexpectedElement(reader);
                    }
                    visited.add(element);
                    switch (element) {
                        case EJB_RECEIVERS: {
                            this.parseEJBReceivers(reader, ejbClientDescriptorMetaData);
                            continue block8;
                        }
                        case CLUSTERS: {
                            this.parseClusters(reader, ejbClientDescriptorMetaData);
                            continue block8;
                        }
                    }
                    EJBClientDescriptor11Parser.unexpectedElement(reader);
                    continue block8;
                }
            }
            EJBClientDescriptor11Parser.unexpectedContent((XMLStreamReader)reader);
        }
        EJBClientDescriptor11Parser.unexpectedEndOfDocument(reader.getLocation());
    }

    protected void parseClusters(XMLExtendedStreamReader reader, EJBClientDescriptorMetaData ejbClientDescriptorMetaData) throws XMLStreamException {
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    EJBClientDescriptorXMLElement element = EJBClientDescriptorXMLElement.forName(reader.getLocalName());
                    switch (element) {
                        case CLUSTER: {
                            this.parseCluster(reader, ejbClientDescriptorMetaData);
                            continue block7;
                        }
                    }
                    EJBClientDescriptor11Parser.unexpectedElement(reader);
                    continue block7;
                }
            }
            EJBClientDescriptor11Parser.unexpectedContent((XMLStreamReader)reader);
        }
        EJBClientDescriptor11Parser.unexpectedEndOfDocument(reader.getLocation());
    }

    protected void parseCluster(XMLExtendedStreamReader reader, EJBClientDescriptorMetaData ejbClientDescriptorMetaData) throws XMLStreamException {
        EnumSet<EJBClientDescriptorXMLAttribute> required = EnumSet.of(EJBClientDescriptorXMLAttribute.NAME);
        int count = reader.getAttributeCount();
        String clusterName = null;
        String clusterNodeSelector = null;
        long connectTimeout = 5000L;
        long maxAllowedConnectedNodes = 10L;
        String userName = null;
        String securityRealm = null;
        block17: for (int i = 0; i < count; ++i) {
            EJBClientDescriptorXMLAttribute attribute = EJBClientDescriptorXMLAttribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            String value = this.readResolveValue(reader, i);
            switch (attribute) {
                case NAME: {
                    clusterName = value;
                    continue block17;
                }
                case CONNECT_TIMEOUT: {
                    connectTimeout = Long.parseLong(value);
                    continue block17;
                }
                case CLUSTER_NODE_SELECTOR: {
                    clusterNodeSelector = value;
                    continue block17;
                }
                case MAX_ALLOWED_CONNECTED_NODES: {
                    maxAllowedConnectedNodes = Long.parseLong(value);
                    continue block17;
                }
                case USERNAME: {
                    userName = value;
                    continue block17;
                }
                case SECURITY_REALM: {
                    securityRealm = value;
                    continue block17;
                }
                default: {
                    EJBClientDescriptor11Parser.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        if (!required.isEmpty()) {
            EJBClientDescriptor11Parser.missingAttributes(reader.getLocation(), required);
        }
        EJBClientDescriptorMetaData.ClusterConfig clusterConfig = ejbClientDescriptorMetaData.newClusterConfig(clusterName);
        clusterConfig.setConnectTimeout(connectTimeout);
        clusterConfig.setNodeSelector(clusterNodeSelector);
        clusterConfig.setMaxAllowedConnectedNodes(maxAllowedConnectedNodes);
        clusterConfig.setSecurityRealm(securityRealm);
        clusterConfig.setUserName(userName);
        block18: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    EJBClientDescriptorXMLElement element = EJBClientDescriptorXMLElement.forName(reader.getLocalName());
                    switch (element) {
                        case CONNECTION_CREATION_OPTIONS: {
                            Properties connectionCreationOptions = this.parseConnectionCreationOptions(reader);
                            clusterConfig.setConnectionOptions(connectionCreationOptions);
                            continue block18;
                        }
                        case CHANNEL_CREATION_OPTIONS: {
                            Properties channelCreationOptions = this.parseChannelCreationOptions(reader);
                            clusterConfig.setChannelCreationOptions(channelCreationOptions);
                            continue block18;
                        }
                        case NODE: {
                            this.parseClusterNode(reader, clusterConfig);
                            continue block18;
                        }
                    }
                    EJBClientDescriptor11Parser.unexpectedElement(reader);
                    continue block18;
                }
            }
            EJBClientDescriptor11Parser.unexpectedContent((XMLStreamReader)reader);
        }
        EJBClientDescriptor11Parser.unexpectedEndOfDocument(reader.getLocation());
    }

    protected Properties parseConnectionCreationOptions(XMLExtendedStreamReader reader) throws XMLStreamException {
        Properties connectionCreationOptions = new Properties();
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return connectionCreationOptions;
                }
                case 1: {
                    EJBClientDescriptorXMLElement element = EJBClientDescriptorXMLElement.forName(reader.getLocalName());
                    switch (element) {
                        case PROPERTY: {
                            connectionCreationOptions.putAll((Map<?, ?>)this.parseProperty(reader));
                            continue block7;
                        }
                    }
                    EJBClientDescriptor11Parser.unexpectedElement(reader);
                    continue block7;
                }
            }
            EJBClientDescriptor11Parser.unexpectedContent((XMLStreamReader)reader);
        }
        EJBClientDescriptor11Parser.unexpectedEndOfDocument(reader.getLocation());
        return connectionCreationOptions;
    }

    protected Properties parseChannelCreationOptions(XMLExtendedStreamReader reader) throws XMLStreamException {
        Properties channelCreationOptions = new Properties();
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return channelCreationOptions;
                }
                case 1: {
                    EJBClientDescriptorXMLElement element = EJBClientDescriptorXMLElement.forName(reader.getLocalName());
                    switch (element) {
                        case PROPERTY: {
                            channelCreationOptions.putAll((Map<?, ?>)this.parseProperty(reader));
                            continue block7;
                        }
                    }
                    EJBClientDescriptor11Parser.unexpectedElement(reader);
                    continue block7;
                }
            }
            EJBClientDescriptor11Parser.unexpectedContent((XMLStreamReader)reader);
        }
        EJBClientDescriptor11Parser.unexpectedEndOfDocument(reader.getLocation());
        return channelCreationOptions;
    }

    protected void parseClusterNode(XMLExtendedStreamReader reader, EJBClientDescriptorMetaData.ClusterConfig clusterConfig) throws XMLStreamException {
        EnumSet<EJBClientDescriptorXMLAttribute> required = EnumSet.of(EJBClientDescriptorXMLAttribute.NAME);
        int count = reader.getAttributeCount();
        String nodeName = null;
        long connectTimeout = 5000L;
        String userName = null;
        String securityRealm = null;
        block14: for (int i = 0; i < count; ++i) {
            EJBClientDescriptorXMLAttribute attribute = EJBClientDescriptorXMLAttribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            String value = this.readResolveValue(reader, i);
            switch (attribute) {
                case NAME: {
                    nodeName = value;
                    continue block14;
                }
                case CONNECT_TIMEOUT: {
                    connectTimeout = Long.parseLong(value);
                    continue block14;
                }
                case USERNAME: {
                    userName = value;
                    continue block14;
                }
                case SECURITY_REALM: {
                    securityRealm = value;
                    continue block14;
                }
                default: {
                    EJBClientDescriptor11Parser.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        if (!required.isEmpty()) {
            EJBClientDescriptor11Parser.missingAttributes(reader.getLocation(), required);
        }
        EJBClientDescriptorMetaData.ClusterNodeConfig clusterNodeConfig = clusterConfig.newClusterNode(nodeName);
        clusterNodeConfig.setConnectTimeout(connectTimeout);
        clusterNodeConfig.setSecurityRealm(securityRealm);
        clusterNodeConfig.setUserName(userName);
        block15: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    EJBClientDescriptorXMLElement element = EJBClientDescriptorXMLElement.forName(reader.getLocalName());
                    switch (element) {
                        case CONNECTION_CREATION_OPTIONS: {
                            Properties connectionCreationOptions = this.parseConnectionCreationOptions(reader);
                            clusterNodeConfig.setConnectionOptions(connectionCreationOptions);
                            continue block15;
                        }
                        case CHANNEL_CREATION_OPTIONS: {
                            Properties channelCreationOptions = this.parseChannelCreationOptions(reader);
                            clusterNodeConfig.setChannelCreationOptions(channelCreationOptions);
                            continue block15;
                        }
                    }
                    EJBClientDescriptor11Parser.unexpectedElement(reader);
                    continue block15;
                }
            }
            EJBClientDescriptor11Parser.unexpectedContent((XMLStreamReader)reader);
        }
        EJBClientDescriptor11Parser.unexpectedEndOfDocument(reader.getLocation());
    }

    protected Properties parseProperty(XMLExtendedStreamReader reader) throws XMLStreamException {
        EnumSet<EJBClientDescriptorXMLAttribute> required = EnumSet.of(EJBClientDescriptorXMLAttribute.NAME, EJBClientDescriptorXMLAttribute.VALUE);
        int count = reader.getAttributeCount();
        String name = null;
        String value = null;
        block4: for (int i = 0; i < count; ++i) {
            EJBClientDescriptorXMLAttribute attribute = EJBClientDescriptorXMLAttribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            String val = this.readResolveValue(reader, i);
            switch (attribute) {
                case NAME: {
                    name = val;
                    continue block4;
                }
                case VALUE: {
                    value = val;
                    continue block4;
                }
                default: {
                    EJBClientDescriptor11Parser.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        if (!required.isEmpty()) {
            EJBClientDescriptor11Parser.missingAttributes(reader.getLocation(), required);
        }
        EJBClientDescriptor11Parser.requireNoContent(reader);
        Properties property = new Properties();
        property.put(name, value);
        return property;
    }

    protected static void requireNoContent(XMLExtendedStreamReader reader) throws XMLStreamException {
        if (reader.hasNext() && reader.nextTag() != 2) {
            EJBClientDescriptor11Parser.unexpectedElement(reader);
        }
    }
}

