/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.ldap.idm.query.internal;

import java.util.Date;
import org.keycloak.storage.ldap.idm.query.EscapeStrategy;
import org.keycloak.storage.ldap.idm.query.internal.NamedParameterCondition;
import org.keycloak.storage.ldap.idm.query.internal.OctetStringEncoder;
import org.keycloak.storage.ldap.idm.store.ldap.LDAPUtil;

public class EqualCondition
extends NamedParameterCondition {
    private final EscapeStrategy escapeStrategy;
    private Object value;

    public EqualCondition(String name, Object value, EscapeStrategy escapeStrategy) {
        super(name);
        this.value = value;
        this.escapeStrategy = escapeStrategy;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public EscapeStrategy getEscapeStrategy() {
        return this.escapeStrategy;
    }

    @Override
    public void applyCondition(StringBuilder filter) {
        Object parameterValue = this.value;
        if (Date.class.isInstance(this.value)) {
            parameterValue = LDAPUtil.formatDate((Date)parameterValue);
        }
        String escaped = new OctetStringEncoder(this.escapeStrategy).encode(parameterValue, this.isBinary());
        filter.append("(").append(this.getParameterName()).append("=").append(escaped).append(")");
    }

    public String toString() {
        return "EqualCondition{paramName=" + this.getParameterName() + ", value=" + this.value + ", escapeStrategy=" + (Object)((Object)this.escapeStrategy) + '}';
    }
}

