/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.representations.idm.GroupRepresentation;
import org.keycloak.services.ErrorResponse;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.GroupResource;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;

public class GroupsResource {
    private final RealmModel realm;
    private final KeycloakSession session;
    private final AdminPermissionEvaluator auth;
    private final AdminEventBuilder adminEvent;

    public GroupsResource(RealmModel realm, KeycloakSession session, AdminPermissionEvaluator auth, AdminEventBuilder adminEvent) {
        this.realm = realm;
        this.session = session;
        this.auth = auth;
        this.adminEvent = adminEvent.resource(ResourceType.GROUP);
    }

    @GET
    @NoCache
    @Produces(value={"application/json"})
    public List<GroupRepresentation> getGroups(@QueryParam(value="search") String search, @QueryParam(value="first") Integer firstResult, @QueryParam(value="max") Integer maxResults, @QueryParam(value="briefRepresentation") @DefaultValue(value="true") boolean briefRepresentation) {
        this.auth.groups().requireList();
        List results = Objects.nonNull(search) ? ModelToRepresentation.searchForGroupByName((RealmModel)this.realm, (!briefRepresentation ? 1 : 0) != 0, (String)search.trim(), (Integer)firstResult, (Integer)maxResults) : (Objects.nonNull(firstResult) && Objects.nonNull(maxResults) ? ModelToRepresentation.toGroupHierarchy((RealmModel)this.realm, (!briefRepresentation ? 1 : 0) != 0, (Integer)firstResult, (Integer)maxResults) : ModelToRepresentation.toGroupHierarchy((RealmModel)this.realm, (!briefRepresentation ? 1 : 0) != 0));
        return results;
    }

    @Path(value="{id}")
    public GroupResource getGroupById(@PathParam(value="id") String id) {
        GroupModel group = this.realm.getGroupById(id);
        if (group == null) {
            throw new NotFoundException("Could not find group by id");
        }
        GroupResource resource = new GroupResource(this.realm, group, this.session, this.auth, this.adminEvent);
        ResteasyProviderFactory.getInstance().injectProperties((Object)resource);
        return resource;
    }

    @GET
    @NoCache
    @Path(value="count")
    @Produces(value={"application/json"})
    public Map<String, Long> getGroupCount(@QueryParam(value="search") String search, @QueryParam(value="top") @DefaultValue(value="false") boolean onlyTopGroups) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        Long results = Objects.nonNull(search) ? this.realm.getGroupsCountByNameContaining(search) : this.realm.getGroupsCount(Boolean.valueOf(onlyTopGroups));
        map.put("count", results);
        return map;
    }

    @POST
    @Consumes(value={"application/json"})
    public Response addTopLevelGroup(GroupRepresentation rep) {
        this.auth.groups().requireManage();
        Response.ResponseBuilder builder = Response.status((int)204);
        try {
            if (rep.getId() != null) {
                GroupModel child = this.realm.getGroupById(rep.getId());
                if (child == null) {
                    throw new NotFoundException("Could not find child by id");
                }
                this.realm.moveGroup(child, null);
                this.adminEvent.operation(OperationType.UPDATE).resourcePath((UriInfo)this.session.getContext().getUri());
            } else {
                GroupModel child = this.realm.createGroup(rep.getName());
                GroupResource.updateGroup(rep, child);
                URI uri = this.session.getContext().getUri().getAbsolutePathBuilder().path(child.getId()).build(new Object[0]);
                builder.status(201).location(uri);
                rep.setId(child.getId());
                this.adminEvent.operation(OperationType.CREATE).resourcePath((UriInfo)this.session.getContext().getUri(), child.getId());
            }
        }
        catch (ModelDuplicateException mde) {
            return ErrorResponse.exists("Top level group named '" + rep.getName() + "' already exists.");
        }
        this.adminEvent.representation(rep).success();
        return builder.build();
    }
}

