/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.ModelOnlyAddStepHandler;
import org.jboss.as.controller.ModelOnlyResourceDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PrimitiveListAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.messaging.AlternativeAttributeCheckHandler;
import org.jboss.as.messaging.AttributeMarshallers;
import org.jboss.as.messaging.CommonAttributes;
import org.jboss.as.messaging.MessagingExtension;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class BridgeDefinition
extends ModelOnlyResourceDefinition {
    public static final PathElement PATH = PathElement.pathElement((String)"bridge");
    public static final PrimitiveListAttributeDefinition CONNECTOR_REFS = ((PrimitiveListAttributeDefinition.Builder)((PrimitiveListAttributeDefinition.Builder)((PrimitiveListAttributeDefinition.Builder)((PrimitiveListAttributeDefinition.Builder)((PrimitiveListAttributeDefinition.Builder)((PrimitiveListAttributeDefinition.Builder)PrimitiveListAttributeDefinition.Builder.of((String)"static-connectors", (ModelType)ModelType.STRING).setRequired(false)).setAlternatives(new String[]{"discovery-group-name"})).setElementValidator((ParameterValidator)new StringLengthValidator(1))).setXmlName("connector-ref")).setAttributeMarshaller((AttributeMarshaller)new AttributeMarshallers.WrappedListAttributeMarshaller("static-connectors"))).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition DISCOVERY_GROUP_NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"discovery-group-name", (ModelType)ModelType.STRING).setRequired(false)).setAlternatives(new String[]{"static-connectors"})).setAttributeMarshaller(AttributeMarshallers.DISCOVERY_GROUP_MARSHALLER)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition INITIAL_CONNECT_ATTEMPTS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"initial-connect-attempts", (ModelType)ModelType.INT).setRequired(false)).setDefaultValue(new ModelNode().set(-1))).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition QUEUE_NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"queue-name", (ModelType)ModelType.STRING).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition PASSWORD = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"password", (ModelType)ModelType.STRING).setRequired(false)).setAllowExpression(true)).setDefaultValue(new ModelNode().set("CHANGE ME!!"))).setRestartAllServices()).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.CREDENTIAL)).addAccessConstraint((AccessConstraintDefinition)CommonAttributes.MESSAGING_SECURITY_DEF)).build();
    public static final SimpleAttributeDefinition USER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"user", (ModelType)ModelType.STRING).setRequired(false)).setAllowExpression(true)).setDefaultValue(new ModelNode().set("HORNETQ.CLUSTER.ADMIN.USER"))).setRestartAllServices()).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.CREDENTIAL)).addAccessConstraint((AccessConstraintDefinition)CommonAttributes.MESSAGING_SECURITY_DEF)).build();
    public static final SimpleAttributeDefinition USE_DUPLICATE_DETECTION = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"use-duplicate-detection", (ModelType)ModelType.BOOLEAN).setRequired(false)).setDefaultValue(ModelNode.TRUE)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition RECONNECT_ATTEMPTS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"reconnect-attempts", (ModelType)ModelType.INT).setRequired(false)).setDefaultValue(new ModelNode().set(-1))).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition RECONNECT_ATTEMPTS_ON_SAME_NODE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"reconnect-attempts-on-same-node", (ModelType)ModelType.INT).setRequired(false)).setDefaultValue(new ModelNode().set(10))).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition FORWARDING_ADDRESS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"forwarding-address", (ModelType)ModelType.STRING).setRequired(false)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{QUEUE_NAME, FORWARDING_ADDRESS, CommonAttributes.HA, CommonAttributes.FILTER, CommonAttributes.TRANSFORMER_CLASS_NAME, CommonAttributes.MIN_LARGE_MESSAGE_SIZE, CommonAttributes.CHECK_PERIOD, CommonAttributes.CONNECTION_TTL, CommonAttributes.RETRY_INTERVAL, CommonAttributes.RETRY_INTERVAL_MULTIPLIER, CommonAttributes.MAX_RETRY_INTERVAL, INITIAL_CONNECT_ATTEMPTS, RECONNECT_ATTEMPTS, RECONNECT_ATTEMPTS_ON_SAME_NODE, CommonAttributes.FAILOVER_ON_SERVER_SHUTDOWN, USE_DUPLICATE_DETECTION, CommonAttributes.BRIDGE_CONFIRMATION_WINDOW_SIZE, USER, PASSWORD, CONNECTOR_REFS, DISCOVERY_GROUP_NAME};
    public static final AttributeDefinition[] ATTRIBUTES_WITH_EXPRESSION_ALLOWED_IN_1_2_0 = new AttributeDefinition[]{QUEUE_NAME, USE_DUPLICATE_DETECTION, RECONNECT_ATTEMPTS, FORWARDING_ADDRESS, CommonAttributes.FILTER, CommonAttributes.HA, CommonAttributes.MIN_LARGE_MESSAGE_SIZE, CommonAttributes.CHECK_PERIOD, CommonAttributes.CONNECTION_TTL, CommonAttributes.RETRY_INTERVAL, CommonAttributes.RETRY_INTERVAL_MULTIPLIER, CommonAttributes.MAX_RETRY_INTERVAL, CommonAttributes.BRIDGE_CONFIRMATION_WINDOW_SIZE};
    static final BridgeDefinition INSTANCE = new BridgeDefinition();

    private BridgeDefinition() {
        super(PATH, MessagingExtension.getResourceDescriptionResolver("bridge"), new ModelOnlyAddStepHandler(ATTRIBUTES){

            protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
                super.populateModel(context, operation, resource);
                AlternativeAttributeCheckHandler.checkAlternatives(operation, CONNECTOR_REFS.getName(), DISCOVERY_GROUP_NAME.getName(), false);
            }
        }, ATTRIBUTES);
        this.setDeprecated(MessagingExtension.DEPRECATED_SINCE);
    }
}

